/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.datastore.config;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import org.opendaylight.controller.cluster.access.concepts.MemberName;
import org.opendaylight.mdsal.dom.api.DOMDataTreeIdentifier;

public class PrefixShardConfiguration
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final DOMDataTreeIdentifier prefix;
    private final String shardStrategyName;
    private final Collection<MemberName> shardMemberNames;

    public PrefixShardConfiguration(DOMDataTreeIdentifier prefix, String shardStrategyName, Collection<MemberName> shardMemberNames) {
        this.prefix = (DOMDataTreeIdentifier)Preconditions.checkNotNull((Object)prefix);
        this.shardStrategyName = (String)Preconditions.checkNotNull((Object)shardStrategyName);
        this.shardMemberNames = ImmutableSet.copyOf(shardMemberNames);
    }

    public DOMDataTreeIdentifier getPrefix() {
        return this.prefix;
    }

    public String getShardStrategyName() {
        return this.shardStrategyName;
    }

    public Collection<MemberName> getShardMemberNames() {
        return this.shardMemberNames;
    }

    public String toString() {
        return "PrefixShardConfiguration{prefix=" + this.prefix + ", shardStrategyName='" + this.shardStrategyName + '\'' + ", shardMemberNames=" + this.shardMemberNames + '}';
    }

    private Object writeReplace() {
        return new Proxy(this);
    }

    private static final class Proxy
    implements Externalizable {
        private static final long serialVersionUID = 1L;
        private PrefixShardConfiguration prefixShardConfiguration;

        public Proxy() {
        }

        Proxy(PrefixShardConfiguration prefixShardConfiguration) {
            this.prefixShardConfiguration = prefixShardConfiguration;
        }

        @Override
        public void writeExternal(ObjectOutput objectOutput) throws IOException {
            objectOutput.writeObject(this.prefixShardConfiguration.getPrefix());
            objectOutput.writeObject(this.prefixShardConfiguration.getShardStrategyName());
            objectOutput.writeInt(this.prefixShardConfiguration.getShardMemberNames().size());
            for (MemberName name : this.prefixShardConfiguration.getShardMemberNames()) {
                name.writeTo((DataOutput)objectOutput);
            }
        }

        @Override
        public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
            DOMDataTreeIdentifier localPrefix = (DOMDataTreeIdentifier)objectInput.readObject();
            String localStrategyName = (String)objectInput.readObject();
            int size = objectInput.readInt();
            ArrayList<MemberName> localShardMemberNames = new ArrayList<MemberName>(size);
            for (int i = 0; i < size; ++i) {
                localShardMemberNames.add(MemberName.readFrom((DataInput)objectInput));
            }
            this.prefixShardConfiguration = new PrefixShardConfiguration(localPrefix, localStrategyName, localShardMemberNames);
        }

        private Object readResolve() {
            return this.prefixShardConfiguration;
        }
    }
}

