/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.datastore.entityownership;

import akka.actor.ActorRef;
import akka.dispatch.OnComplete;
import akka.pattern.Patterns;
import akka.util.Timeout;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.util.Collection;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import org.opendaylight.controller.cluster.access.concepts.MemberName;
import org.opendaylight.controller.cluster.datastore.config.Configuration;
import org.opendaylight.controller.cluster.datastore.config.ModuleShardConfiguration;
import org.opendaylight.controller.cluster.datastore.entityownership.DistributedEntityOwnershipCandidateRegistration;
import org.opendaylight.controller.cluster.datastore.entityownership.DistributedEntityOwnershipListenerRegistration;
import org.opendaylight.controller.cluster.datastore.entityownership.EntityOwnersModel;
import org.opendaylight.controller.cluster.datastore.entityownership.EntityOwnershipShard;
import org.opendaylight.controller.cluster.datastore.entityownership.messages.RegisterCandidateLocal;
import org.opendaylight.controller.cluster.datastore.entityownership.messages.RegisterListenerLocal;
import org.opendaylight.controller.cluster.datastore.entityownership.messages.UnregisterCandidateLocal;
import org.opendaylight.controller.cluster.datastore.entityownership.messages.UnregisterListenerLocal;
import org.opendaylight.controller.cluster.datastore.entityownership.selectionstrategy.EntityOwnerSelectionStrategyConfig;
import org.opendaylight.controller.cluster.datastore.messages.CreateShard;
import org.opendaylight.controller.cluster.datastore.messages.GetShardDataTree;
import org.opendaylight.controller.cluster.datastore.utils.ActorContext;
import org.opendaylight.mdsal.eos.common.api.CandidateAlreadyRegisteredException;
import org.opendaylight.mdsal.eos.common.api.EntityOwnershipState;
import org.opendaylight.mdsal.eos.common.api.GenericEntity;
import org.opendaylight.mdsal.eos.dom.api.DOMEntity;
import org.opendaylight.mdsal.eos.dom.api.DOMEntityOwnershipCandidateRegistration;
import org.opendaylight.mdsal.eos.dom.api.DOMEntityOwnershipListener;
import org.opendaylight.mdsal.eos.dom.api.DOMEntityOwnershipListenerRegistration;
import org.opendaylight.mdsal.eos.dom.api.DOMEntityOwnershipService;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.clustering.entity.owners.rev150804.EntityOwners;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.DataContainerChild;
import org.opendaylight.yangtools.yang.data.api.schema.MapEntryNode;
import org.opendaylight.yangtools.yang.data.api.schema.MapNode;
import org.opendaylight.yangtools.yang.data.api.schema.tree.DataTree;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function1;
import scala.concurrent.Await;
import scala.concurrent.Awaitable;
import scala.concurrent.Future;
import scala.concurrent.duration.Duration;

public class DistributedEntityOwnershipService
implements DOMEntityOwnershipService,
AutoCloseable {
    @VisibleForTesting
    static final String ENTITY_OWNERSHIP_SHARD_NAME = "entity-ownership";
    private static final Logger LOG = LoggerFactory.getLogger(DistributedEntityOwnershipService.class);
    private static final Timeout MESSAGE_TIMEOUT = new Timeout(1L, TimeUnit.MINUTES);
    private final ConcurrentMap<DOMEntity, DOMEntity> registeredEntities = new ConcurrentHashMap<DOMEntity, DOMEntity>();
    private final ActorContext context;
    private volatile ActorRef localEntityOwnershipShard;
    private volatile DataTree localEntityOwnershipShardDataTree;

    DistributedEntityOwnershipService(ActorContext context) {
        this.context = (ActorContext)Preconditions.checkNotNull((Object)context);
    }

    public static DistributedEntityOwnershipService start(ActorContext context, EntityOwnerSelectionStrategyConfig strategyConfig) {
        ActorRef shardManagerActor = context.getShardManager();
        Configuration configuration = context.getConfiguration();
        Collection<MemberName> entityOwnersMemberNames = configuration.getUniqueMemberNamesForAllShards();
        CreateShard createShard = new CreateShard(new ModuleShardConfiguration(EntityOwners.QNAME.getNamespace(), "entity-owners", ENTITY_OWNERSHIP_SHARD_NAME, "module", entityOwnersMemberNames), DistributedEntityOwnershipService.newShardBuilder(context, strategyConfig), null);
        Future<Object> createFuture = context.executeOperationAsync(shardManagerActor, (Object)createShard, MESSAGE_TIMEOUT);
        createFuture.onComplete((Function1)new OnComplete<Object>(){

            public void onComplete(Throwable failure, Object response) {
                if (failure != null) {
                    LOG.error("Failed to create {} shard", (Object)DistributedEntityOwnershipService.ENTITY_OWNERSHIP_SHARD_NAME, (Object)failure);
                } else {
                    LOG.info("Successfully created {} shard", (Object)DistributedEntityOwnershipService.ENTITY_OWNERSHIP_SHARD_NAME);
                }
            }
        }, context.getClientDispatcher());
        return new DistributedEntityOwnershipService(context);
    }

    private void executeEntityOwnershipShardOperation(final ActorRef shardActor, final Object message) {
        Future<Object> future = this.context.executeOperationAsync(shardActor, message, MESSAGE_TIMEOUT);
        future.onComplete((Function1)new OnComplete<Object>(){

            public void onComplete(Throwable failure, Object response) {
                if (failure != null) {
                    LOG.debug("Error sending message {} to {}", new Object[]{message, shardActor, failure});
                } else {
                    LOG.debug("{} message to {} succeeded", message, (Object)shardActor);
                }
            }
        }, this.context.getClientDispatcher());
    }

    @VisibleForTesting
    void executeLocalEntityOwnershipShardOperation(final Object message) {
        if (this.localEntityOwnershipShard == null) {
            Future<ActorRef> future = this.context.findLocalShardAsync(ENTITY_OWNERSHIP_SHARD_NAME);
            future.onComplete((Function1)new OnComplete<ActorRef>(){

                public void onComplete(Throwable failure, ActorRef shardActor) {
                    if (failure != null) {
                        LOG.error("Failed to find local {} shard", (Object)DistributedEntityOwnershipService.ENTITY_OWNERSHIP_SHARD_NAME, (Object)failure);
                    } else {
                        DistributedEntityOwnershipService.this.localEntityOwnershipShard = shardActor;
                        DistributedEntityOwnershipService.this.executeEntityOwnershipShardOperation(DistributedEntityOwnershipService.this.localEntityOwnershipShard, message);
                    }
                }
            }, this.context.getClientDispatcher());
        } else {
            this.executeEntityOwnershipShardOperation(this.localEntityOwnershipShard, message);
        }
    }

    public DOMEntityOwnershipCandidateRegistration registerCandidate(DOMEntity entity) throws CandidateAlreadyRegisteredException {
        Preconditions.checkNotNull((Object)entity, (Object)"entity cannot be null");
        if (this.registeredEntities.putIfAbsent(entity, entity) != null) {
            throw new CandidateAlreadyRegisteredException((GenericEntity)entity);
        }
        RegisterCandidateLocal registerCandidate = new RegisterCandidateLocal(entity);
        LOG.debug("Registering candidate with message: {}", (Object)registerCandidate);
        this.executeLocalEntityOwnershipShardOperation(registerCandidate);
        return new DistributedEntityOwnershipCandidateRegistration(entity, this);
    }

    void unregisterCandidate(DOMEntity entity) {
        LOG.debug("Unregistering candidate for {}", (Object)entity);
        this.executeLocalEntityOwnershipShardOperation(new UnregisterCandidateLocal(entity));
        this.registeredEntities.remove(entity);
    }

    public DOMEntityOwnershipListenerRegistration registerListener(String entityType, DOMEntityOwnershipListener listener) {
        Preconditions.checkNotNull((Object)entityType, (Object)"entityType cannot be null");
        Preconditions.checkNotNull((Object)listener, (Object)"listener cannot be null");
        RegisterListenerLocal registerListener = new RegisterListenerLocal(listener, entityType);
        LOG.debug("Registering listener with message: {}", (Object)registerListener);
        this.executeLocalEntityOwnershipShardOperation(registerListener);
        return new DistributedEntityOwnershipListenerRegistration(listener, entityType, this);
    }

    public com.google.common.base.Optional<EntityOwnershipState> getOwnershipState(DOMEntity forEntity) {
        boolean hasCandidates;
        Preconditions.checkNotNull((Object)forEntity, (Object)"forEntity cannot be null");
        DataTree dataTree = this.getLocalEntityOwnershipShardDataTree();
        if (dataTree == null) {
            return com.google.common.base.Optional.absent();
        }
        Optional entityNode = dataTree.takeSnapshot().readNode(EntityOwnersModel.entityPath(forEntity.getType(), (YangInstanceIdentifier)forEntity.getIdentifier()));
        if (!entityNode.isPresent()) {
            return com.google.common.base.Optional.absent();
        }
        MapEntryNode entity = (MapEntryNode)entityNode.get();
        Optional optionalCandidates = entity.getChild((YangInstanceIdentifier.PathArgument)EntityOwnersModel.CANDIDATE_NODE_ID);
        boolean bl = hasCandidates = optionalCandidates.isPresent() && ((MapNode)optionalCandidates.get()).getValue().size() > 0;
        if (!hasCandidates) {
            return com.google.common.base.Optional.absent();
        }
        MemberName localMemberName = this.context.getCurrentMemberName();
        Optional ownerLeaf = entity.getChild((YangInstanceIdentifier.PathArgument)EntityOwnersModel.ENTITY_OWNER_NODE_ID);
        String owner = ownerLeaf.isPresent() ? ((DataContainerChild)ownerLeaf.get()).getValue().toString() : null;
        boolean hasOwner = !Strings.isNullOrEmpty(owner);
        boolean isOwner = hasOwner && localMemberName.getName().equals(owner);
        return com.google.common.base.Optional.of((Object)EntityOwnershipState.from((boolean)isOwner, (boolean)hasOwner));
    }

    public boolean isCandidateRegistered(@Nonnull DOMEntity entity) {
        return this.registeredEntities.get(entity) != null;
    }

    @VisibleForTesting
    DataTree getLocalEntityOwnershipShardDataTree() {
        if (this.localEntityOwnershipShardDataTree == null) {
            try {
                if (this.localEntityOwnershipShard == null) {
                    this.localEntityOwnershipShard = (ActorRef)Await.result(this.context.findLocalShardAsync(ENTITY_OWNERSHIP_SHARD_NAME), (Duration)Duration.Inf());
                }
                this.localEntityOwnershipShardDataTree = (DataTree)Await.result((Awaitable)Patterns.ask((ActorRef)this.localEntityOwnershipShard, (Object)GetShardDataTree.INSTANCE, (Timeout)MESSAGE_TIMEOUT), (Duration)Duration.Inf());
            }
            catch (Exception e) {
                LOG.error("Failed to find local {} shard", (Object)ENTITY_OWNERSHIP_SHARD_NAME, (Object)e);
            }
        }
        return this.localEntityOwnershipShardDataTree;
    }

    void unregisterListener(String entityType, DOMEntityOwnershipListener listener) {
        LOG.debug("Unregistering listener {} for entity type {}", (Object)listener, (Object)entityType);
        this.executeLocalEntityOwnershipShardOperation(new UnregisterListenerLocal(listener, entityType));
    }

    @Override
    public void close() {
    }

    private static EntityOwnershipShard.Builder newShardBuilder(ActorContext context, EntityOwnerSelectionStrategyConfig strategyConfig) {
        return EntityOwnershipShard.newBuilder().localMemberName(context.getCurrentMemberName()).ownerSelectionStrategyConfig(strategyConfig);
    }

    @VisibleForTesting
    ActorRef getLocalEntityOwnershipShard() {
        return this.localEntityOwnershipShard;
    }
}

