/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.datastore.entityownership.selectionstrategy;

import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;
import org.opendaylight.controller.cluster.datastore.entityownership.selectionstrategy.EntityOwnerSelectionStrategy;
import org.opendaylight.controller.cluster.datastore.entityownership.selectionstrategy.FirstCandidateSelectionStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class EntityOwnerSelectionStrategyConfig {
    private static final Logger LOG = LoggerFactory.getLogger(EntityOwnerSelectionStrategyConfig.class);
    private final Map<String, StrategyInfo> entityTypeToStrategyInfo = new HashMap<String, StrategyInfo>();
    private final Map<String, EntityOwnerSelectionStrategy> entityTypeToOwnerSelectionStrategy = new HashMap<String, EntityOwnerSelectionStrategy>();

    private EntityOwnerSelectionStrategyConfig() {
    }

    public boolean isStrategyConfigured(String entityType) {
        return this.entityTypeToStrategyInfo.get(entityType) != null;
    }

    public EntityOwnerSelectionStrategy createStrategy(String entityType, Map<String, Long> initialStatistics) {
        EntityOwnerSelectionStrategy strategy;
        EntityOwnerSelectionStrategy existingStrategy = this.entityTypeToOwnerSelectionStrategy.get(entityType);
        if (existingStrategy != null) {
            strategy = existingStrategy;
        } else {
            StrategyInfo strategyInfo = this.entityTypeToStrategyInfo.get(entityType);
            strategy = strategyInfo == null ? FirstCandidateSelectionStrategy.INSTANCE : strategyInfo.createStrategy(initialStatistics);
            this.entityTypeToOwnerSelectionStrategy.put(entityType, strategy);
        }
        return strategy;
    }

    @Deprecated
    public void clearStrategies() {
        this.entityTypeToOwnerSelectionStrategy.clear();
    }

    public static Builder newBuilder() {
        return new Builder(new EntityOwnerSelectionStrategyConfig());
    }

    public static final class Builder {
        private final EntityOwnerSelectionStrategyConfig config;

        Builder(EntityOwnerSelectionStrategyConfig config) {
            this.config = config;
        }

        public Builder addStrategy(String entityType, Class<? extends EntityOwnerSelectionStrategy> strategy, long delay) {
            this.config.entityTypeToStrategyInfo.put(entityType, new StrategyInfo(strategy, delay));
            return this;
        }

        public EntityOwnerSelectionStrategyConfig build() {
            return this.config;
        }
    }

    private static final class StrategyInfo {
        private final Class<? extends EntityOwnerSelectionStrategy> strategyClass;
        private final long delay;

        private StrategyInfo(Class<? extends EntityOwnerSelectionStrategy> strategyClass, long delay) {
            this.strategyClass = strategyClass;
            this.delay = delay;
        }

        public EntityOwnerSelectionStrategy createStrategy(Map<String, Long> initialStatistics) {
            try {
                return this.strategyClass.getDeclaredConstructor(Long.TYPE, Map.class).newInstance(this.delay, initialStatistics);
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                LOG.warn("could not create custom strategy", (Throwable)e);
                return FirstCandidateSelectionStrategy.INSTANCE;
            }
        }
    }
}

