/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.datastore.messages;

import com.google.common.base.Preconditions;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.opendaylight.controller.cluster.access.concepts.TransactionIdentifier;
import org.opendaylight.controller.cluster.datastore.modification.MutableCompositeModification;

public class BatchedModifications
extends MutableCompositeModification {
    private static final long serialVersionUID = 1L;
    private boolean ready;
    private boolean doCommitOnReady;
    private int totalMessagesSent;
    private TransactionIdentifier transactionId;

    public BatchedModifications() {
    }

    public BatchedModifications(TransactionIdentifier transactionId, short version) {
        super(version);
        this.transactionId = (TransactionIdentifier)Preconditions.checkNotNull((Object)transactionId, (Object)"transactionID can't be null");
    }

    public boolean isReady() {
        return this.ready;
    }

    public void setReady(boolean ready) {
        this.ready = ready;
    }

    public boolean isDoCommitOnReady() {
        return this.doCommitOnReady;
    }

    public void setDoCommitOnReady(boolean doCommitOnReady) {
        this.doCommitOnReady = doCommitOnReady;
    }

    public int getTotalMessagesSent() {
        return this.totalMessagesSent;
    }

    public void setTotalMessagesSent(int totalMessagesSent) {
        this.totalMessagesSent = totalMessagesSent;
    }

    public TransactionIdentifier getTransactionId() {
        return this.transactionId;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this.transactionId = TransactionIdentifier.readFrom((DataInput)in);
        this.ready = in.readBoolean();
        this.totalMessagesSent = in.readInt();
        this.doCommitOnReady = in.readBoolean();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        this.transactionId.writeTo((DataOutput)out);
        out.writeBoolean(this.ready);
        out.writeInt(this.totalMessagesSent);
        out.writeBoolean(this.doCommitOnReady);
    }

    @Override
    public String toString() {
        return "BatchedModifications [transactionId=" + this.transactionId + ", ready=" + this.ready + ", totalMessagesSent=" + this.totalMessagesSent + ", modifications size=" + this.getModifications().size() + "]";
    }
}

