/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.datastore.messages;

import com.google.common.base.Preconditions;
import org.opendaylight.controller.cluster.access.concepts.TransactionIdentifier;
import org.opendaylight.controller.cluster.datastore.ReadWriteShardDataTreeTransaction;

public class ForwardedReadyTransaction {
    private final TransactionIdentifier transactionId;
    private final ReadWriteShardDataTreeTransaction transaction;
    private final boolean doImmediateCommit;
    private final short txnClientVersion;

    public ForwardedReadyTransaction(TransactionIdentifier transactionId, short txnClientVersion, ReadWriteShardDataTreeTransaction transaction, boolean doImmediateCommit) {
        this.transactionId = (TransactionIdentifier)Preconditions.checkNotNull((Object)transactionId);
        this.transaction = (ReadWriteShardDataTreeTransaction)Preconditions.checkNotNull((Object)transaction);
        this.txnClientVersion = txnClientVersion;
        this.doImmediateCommit = doImmediateCommit;
    }

    public TransactionIdentifier getTransactionId() {
        return this.transactionId;
    }

    public ReadWriteShardDataTreeTransaction getTransaction() {
        return this.transaction;
    }

    public short getTxnClientVersion() {
        return this.txnClientVersion;
    }

    public boolean isDoImmediateCommit() {
        return this.doImmediateCommit;
    }

    public String toString() {
        return "ForwardedReadyTransaction [transactionId=" + this.transactionId + ", doImmediateCommit=" + this.doImmediateCommit + ", txnClientVersion=" + this.txnClientVersion + "]";
    }
}

