/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.datastore.persisted;

import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.io.ByteStreams;
import java.io.DataInput;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import javax.annotation.Nonnull;
import org.opendaylight.controller.cluster.raft.protobuff.client.messages.Payload;
import org.opendaylight.yangtools.concepts.Identifiable;
import org.opendaylight.yangtools.concepts.Identifier;

public abstract class AbstractIdentifiablePayload<T extends Identifier>
extends Payload
implements Identifiable<T>,
Serializable {
    private static final long serialVersionUID = 1L;
    private final byte[] serialized;
    private final T identifier;

    AbstractIdentifiablePayload(@Nonnull T identifier, @Nonnull byte[] serialized) {
        this.identifier = (Identifier)Preconditions.checkNotNull(identifier);
        this.serialized = (byte[])Preconditions.checkNotNull((Object)serialized);
    }

    public final T getIdentifier() {
        return this.identifier;
    }

    public final int size() {
        return this.serialized.length;
    }

    protected final Object writeReplace() {
        return Verify.verifyNotNull(this.externalizableProxy(this.serialized));
    }

    @Nonnull
    protected abstract AbstractProxy<T> externalizableProxy(@Nonnull byte[] var1);

    protected static abstract class AbstractProxy<T extends Identifier>
    implements Externalizable {
        private static final long serialVersionUID = 1L;
        private byte[] serialized;
        private T identifier;

        public AbstractProxy() {
        }

        protected AbstractProxy(byte[] serialized) {
            this.serialized = (byte[])Preconditions.checkNotNull((Object)serialized);
        }

        @Override
        public final void writeExternal(ObjectOutput out) throws IOException {
            out.writeInt(this.serialized.length);
            out.write(this.serialized);
        }

        @Override
        public final void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            int length = in.readInt();
            this.serialized = new byte[length];
            in.readFully(this.serialized);
            this.identifier = (Identifier)Verify.verifyNotNull(this.readIdentifier((DataInput)ByteStreams.newDataInput((byte[])this.serialized)));
        }

        protected final Object readResolve() {
            return Verify.verifyNotNull(this.createObject(this.identifier, this.serialized));
        }

        @Nonnull
        protected abstract T readIdentifier(@Nonnull DataInput var1) throws IOException;

        @Nonnull
        protected abstract Identifiable<T> createObject(@Nonnull T var1, @Nonnull byte[] var2);
    }
}

