/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.datastore.persisted;

import com.google.common.base.Verify;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Optional;
import javax.annotation.Nonnull;
import org.opendaylight.controller.cluster.datastore.persisted.PayloadVersion;
import org.opendaylight.controller.cluster.datastore.persisted.ShardDataTreeSnapshot;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class AbstractVersionedShardDataTreeSnapshot
extends ShardDataTreeSnapshot {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractVersionedShardDataTreeSnapshot.class);

    AbstractVersionedShardDataTreeSnapshot() {
    }

    static ShardDataTreeSnapshot versionedDeserialize(ObjectInput in) throws IOException {
        PayloadVersion version = PayloadVersion.readFrom(in);
        switch (version) {
            case BORON: {
                try {
                    return (ShardDataTreeSnapshot)in.readObject();
                }
                catch (ClassNotFoundException e) {
                    LOG.error("Failed to serialize data tree snapshot", (Throwable)e);
                    throw new IOException("Snapshot failed to deserialize", e);
                }
            }
            case TEST_FUTURE_VERSION: 
            case TEST_PAST_VERSION: {
                break;
            }
            default: {
                throw new IOException("Invalid payload version in snapshot");
            }
        }
        throw new IOException("Encountered unhandled version" + (Object)((Object)version));
    }

    @Override
    public final Optional<NormalizedNode<?, ?>> getRootNode() {
        return Optional.of(Verify.verifyNotNull(this.rootNode(), (String)"Snapshot %s returned non-present root node", (Object[])new Object[]{this.getClass()}));
    }

    @Nonnull
    abstract NormalizedNode<?, ?> rootNode();

    @Nonnull
    abstract PayloadVersion version();

    private void versionedSerialize(ObjectOutput out, PayloadVersion version) throws IOException {
        switch (version) {
            case BORON: {
                out.writeObject(this);
                return;
            }
            case TEST_FUTURE_VERSION: 
            case TEST_PAST_VERSION: {
                break;
            }
            default: {
                throw new IOException("Invalid payload version in snapshot");
            }
        }
        throw new IOException("Encountered unhandled version" + (Object)((Object)version));
    }

    @Override
    public void serialize(ObjectOutput out) throws IOException {
        PayloadVersion version = this.version();
        version.writeTo(out);
        this.versionedSerialize(out, version);
    }
}

