/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.datastore.persisted;

import com.google.common.annotations.Beta;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.opendaylight.controller.cluster.datastore.node.utils.stream.NormalizedNodeDataInput;
import org.opendaylight.controller.cluster.datastore.node.utils.stream.NormalizedNodeDataOutput;
import org.opendaylight.controller.cluster.datastore.node.utils.stream.NormalizedNodeInputOutput;
import org.opendaylight.controller.cluster.datastore.persisted.AbstractDataTreeCandidateNode;
import org.opendaylight.controller.cluster.datastore.persisted.DeletedDataTreeCandidateNode;
import org.opendaylight.controller.cluster.datastore.persisted.ModifiedDataTreeCandidateNode;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.data.api.schema.tree.DataTreeCandidate;
import org.opendaylight.yangtools.yang.data.api.schema.tree.DataTreeCandidateNode;
import org.opendaylight.yangtools.yang.data.api.schema.tree.DataTreeCandidateNodes;
import org.opendaylight.yangtools.yang.data.api.schema.tree.DataTreeCandidates;
import org.opendaylight.yangtools.yang.data.api.schema.tree.ModificationType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Beta
public final class DataTreeCandidateInputOutput {
    private static final Logger LOG = LoggerFactory.getLogger(DataTreeCandidateInputOutput.class);
    private static final byte DELETE = 0;
    private static final byte SUBTREE_MODIFIED = 1;
    private static final byte UNMODIFIED = 2;
    private static final byte WRITE = 3;
    private static final byte APPEARED = 4;
    private static final byte DISAPPEARED = 5;

    private DataTreeCandidateInputOutput() {
        throw new UnsupportedOperationException();
    }

    private static DataTreeCandidateNode readModifiedNode(ModificationType type, NormalizedNodeDataInput in) throws IOException {
        YangInstanceIdentifier.PathArgument identifier = in.readPathArgument();
        Collection<DataTreeCandidateNode> children = DataTreeCandidateInputOutput.readChildren(in);
        if (children.isEmpty()) {
            LOG.debug("Modified node {} does not have any children, not instantiating it", (Object)identifier);
            return null;
        }
        return ModifiedDataTreeCandidateNode.create(identifier, type, children);
    }

    private static Collection<DataTreeCandidateNode> readChildren(NormalizedNodeDataInput in) throws IOException {
        int size = in.readInt();
        if (size != 0) {
            ArrayList<DataTreeCandidateNode> ret = new ArrayList<DataTreeCandidateNode>(size);
            for (int i = 0; i < size; ++i) {
                DataTreeCandidateNode child = DataTreeCandidateInputOutput.readNode(in);
                if (child == null) continue;
                ret.add(child);
            }
            return ret;
        }
        return Collections.emptyList();
    }

    private static DataTreeCandidateNode readNode(NormalizedNodeDataInput in) throws IOException {
        byte type = in.readByte();
        switch (type) {
            case 4: {
                return DataTreeCandidateInputOutput.readModifiedNode(ModificationType.APPEARED, in);
            }
            case 0: {
                return DeletedDataTreeCandidateNode.create(in.readPathArgument());
            }
            case 5: {
                return DataTreeCandidateInputOutput.readModifiedNode(ModificationType.DISAPPEARED, in);
            }
            case 1: {
                return DataTreeCandidateInputOutput.readModifiedNode(ModificationType.SUBTREE_MODIFIED, in);
            }
            case 2: {
                return null;
            }
            case 3: {
                return DataTreeCandidateNodes.fromNormalizedNode((NormalizedNode)in.readNormalizedNode());
            }
        }
        throw new IllegalArgumentException("Unhandled node type " + type);
    }

    public static DataTreeCandidate readDataTreeCandidate(DataInput in) throws IOException {
        DataTreeCandidateNode rootNode;
        NormalizedNodeDataInput reader = NormalizedNodeInputOutput.newDataInput((DataInput)in);
        YangInstanceIdentifier rootPath = reader.readYangInstanceIdentifier();
        byte type = reader.readByte();
        switch (type) {
            case 4: {
                rootNode = ModifiedDataTreeCandidateNode.create(ModificationType.APPEARED, DataTreeCandidateInputOutput.readChildren(reader));
                break;
            }
            case 0: {
                rootNode = DeletedDataTreeCandidateNode.create();
                break;
            }
            case 5: {
                rootNode = ModifiedDataTreeCandidateNode.create(ModificationType.DISAPPEARED, DataTreeCandidateInputOutput.readChildren(reader));
                break;
            }
            case 1: {
                rootNode = ModifiedDataTreeCandidateNode.create(ModificationType.SUBTREE_MODIFIED, DataTreeCandidateInputOutput.readChildren(reader));
                break;
            }
            case 3: {
                rootNode = DataTreeCandidateNodes.fromNormalizedNode((NormalizedNode)reader.readNormalizedNode());
                break;
            }
            case 2: {
                rootNode = AbstractDataTreeCandidateNode.createUnmodified();
                break;
            }
            default: {
                throw new IllegalArgumentException("Unhandled node type " + type);
            }
        }
        return DataTreeCandidates.newDataTreeCandidate((YangInstanceIdentifier)rootPath, (DataTreeCandidateNode)rootNode);
    }

    private static void writeChildren(NormalizedNodeDataOutput out, Collection<DataTreeCandidateNode> children) throws IOException {
        out.writeInt(children.size());
        for (DataTreeCandidateNode child : children) {
            DataTreeCandidateInputOutput.writeNode(out, child);
        }
    }

    private static void writeNode(NormalizedNodeDataOutput out, DataTreeCandidateNode node) throws IOException {
        switch (node.getModificationType()) {
            case APPEARED: {
                out.writeByte(4);
                out.writePathArgument(node.getIdentifier());
                DataTreeCandidateInputOutput.writeChildren(out, node.getChildNodes());
                break;
            }
            case DELETE: {
                out.writeByte(0);
                out.writePathArgument(node.getIdentifier());
                break;
            }
            case DISAPPEARED: {
                out.writeByte(5);
                out.writePathArgument(node.getIdentifier());
                DataTreeCandidateInputOutput.writeChildren(out, node.getChildNodes());
                break;
            }
            case SUBTREE_MODIFIED: {
                out.writeByte(1);
                out.writePathArgument(node.getIdentifier());
                DataTreeCandidateInputOutput.writeChildren(out, node.getChildNodes());
                break;
            }
            case WRITE: {
                out.writeByte(3);
                out.writeNormalizedNode((NormalizedNode)node.getDataAfter().get());
                break;
            }
            case UNMODIFIED: {
                out.writeByte(2);
                break;
            }
            default: {
                DataTreeCandidateInputOutput.throwUnhandledNodeType(node);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void writeDataTreeCandidate(DataOutput out, DataTreeCandidate candidate) throws IOException {
        try (NormalizedNodeDataOutput writer = NormalizedNodeInputOutput.newDataOutput((DataOutput)out);){
            writer.writeYangInstanceIdentifier(candidate.getRootPath());
            DataTreeCandidateNode node = candidate.getRootNode();
            switch (node.getModificationType()) {
                case APPEARED: {
                    writer.writeByte(4);
                    DataTreeCandidateInputOutput.writeChildren(writer, node.getChildNodes());
                    return;
                }
                case DELETE: {
                    writer.writeByte(0);
                    return;
                }
                case DISAPPEARED: {
                    writer.writeByte(5);
                    DataTreeCandidateInputOutput.writeChildren(writer, node.getChildNodes());
                    return;
                }
                case SUBTREE_MODIFIED: {
                    writer.writeByte(1);
                    DataTreeCandidateInputOutput.writeChildren(writer, node.getChildNodes());
                    return;
                }
                case UNMODIFIED: {
                    writer.writeByte(2);
                    return;
                }
                case WRITE: {
                    writer.writeByte(3);
                    writer.writeNormalizedNode((NormalizedNode)node.getDataAfter().get());
                    return;
                }
                default: {
                    DataTreeCandidateInputOutput.throwUnhandledNodeType(node);
                    return;
                }
            }
        }
    }

    private static void throwUnhandledNodeType(DataTreeCandidateNode node) {
        throw new IllegalArgumentException("Unhandled node type " + node.getModificationType());
    }
}

