/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.datastore.utils;

import java.util.List;
import java.util.Optional;
import org.opendaylight.controller.md.sal.common.api.data.LogicalDatastoreType;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.data.api.schema.tree.DataTree;
import org.opendaylight.yangtools.yang.data.api.schema.tree.DataTreeCandidate;
import org.opendaylight.yangtools.yang.data.api.schema.tree.DataTreeCandidateTip;
import org.opendaylight.yangtools.yang.data.api.schema.tree.DataTreeConfiguration;
import org.opendaylight.yangtools.yang.data.api.schema.tree.DataTreeModification;
import org.opendaylight.yangtools.yang.data.api.schema.tree.DataValidationFailedException;
import org.opendaylight.yangtools.yang.data.impl.schema.tree.InMemoryDataTreeFactory;
import org.opendaylight.yangtools.yang.model.api.SchemaContext;

public final class NormalizedNodeAggregator {
    private final YangInstanceIdentifier rootIdentifier;
    private final List<com.google.common.base.Optional<NormalizedNode<?, ?>>> nodes;
    private final DataTree dataTree;

    private NormalizedNodeAggregator(YangInstanceIdentifier rootIdentifier, List<com.google.common.base.Optional<NormalizedNode<?, ?>>> nodes, SchemaContext schemaContext, LogicalDatastoreType logicalDatastoreType) {
        this.rootIdentifier = rootIdentifier;
        this.nodes = nodes;
        this.dataTree = new InMemoryDataTreeFactory().create(logicalDatastoreType == LogicalDatastoreType.CONFIGURATION ? DataTreeConfiguration.DEFAULT_CONFIGURATION : DataTreeConfiguration.DEFAULT_OPERATIONAL);
        this.dataTree.setSchemaContext(schemaContext);
    }

    public static com.google.common.base.Optional<NormalizedNode<?, ?>> aggregate(YangInstanceIdentifier rootIdentifier, List<com.google.common.base.Optional<NormalizedNode<?, ?>>> nodes, SchemaContext schemaContext, LogicalDatastoreType logicalDatastoreType) throws DataValidationFailedException {
        return new NormalizedNodeAggregator(rootIdentifier, nodes, schemaContext, logicalDatastoreType).aggregate();
    }

    private com.google.common.base.Optional<NormalizedNode<?, ?>> aggregate() throws DataValidationFailedException {
        return this.combine().getRootNode();
    }

    private NormalizedNodeAggregator combine() throws DataValidationFailedException {
        DataTreeModification mod = this.dataTree.takeSnapshot().newModification();
        for (com.google.common.base.Optional<NormalizedNode<?, ?>> node : this.nodes) {
            if (!node.isPresent()) continue;
            mod.merge(this.rootIdentifier, (NormalizedNode)node.get());
        }
        mod.ready();
        this.dataTree.validate(mod);
        DataTreeCandidateTip candidate = this.dataTree.prepare(mod);
        this.dataTree.commit((DataTreeCandidate)candidate);
        return this;
    }

    private com.google.common.base.Optional<NormalizedNode<?, ?>> getRootNode() {
        return com.google.common.base.Optional.fromJavaUtil((Optional)this.dataTree.takeSnapshot().readNode(this.rootIdentifier));
    }
}

