/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.sharding;

import akka.actor.ActorRef;
import akka.actor.PoisonPill;
import akka.dispatch.Futures;
import akka.dispatch.Mapper;
import akka.dispatch.OnComplete;
import akka.util.Timeout;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nonnull;
import org.opendaylight.controller.cluster.datastore.exceptions.LocalShardNotFoundException;
import org.opendaylight.controller.cluster.datastore.messages.MakeLeaderLocal;
import org.opendaylight.controller.cluster.datastore.utils.ActorContext;
import org.opendaylight.controller.cluster.datastore.utils.ClusterUtils;
import org.opendaylight.controller.cluster.dom.api.CDSShardAccess;
import org.opendaylight.controller.cluster.dom.api.LeaderLocation;
import org.opendaylight.controller.cluster.dom.api.LeaderLocationListener;
import org.opendaylight.controller.cluster.dom.api.LeaderLocationListenerRegistration;
import org.opendaylight.controller.cluster.raft.LeadershipTransferFailedException;
import org.opendaylight.controller.cluster.sharding.RoleChangeListenerActor;
import org.opendaylight.mdsal.dom.api.DOMDataTreeIdentifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function1;
import scala.compat.java8.FutureConverters;
import scala.concurrent.Future;
import scala.concurrent.Promise;

final class CDSShardAccessImpl
implements CDSShardAccess,
LeaderLocationListener,
AutoCloseable {
    private static final Logger LOG = LoggerFactory.getLogger(CDSShardAccessImpl.class);
    private final Collection<LeaderLocationListener> listeners = ConcurrentHashMap.newKeySet();
    private final DOMDataTreeIdentifier prefix;
    private final ActorContext actorContext;
    private final Timeout makeLeaderLocalTimeout;
    private ActorRef roleChangeListenerActor;
    private volatile LeaderLocation currentLeader = LeaderLocation.UNKNOWN;
    private volatile boolean closed = false;

    CDSShardAccessImpl(DOMDataTreeIdentifier prefix, ActorContext actorContext) {
        this.prefix = (DOMDataTreeIdentifier)Preconditions.checkNotNull((Object)prefix);
        this.actorContext = (ActorContext)Preconditions.checkNotNull((Object)actorContext);
        this.makeLeaderLocalTimeout = new Timeout(actorContext.getDatastoreContext().getShardLeaderElectionTimeout().duration().$times(2L));
        Optional<ActorRef> localShardReply = actorContext.findLocalShard(ClusterUtils.getCleanShardName(prefix.getRootIdentifier()));
        Preconditions.checkState((boolean)localShardReply.isPresent(), (String)"Local shard for {} not present. Cannot register RoleChangeListenerActor", (Object)prefix);
        this.roleChangeListenerActor = actorContext.getActorSystem().actorOf(RoleChangeListenerActor.props((ActorRef)localShardReply.get(), this));
    }

    private void checkNotClosed() {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0, (Object)"CDSDataTreeProducer, that this CDSShardAccess is associated with, is no longer valid");
    }

    @Nonnull
    public DOMDataTreeIdentifier getShardIdentifier() {
        this.checkNotClosed();
        return this.prefix;
    }

    @Nonnull
    public LeaderLocation getLeaderLocation() {
        this.checkNotClosed();
        return this.currentLeader;
    }

    @Nonnull
    public CompletionStage<Void> makeLeaderLocal() {
        this.checkNotClosed();
        Future<ActorRef> localShardReply = this.actorContext.findLocalShardAsync(ClusterUtils.getCleanShardName(this.prefix.getRootIdentifier()));
        final Promise makeLeaderLocalAsk = Futures.promise();
        localShardReply.onComplete((Function1)new OnComplete<ActorRef>(){

            public void onComplete(Throwable failure, ActorRef actorRef) throws Throwable {
                if (failure instanceof LocalShardNotFoundException) {
                    LOG.debug("No local shard found for {} - Cannot request leadership transfer to local shard.", (Object)CDSShardAccessImpl.this.getShardIdentifier(), (Object)failure);
                    makeLeaderLocalAsk.failure(failure);
                } else if (failure != null) {
                    LOG.debug("Failed to find local shard for {} - Cannot request leadership transfer to local shard.", (Object)CDSShardAccessImpl.this.getShardIdentifier(), (Object)failure);
                    makeLeaderLocalAsk.failure(failure);
                } else {
                    makeLeaderLocalAsk.completeWith(CDSShardAccessImpl.this.actorContext.executeOperationAsync(actorRef, (Object)MakeLeaderLocal.INSTANCE, CDSShardAccessImpl.this.makeLeaderLocalTimeout));
                }
            }
        }, this.actorContext.getClientDispatcher());
        Future makeLeaderLocalFuture = makeLeaderLocalAsk.future().transform((Function1)new Mapper<Object, Void>(){

            public Void apply(Object parameter) {
                return null;
            }
        }, (Function1)new Mapper<Throwable, Throwable>(){

            public Throwable apply(Throwable parameter) {
                if (parameter instanceof LeadershipTransferFailedException) {
                    return parameter;
                }
                return new LeadershipTransferFailedException("Leadership transfer failed", parameter);
            }
        }, this.actorContext.getClientDispatcher());
        return FutureConverters.toJava((Future)makeLeaderLocalFuture);
    }

    @Nonnull
    public <L extends LeaderLocationListener> LeaderLocationListenerRegistration<L> registerLeaderLocationListener(final @Nonnull L listener) {
        this.checkNotClosed();
        Preconditions.checkNotNull(listener);
        Preconditions.checkArgument((!this.listeners.contains(listener) ? 1 : 0) != 0, (String)"Listener {} is already registered with ShardAccess {}", listener, (Object)this);
        LOG.debug("Registering LeaderLocationListener {}", listener);
        this.listeners.add(listener);
        return new LeaderLocationListenerRegistration<L>(){

            public L getInstance() {
                return listener;
            }

            public void close() {
                CDSShardAccessImpl.this.listeners.remove(listener);
            }
        };
    }

    public void onLeaderLocationChanged(@Nonnull LeaderLocation location) {
        if (this.closed) {
            return;
        }
        LOG.debug("Received leader location change notification. New leader location: {}", (Object)location);
        this.currentLeader = location;
        this.listeners.forEach(listener -> {
            try {
                listener.onLeaderLocationChanged(location);
            }
            catch (Exception e) {
                LOG.warn("Ignoring uncaught exception thrown be LeaderLocationListener {} during processing leader location change {}", new Object[]{listener, location, e});
            }
        });
    }

    @Override
    public void close() {
        LOG.debug("Closing {} ShardAccess", (Object)this.prefix);
        this.closed = true;
        if (this.roleChangeListenerActor != null) {
            this.roleChangeListenerActor.tell((Object)PoisonPill.getInstance(), ActorRef.noSender());
            this.roleChangeListenerActor = null;
        }
    }
}

