/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.config.yang.config.concurrent_data_broker;

import java.util.Objects;
import javax.management.ObjectName;
import org.opendaylight.controller.config.api.DependencyResolver;
import org.opendaylight.controller.config.api.JmxAttribute;
import org.opendaylight.controller.config.api.ModuleIdentifier;
import org.opendaylight.controller.config.api.RuntimeBeanRegistratorAwareModule;
import org.opendaylight.controller.config.api.annotations.Description;
import org.opendaylight.controller.config.api.annotations.RequireInterface;
import org.opendaylight.controller.config.api.runtime.RootRuntimeBeanRegistrator;
import org.opendaylight.controller.config.spi.AbstractModule;
import org.opendaylight.controller.config.yang.config.concurrent_data_broker.DomConcurrentDataBrokerModuleMXBean;
import org.opendaylight.controller.config.yang.config.concurrent_data_broker.DomConcurrentDataBrokerRuntimeRegistrator;
import org.opendaylight.controller.config.yang.md.sal.core.spi.config_dom_store.DOMStoreServiceInterface;
import org.opendaylight.controller.config.yang.md.sal.dom.DOMDataBrokerServiceInterface;
import org.opendaylight.controller.config.yang.md.sal.dom.SchemaServiceServiceInterface;
import org.opendaylight.controller.sal.core.api.model.SchemaService;
import org.opendaylight.controller.sal.core.spi.data.DOMStore;
import org.opendaylight.yangtools.yang.binding.annotations.ModuleQName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ModuleQName(namespace="urn:opendaylight:params:xml:ns:yang:controller:config:concurrent-data-broker", name="odl-concurrent-data-broker-cfg", revision="2014-11-24")
public abstract class AbstractDomConcurrentDataBrokerModule
extends AbstractModule<AbstractDomConcurrentDataBrokerModule>
implements DomConcurrentDataBrokerModuleMXBean,
DOMDataBrokerServiceInterface,
RuntimeBeanRegistratorAwareModule {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractDomConcurrentDataBrokerModule.class);
    public static final JmxAttribute configDataStoreJmxAttribute = new JmxAttribute("ConfigDataStore");
    private ObjectName configDataStore;
    public static final JmxAttribute schemaServiceJmxAttribute = new JmxAttribute("SchemaService");
    private ObjectName schemaService;
    public static final JmxAttribute maxDataBrokerCommitQueueSizeJmxAttribute = new JmxAttribute("MaxDataBrokerCommitQueueSize");
    private Integer maxDataBrokerCommitQueueSize = Integer.valueOf("5000");
    public static final JmxAttribute maxDataBrokerFutureCallbackQueueSizeJmxAttribute = new JmxAttribute("MaxDataBrokerFutureCallbackQueueSize");
    private Integer maxDataBrokerFutureCallbackQueueSize = Integer.valueOf("1000");
    public static final JmxAttribute maxDataBrokerFutureCallbackPoolSizeJmxAttribute = new JmxAttribute("MaxDataBrokerFutureCallbackPoolSize");
    private Integer maxDataBrokerFutureCallbackPoolSize = Integer.valueOf("20");
    public static final JmxAttribute operationalDataStoreJmxAttribute = new JmxAttribute("OperationalDataStore");
    private ObjectName operationalDataStore;
    private DomConcurrentDataBrokerRuntimeRegistrator rootRuntimeBeanRegistratorWrapper;
    private DOMStore configDataStoreDependency;
    private SchemaService schemaServiceDependency;
    private DOMStore operationalDataStoreDependency;

    public AbstractDomConcurrentDataBrokerModule(ModuleIdentifier identifier, DependencyResolver dependencyResolver) {
        super(identifier, dependencyResolver);
    }

    public AbstractDomConcurrentDataBrokerModule(ModuleIdentifier identifier, DependencyResolver dependencyResolver, AbstractDomConcurrentDataBrokerModule oldModule, AutoCloseable oldInstance) {
        super(identifier, dependencyResolver, (AbstractModule)oldModule, oldInstance);
    }

    public DomConcurrentDataBrokerRuntimeRegistrator getRootRuntimeBeanRegistratorWrapper() {
        return this.rootRuntimeBeanRegistratorWrapper;
    }

    public void setRuntimeBeanRegistrator(RootRuntimeBeanRegistrator rootRuntimeRegistrator) {
        this.rootRuntimeBeanRegistratorWrapper = new DomConcurrentDataBrokerRuntimeRegistrator(rootRuntimeRegistrator);
    }

    public void validate() {
        if (this.configDataStore != null) {
            this.dependencyResolver.validateDependency(DOMStoreServiceInterface.class, this.configDataStore, configDataStoreJmxAttribute);
        }
        if (this.schemaService != null) {
            this.dependencyResolver.validateDependency(SchemaServiceServiceInterface.class, this.schemaService, schemaServiceJmxAttribute);
        }
        if (this.operationalDataStore != null) {
            this.dependencyResolver.validateDependency(org.opendaylight.controller.config.yang.md.sal.core.spi.operational_dom_store.DOMStoreServiceInterface.class, this.operationalDataStore, operationalDataStoreJmxAttribute);
        }
        this.customValidation();
    }

    protected void customValidation() {
    }

    protected final DOMStore getConfigDataStoreDependency() {
        return this.configDataStoreDependency;
    }

    protected final SchemaService getSchemaServiceDependency() {
        return this.schemaServiceDependency;
    }

    protected final DOMStore getOperationalDataStoreDependency() {
        return this.operationalDataStoreDependency;
    }

    protected final void resolveDependencies() {
        if (this.operationalDataStore != null) {
            this.operationalDataStoreDependency = (DOMStore)this.dependencyResolver.resolveInstance(DOMStore.class, this.operationalDataStore, operationalDataStoreJmxAttribute);
        }
        if (this.configDataStore != null) {
            this.configDataStoreDependency = (DOMStore)this.dependencyResolver.resolveInstance(DOMStore.class, this.configDataStore, configDataStoreJmxAttribute);
        }
        if (this.schemaService != null) {
            this.schemaServiceDependency = (SchemaService)this.dependencyResolver.resolveInstance(SchemaService.class, this.schemaService, schemaServiceJmxAttribute);
        }
    }

    public boolean canReuseInstance(AbstractDomConcurrentDataBrokerModule oldModule) {
        return this.isSame(oldModule);
    }

    public AutoCloseable reuseInstance(AutoCloseable oldInstance) {
        return oldInstance;
    }

    public boolean isSame(AbstractDomConcurrentDataBrokerModule other) {
        if (other == null) {
            throw new IllegalArgumentException("Parameter 'other' is null");
        }
        if (!Objects.deepEquals(this.configDataStore, other.configDataStore)) {
            return false;
        }
        if (this.configDataStore != null && !this.dependencyResolver.canReuseDependency(this.configDataStore, configDataStoreJmxAttribute)) {
            return false;
        }
        if (!Objects.deepEquals(this.schemaService, other.schemaService)) {
            return false;
        }
        if (this.schemaService != null && !this.dependencyResolver.canReuseDependency(this.schemaService, schemaServiceJmxAttribute)) {
            return false;
        }
        if (!Objects.deepEquals(this.maxDataBrokerCommitQueueSize, other.maxDataBrokerCommitQueueSize)) {
            return false;
        }
        if (!Objects.deepEquals(this.maxDataBrokerFutureCallbackQueueSize, other.maxDataBrokerFutureCallbackQueueSize)) {
            return false;
        }
        if (!Objects.deepEquals(this.maxDataBrokerFutureCallbackPoolSize, other.maxDataBrokerFutureCallbackPoolSize)) {
            return false;
        }
        if (!Objects.deepEquals(this.operationalDataStore, other.operationalDataStore)) {
            return false;
        }
        return this.operationalDataStore == null || this.dependencyResolver.canReuseDependency(this.operationalDataStore, operationalDataStoreJmxAttribute);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AbstractDomConcurrentDataBrokerModule that = (AbstractDomConcurrentDataBrokerModule)o;
        return this.identifier.equals((Object)that.identifier);
    }

    public int hashCode() {
        return this.identifier.hashCode();
    }

    @Override
    public ObjectName getConfigDataStore() {
        return this.configDataStore;
    }

    @Override
    @RequireInterface(value=DOMStoreServiceInterface.class)
    public void setConfigDataStore(ObjectName configDataStore) {
        this.configDataStore = configDataStore;
    }

    @Override
    public ObjectName getSchemaService() {
        return this.schemaService;
    }

    @Override
    @RequireInterface(value=SchemaServiceServiceInterface.class)
    public void setSchemaService(ObjectName schemaService) {
        this.schemaService = schemaService;
    }

    @Override
    public Integer getMaxDataBrokerCommitQueueSize() {
        return this.maxDataBrokerCommitQueueSize;
    }

    @Override
    @Description(value="The maximum queue size for the data broker's commit executor.")
    public void setMaxDataBrokerCommitQueueSize(Integer maxDataBrokerCommitQueueSize) {
        this.maxDataBrokerCommitQueueSize = maxDataBrokerCommitQueueSize;
    }

    @Override
    public Integer getMaxDataBrokerFutureCallbackQueueSize() {
        return this.maxDataBrokerFutureCallbackQueueSize;
    }

    @Override
    @Description(value="The maximum queue size for the data broker's commit future callback executor.")
    public void setMaxDataBrokerFutureCallbackQueueSize(Integer maxDataBrokerFutureCallbackQueueSize) {
        this.maxDataBrokerFutureCallbackQueueSize = maxDataBrokerFutureCallbackQueueSize;
    }

    @Override
    public Integer getMaxDataBrokerFutureCallbackPoolSize() {
        return this.maxDataBrokerFutureCallbackPoolSize;
    }

    @Override
    @Description(value="The maximum thread pool size for the data broker's commit future callback executor.")
    public void setMaxDataBrokerFutureCallbackPoolSize(Integer maxDataBrokerFutureCallbackPoolSize) {
        this.maxDataBrokerFutureCallbackPoolSize = maxDataBrokerFutureCallbackPoolSize;
    }

    @Override
    public ObjectName getOperationalDataStore() {
        return this.operationalDataStore;
    }

    @Override
    @RequireInterface(value=org.opendaylight.controller.config.yang.md.sal.core.spi.operational_dom_store.DOMStoreServiceInterface.class)
    public void setOperationalDataStore(ObjectName operationalDataStore) {
        this.operationalDataStore = operationalDataStore;
    }

    public Logger getLogger() {
        return LOG;
    }
}

