/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.config.yang.config.distributed_datastore_provider;

import java.util.Objects;
import javax.management.ObjectName;
import org.opendaylight.controller.cluster.ActorSystemProvider;
import org.opendaylight.controller.config.api.DependencyResolver;
import org.opendaylight.controller.config.api.JmxAttribute;
import org.opendaylight.controller.config.api.ModuleIdentifier;
import org.opendaylight.controller.config.api.annotations.RequireInterface;
import org.opendaylight.controller.config.spi.AbstractModule;
import org.opendaylight.controller.config.yang.config.actor_system_provider.service.ActorSystemProviderServiceInterface;
import org.opendaylight.controller.config.yang.config.distributed_datastore_provider.ConfigProperties;
import org.opendaylight.controller.config.yang.config.distributed_datastore_provider.DistributedConfigDataStoreProviderModuleMXBean;
import org.opendaylight.controller.config.yang.md.sal.core.spi.config_dom_store.DOMStoreServiceInterface;
import org.opendaylight.controller.config.yang.md.sal.dom.SchemaServiceServiceInterface;
import org.opendaylight.controller.sal.core.api.model.SchemaService;
import org.opendaylight.yangtools.yang.binding.annotations.ModuleQName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ModuleQName(namespace="urn:opendaylight:params:xml:ns:yang:controller:config:distributed-datastore-provider", name="distributed-datastore-provider", revision="2014-06-12")
public abstract class AbstractDistributedConfigDataStoreProviderModule
extends AbstractModule<AbstractDistributedConfigDataStoreProviderModule>
implements DistributedConfigDataStoreProviderModuleMXBean,
DOMStoreServiceInterface {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractDistributedConfigDataStoreProviderModule.class);
    public static final JmxAttribute configPropertiesJmxAttribute = new JmxAttribute("ConfigProperties");
    private ConfigProperties configProperties;
    public static final JmxAttribute configSchemaServiceJmxAttribute = new JmxAttribute("ConfigSchemaService");
    private ObjectName configSchemaService;
    public static final JmxAttribute configActorSystemProviderJmxAttribute = new JmxAttribute("ConfigActorSystemProvider");
    private ObjectName configActorSystemProvider;
    private SchemaService configSchemaServiceDependency;
    private ActorSystemProvider configActorSystemProviderDependency;

    public AbstractDistributedConfigDataStoreProviderModule(ModuleIdentifier identifier, DependencyResolver dependencyResolver) {
        super(identifier, dependencyResolver);
    }

    public AbstractDistributedConfigDataStoreProviderModule(ModuleIdentifier identifier, DependencyResolver dependencyResolver, AbstractDistributedConfigDataStoreProviderModule oldModule, AutoCloseable oldInstance) {
        super(identifier, dependencyResolver, (AbstractModule)oldModule, oldInstance);
    }

    public void validate() {
        if (this.configSchemaService != null) {
            this.dependencyResolver.validateDependency(SchemaServiceServiceInterface.class, this.configSchemaService, configSchemaServiceJmxAttribute);
        }
        if (this.configActorSystemProvider != null) {
            this.dependencyResolver.validateDependency(ActorSystemProviderServiceInterface.class, this.configActorSystemProvider, configActorSystemProviderJmxAttribute);
        }
        this.customValidation();
    }

    protected void customValidation() {
    }

    protected final SchemaService getConfigSchemaServiceDependency() {
        return this.configSchemaServiceDependency;
    }

    protected final ActorSystemProvider getConfigActorSystemProviderDependency() {
        return this.configActorSystemProviderDependency;
    }

    protected final void resolveDependencies() {
        if (this.configActorSystemProvider != null) {
            this.configActorSystemProviderDependency = (ActorSystemProvider)this.dependencyResolver.resolveInstance(ActorSystemProvider.class, this.configActorSystemProvider, configActorSystemProviderJmxAttribute);
        }
        if (this.configSchemaService != null) {
            this.configSchemaServiceDependency = (SchemaService)this.dependencyResolver.resolveInstance(SchemaService.class, this.configSchemaService, configSchemaServiceJmxAttribute);
        }
        if (this.configProperties != null) {
            this.configProperties.injectDependencyResolver(this.dependencyResolver);
        }
    }

    public boolean canReuseInstance(AbstractDistributedConfigDataStoreProviderModule oldModule) {
        return this.isSame(oldModule);
    }

    public AutoCloseable reuseInstance(AutoCloseable oldInstance) {
        return oldInstance;
    }

    public boolean isSame(AbstractDistributedConfigDataStoreProviderModule other) {
        if (other == null) {
            throw new IllegalArgumentException("Parameter 'other' is null");
        }
        if (!Objects.deepEquals(this.configProperties, other.configProperties)) {
            return false;
        }
        if (!Objects.deepEquals(this.configSchemaService, other.configSchemaService)) {
            return false;
        }
        if (this.configSchemaService != null && !this.dependencyResolver.canReuseDependency(this.configSchemaService, configSchemaServiceJmxAttribute)) {
            return false;
        }
        if (!Objects.deepEquals(this.configActorSystemProvider, other.configActorSystemProvider)) {
            return false;
        }
        return this.configActorSystemProvider == null || this.dependencyResolver.canReuseDependency(this.configActorSystemProvider, configActorSystemProviderJmxAttribute);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AbstractDistributedConfigDataStoreProviderModule that = (AbstractDistributedConfigDataStoreProviderModule)o;
        return this.identifier.equals((Object)that.identifier);
    }

    public int hashCode() {
        return this.identifier.hashCode();
    }

    @Override
    public ConfigProperties getConfigProperties() {
        return this.configProperties;
    }

    @Override
    public void setConfigProperties(ConfigProperties configProperties) {
        this.configProperties = configProperties;
    }

    @Override
    public ObjectName getConfigSchemaService() {
        return this.configSchemaService;
    }

    @Override
    @RequireInterface(value=SchemaServiceServiceInterface.class)
    public void setConfigSchemaService(ObjectName configSchemaService) {
        this.configSchemaService = configSchemaService;
    }

    @Override
    public ObjectName getConfigActorSystemProvider() {
        return this.configActorSystemProvider;
    }

    @Override
    @RequireInterface(value=ActorSystemProviderServiceInterface.class)
    public void setConfigActorSystemProvider(ObjectName configActorSystemProvider) {
        this.configActorSystemProvider = configActorSystemProvider;
    }

    public Logger getLogger() {
        return LOG;
    }
}

