/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.config.yang.config.distributed_datastore_provider;

import java.util.Objects;
import javax.management.ObjectName;
import org.opendaylight.controller.cluster.ActorSystemProvider;
import org.opendaylight.controller.config.api.DependencyResolver;
import org.opendaylight.controller.config.api.JmxAttribute;
import org.opendaylight.controller.config.api.ModuleIdentifier;
import org.opendaylight.controller.config.api.annotations.RequireInterface;
import org.opendaylight.controller.config.spi.AbstractModule;
import org.opendaylight.controller.config.yang.config.actor_system_provider.service.ActorSystemProviderServiceInterface;
import org.opendaylight.controller.config.yang.config.distributed_datastore_provider.DistributedOperationalDataStoreProviderModuleMXBean;
import org.opendaylight.controller.config.yang.config.distributed_datastore_provider.OperationalProperties;
import org.opendaylight.controller.config.yang.md.sal.core.spi.operational_dom_store.DOMStoreServiceInterface;
import org.opendaylight.controller.config.yang.md.sal.dom.SchemaServiceServiceInterface;
import org.opendaylight.controller.sal.core.api.model.SchemaService;
import org.opendaylight.yangtools.yang.binding.annotations.ModuleQName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ModuleQName(namespace="urn:opendaylight:params:xml:ns:yang:controller:config:distributed-datastore-provider", name="distributed-datastore-provider", revision="2014-06-12")
public abstract class AbstractDistributedOperationalDataStoreProviderModule
extends AbstractModule<AbstractDistributedOperationalDataStoreProviderModule>
implements DistributedOperationalDataStoreProviderModuleMXBean,
DOMStoreServiceInterface {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractDistributedOperationalDataStoreProviderModule.class);
    public static final JmxAttribute operationalPropertiesJmxAttribute = new JmxAttribute("OperationalProperties");
    private OperationalProperties operationalProperties;
    public static final JmxAttribute operationalSchemaServiceJmxAttribute = new JmxAttribute("OperationalSchemaService");
    private ObjectName operationalSchemaService;
    public static final JmxAttribute operationalActorSystemProviderJmxAttribute = new JmxAttribute("OperationalActorSystemProvider");
    private ObjectName operationalActorSystemProvider;
    private SchemaService operationalSchemaServiceDependency;
    private ActorSystemProvider operationalActorSystemProviderDependency;

    public AbstractDistributedOperationalDataStoreProviderModule(ModuleIdentifier identifier, DependencyResolver dependencyResolver) {
        super(identifier, dependencyResolver);
    }

    public AbstractDistributedOperationalDataStoreProviderModule(ModuleIdentifier identifier, DependencyResolver dependencyResolver, AbstractDistributedOperationalDataStoreProviderModule oldModule, AutoCloseable oldInstance) {
        super(identifier, dependencyResolver, (AbstractModule)oldModule, oldInstance);
    }

    public void validate() {
        if (this.operationalSchemaService != null) {
            this.dependencyResolver.validateDependency(SchemaServiceServiceInterface.class, this.operationalSchemaService, operationalSchemaServiceJmxAttribute);
        }
        if (this.operationalActorSystemProvider != null) {
            this.dependencyResolver.validateDependency(ActorSystemProviderServiceInterface.class, this.operationalActorSystemProvider, operationalActorSystemProviderJmxAttribute);
        }
        this.customValidation();
    }

    protected void customValidation() {
    }

    protected final SchemaService getOperationalSchemaServiceDependency() {
        return this.operationalSchemaServiceDependency;
    }

    protected final ActorSystemProvider getOperationalActorSystemProviderDependency() {
        return this.operationalActorSystemProviderDependency;
    }

    protected final void resolveDependencies() {
        if (this.operationalActorSystemProvider != null) {
            this.operationalActorSystemProviderDependency = (ActorSystemProvider)this.dependencyResolver.resolveInstance(ActorSystemProvider.class, this.operationalActorSystemProvider, operationalActorSystemProviderJmxAttribute);
        }
        if (this.operationalSchemaService != null) {
            this.operationalSchemaServiceDependency = (SchemaService)this.dependencyResolver.resolveInstance(SchemaService.class, this.operationalSchemaService, operationalSchemaServiceJmxAttribute);
        }
        if (this.operationalProperties != null) {
            this.operationalProperties.injectDependencyResolver(this.dependencyResolver);
        }
    }

    public boolean canReuseInstance(AbstractDistributedOperationalDataStoreProviderModule oldModule) {
        return this.isSame(oldModule);
    }

    public AutoCloseable reuseInstance(AutoCloseable oldInstance) {
        return oldInstance;
    }

    public boolean isSame(AbstractDistributedOperationalDataStoreProviderModule other) {
        if (other == null) {
            throw new IllegalArgumentException("Parameter 'other' is null");
        }
        if (!Objects.deepEquals(this.operationalProperties, other.operationalProperties)) {
            return false;
        }
        if (!Objects.deepEquals(this.operationalSchemaService, other.operationalSchemaService)) {
            return false;
        }
        if (this.operationalSchemaService != null && !this.dependencyResolver.canReuseDependency(this.operationalSchemaService, operationalSchemaServiceJmxAttribute)) {
            return false;
        }
        if (!Objects.deepEquals(this.operationalActorSystemProvider, other.operationalActorSystemProvider)) {
            return false;
        }
        return this.operationalActorSystemProvider == null || this.dependencyResolver.canReuseDependency(this.operationalActorSystemProvider, operationalActorSystemProviderJmxAttribute);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AbstractDistributedOperationalDataStoreProviderModule that = (AbstractDistributedOperationalDataStoreProviderModule)o;
        return this.identifier.equals((Object)that.identifier);
    }

    public int hashCode() {
        return this.identifier.hashCode();
    }

    @Override
    public OperationalProperties getOperationalProperties() {
        return this.operationalProperties;
    }

    @Override
    public void setOperationalProperties(OperationalProperties operationalProperties) {
        this.operationalProperties = operationalProperties;
    }

    @Override
    public ObjectName getOperationalSchemaService() {
        return this.operationalSchemaService;
    }

    @Override
    @RequireInterface(value=SchemaServiceServiceInterface.class)
    public void setOperationalSchemaService(ObjectName operationalSchemaService) {
        this.operationalSchemaService = operationalSchemaService;
    }

    @Override
    public ObjectName getOperationalActorSystemProvider() {
        return this.operationalActorSystemProvider;
    }

    @Override
    @RequireInterface(value=ActorSystemProviderServiceInterface.class)
    public void setOperationalActorSystemProvider(ObjectName operationalActorSystemProvider) {
        this.operationalActorSystemProvider = operationalActorSystemProvider;
    }

    public Logger getLogger() {
        return LOG;
    }
}

