/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.config.yang.config.distributed_datastore_provider;

import org.opendaylight.controller.cluster.datastore.DatastoreContext;
import org.opendaylight.controller.cluster.datastore.DistributedDataStoreInterface;
import org.opendaylight.controller.config.api.DependencyResolver;
import org.opendaylight.controller.config.api.ModuleIdentifier;
import org.opendaylight.controller.config.api.osgi.WaitingServiceTracker;
import org.opendaylight.controller.config.yang.config.distributed_datastore_provider.AbstractDistributedOperationalDataStoreProviderModule;
import org.opendaylight.controller.config.yang.config.distributed_datastore_provider.ForwardingDistributedDataStore;
import org.opendaylight.controller.config.yang.config.distributed_datastore_provider.OperationalProperties;
import org.opendaylight.controller.md.sal.common.api.data.LogicalDatastoreType;
import org.osgi.framework.BundleContext;

public class DistributedOperationalDataStoreProviderModule
extends AbstractDistributedOperationalDataStoreProviderModule {
    private BundleContext bundleContext;

    public DistributedOperationalDataStoreProviderModule(ModuleIdentifier identifier, DependencyResolver dependencyResolver) {
        super(identifier, dependencyResolver);
    }

    public DistributedOperationalDataStoreProviderModule(ModuleIdentifier identifier, DependencyResolver dependencyResolver, DistributedOperationalDataStoreProviderModule oldModule, AutoCloseable oldInstance) {
        super(identifier, dependencyResolver, oldModule, oldInstance);
    }

    @Override
    public void customValidation() {
    }

    @Override
    public boolean canReuseInstance(AbstractDistributedOperationalDataStoreProviderModule oldModule) {
        return true;
    }

    public AutoCloseable createInstance() {
        WaitingServiceTracker tracker = WaitingServiceTracker.create(DistributedDataStoreInterface.class, (BundleContext)this.bundleContext, (String)"(type=distributed-operational)");
        DistributedDataStoreInterface delegate = (DistributedDataStoreInterface)tracker.waitForService(WaitingServiceTracker.FIVE_MINUTES);
        return new ForwardingDistributedDataStore(delegate, (AutoCloseable)tracker);
    }

    public static DatastoreContext newDatastoreContext() {
        return DistributedOperationalDataStoreProviderModule.newDatastoreContext(null);
    }

    private static DatastoreContext newDatastoreContext(OperationalProperties inProps) {
        OperationalProperties props = inProps;
        if (props == null) {
            props = new OperationalProperties();
        }
        return DatastoreContext.newBuilder().logicalStoreType(LogicalDatastoreType.OPERATIONAL).tempFileDirectory("./data").fileBackedStreamingThresholdInMegabytes(props.getFileBackedStreamingThresholdInMegabytes().getValue().intValue()).maxShardDataChangeExecutorPoolSize(props.getMaxShardDataChangeExecutorPoolSize().getValue().intValue()).maxShardDataChangeExecutorQueueSize(props.getMaxShardDataChangeExecutorQueueSize().getValue().intValue()).maxShardDataChangeListenerQueueSize(props.getMaxShardDataChangeListenerQueueSize().getValue().intValue()).maxShardDataStoreExecutorQueueSize(props.getMaxShardDataStoreExecutorQueueSize().getValue().intValue()).shardTransactionIdleTimeoutInMinutes(props.getShardTransactionIdleTimeoutInMinutes().getValue()).operationTimeoutInSeconds(props.getOperationTimeoutInSeconds().getValue()).shardJournalRecoveryLogBatchSize(props.getShardJournalRecoveryLogBatchSize().getValue().intValue()).shardSnapshotBatchCount(props.getShardSnapshotBatchCount().getValue().intValue()).shardSnapshotDataThresholdPercentage(props.getShardSnapshotDataThresholdPercentage().getValue().intValue()).shardHeartbeatIntervalInMillis(props.getShardHeartbeatIntervalInMillis().getValue()).shardInitializationTimeoutInSeconds(props.getShardInitializationTimeoutInSeconds().getValue()).shardLeaderElectionTimeoutInSeconds(props.getShardLeaderElectionTimeoutInSeconds().getValue()).shardTransactionCommitTimeoutInSeconds(props.getShardTransactionCommitTimeoutInSeconds().getValue().intValue()).shardTransactionCommitQueueCapacity(props.getShardTransactionCommitQueueCapacity().getValue().intValue()).persistent(props.getPersistent()).shardIsolatedLeaderCheckIntervalInMillis(props.getShardIsolatedLeaderCheckIntervalInMillis().getValue()).shardElectionTimeoutFactor(props.getShardElectionTimeoutFactor().getValue()).transactionCreationInitialRateLimit(props.getTransactionCreationInitialRateLimit().getValue()).shardBatchedModificationCount(props.getShardBatchedModificationCount().getValue().intValue()).shardCommitQueueExpiryTimeoutInSeconds(props.getShardCommitQueueExpiryTimeoutInSeconds().getValue().intValue()).transactionDebugContextEnabled(props.getTransactionDebugContextEnabled()).customRaftPolicyImplementation(props.getCustomRaftPolicyImplementation()).maximumMessageSliceSize(props.getMaximumMessageSliceSize().getValue().intValue()).useTellBasedProtocol(props.getUseTellBasedProtocol()).syncIndexThreshold(props.getSyncIndexThreshold().getValue()).backendAlivenessTimerIntervalInSeconds(props.getBackendAlivenessTimerIntervalInSeconds().getValue()).frontendRequestTimeoutInSeconds(props.getFrontendRequestTimeoutInSeconds().getValue()).frontendNoProgressTimeoutInSeconds(props.getFrontendNoProgressTimeoutInSeconds().getValue()).build();
    }

    public void setBundleContext(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
    }
}

