/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.concurrent.data.broker.rev141124.modules.module.configuration;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.concurrent.data.broker.rev141124.modules.module.configuration.DomConcurrentDataBroker;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.dom.impl.rev131028.DomBrokerConfig;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.dom.impl.rev131028.dom.broker.config.ConfigDataStore;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.dom.impl.rev131028.dom.broker.config.OperationalDataStore;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.dom.impl.rev131028.dom.broker.config.SchemaService;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class DomConcurrentDataBrokerBuilder
implements Builder<DomConcurrentDataBroker> {
    private ConfigDataStore _configDataStore;
    private Integer _maxDataBrokerCommitQueueSize;
    private Integer _maxDataBrokerFutureCallbackPoolSize;
    private Integer _maxDataBrokerFutureCallbackQueueSize;
    private OperationalDataStore _operationalDataStore;
    private SchemaService _schemaService;
    Map<Class<? extends Augmentation<DomConcurrentDataBroker>>, Augmentation<DomConcurrentDataBroker>> augmentation = Collections.emptyMap();

    public DomConcurrentDataBrokerBuilder() {
    }

    public DomConcurrentDataBrokerBuilder(DomBrokerConfig arg) {
        this._schemaService = arg.getSchemaService();
        this._configDataStore = arg.getConfigDataStore();
        this._operationalDataStore = arg.getOperationalDataStore();
        this._maxDataBrokerFutureCallbackQueueSize = arg.getMaxDataBrokerFutureCallbackQueueSize();
        this._maxDataBrokerFutureCallbackPoolSize = arg.getMaxDataBrokerFutureCallbackPoolSize();
        this._maxDataBrokerCommitQueueSize = arg.getMaxDataBrokerCommitQueueSize();
    }

    public DomConcurrentDataBrokerBuilder(DomConcurrentDataBroker base) {
        AugmentationHolder casted;
        this._configDataStore = base.getConfigDataStore();
        this._maxDataBrokerCommitQueueSize = base.getMaxDataBrokerCommitQueueSize();
        this._maxDataBrokerFutureCallbackPoolSize = base.getMaxDataBrokerFutureCallbackPoolSize();
        this._maxDataBrokerFutureCallbackQueueSize = base.getMaxDataBrokerFutureCallbackQueueSize();
        this._operationalDataStore = base.getOperationalDataStore();
        this._schemaService = base.getSchemaService();
        if (base instanceof DomConcurrentDataBrokerImpl) {
            DomConcurrentDataBrokerImpl impl = (DomConcurrentDataBrokerImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<DomConcurrentDataBroker>>, Augmentation<DomConcurrentDataBroker>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)base).augmentations().isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<DomConcurrentDataBroker>>, Augmentation<DomConcurrentDataBroker>>(casted.augmentations());
        }
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof DomBrokerConfig) {
            this._schemaService = ((DomBrokerConfig)arg).getSchemaService();
            this._configDataStore = ((DomBrokerConfig)arg).getConfigDataStore();
            this._operationalDataStore = ((DomBrokerConfig)arg).getOperationalDataStore();
            this._maxDataBrokerFutureCallbackQueueSize = ((DomBrokerConfig)arg).getMaxDataBrokerFutureCallbackQueueSize();
            this._maxDataBrokerFutureCallbackPoolSize = ((DomBrokerConfig)arg).getMaxDataBrokerFutureCallbackPoolSize();
            this._maxDataBrokerCommitQueueSize = ((DomBrokerConfig)arg).getMaxDataBrokerCommitQueueSize();
            isValidArg = true;
        }
        if (!isValidArg) {
            throw new IllegalArgumentException("expected one of: [org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.dom.impl.rev131028.DomBrokerConfig] \nbut was: " + arg);
        }
    }

    public ConfigDataStore getConfigDataStore() {
        return this._configDataStore;
    }

    public Integer getMaxDataBrokerCommitQueueSize() {
        return this._maxDataBrokerCommitQueueSize;
    }

    public Integer getMaxDataBrokerFutureCallbackPoolSize() {
        return this._maxDataBrokerFutureCallbackPoolSize;
    }

    public Integer getMaxDataBrokerFutureCallbackQueueSize() {
        return this._maxDataBrokerFutureCallbackQueueSize;
    }

    public OperationalDataStore getOperationalDataStore() {
        return this._operationalDataStore;
    }

    public SchemaService getSchemaService() {
        return this._schemaService;
    }

    public <E extends Augmentation<DomConcurrentDataBroker>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public DomConcurrentDataBrokerBuilder setConfigDataStore(ConfigDataStore value) {
        this._configDataStore = value;
        return this;
    }

    private static void checkMaxDataBrokerCommitQueueSizeRange(int value) {
        if (value >= 0 && value <= 65535) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0..65535]].", value));
    }

    public DomConcurrentDataBrokerBuilder setMaxDataBrokerCommitQueueSize(Integer value) {
        if (value != null) {
            DomConcurrentDataBrokerBuilder.checkMaxDataBrokerCommitQueueSizeRange(value);
        }
        this._maxDataBrokerCommitQueueSize = value;
        return this;
    }

    private static void checkMaxDataBrokerFutureCallbackPoolSizeRange(int value) {
        if (value >= 0 && value <= 65535) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0..65535]].", value));
    }

    public DomConcurrentDataBrokerBuilder setMaxDataBrokerFutureCallbackPoolSize(Integer value) {
        if (value != null) {
            DomConcurrentDataBrokerBuilder.checkMaxDataBrokerFutureCallbackPoolSizeRange(value);
        }
        this._maxDataBrokerFutureCallbackPoolSize = value;
        return this;
    }

    private static void checkMaxDataBrokerFutureCallbackQueueSizeRange(int value) {
        if (value >= 0 && value <= 65535) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0..65535]].", value));
    }

    public DomConcurrentDataBrokerBuilder setMaxDataBrokerFutureCallbackQueueSize(Integer value) {
        if (value != null) {
            DomConcurrentDataBrokerBuilder.checkMaxDataBrokerFutureCallbackQueueSizeRange(value);
        }
        this._maxDataBrokerFutureCallbackQueueSize = value;
        return this;
    }

    public DomConcurrentDataBrokerBuilder setOperationalDataStore(OperationalDataStore value) {
        this._operationalDataStore = value;
        return this;
    }

    public DomConcurrentDataBrokerBuilder setSchemaService(SchemaService value) {
        this._schemaService = value;
        return this;
    }

    public DomConcurrentDataBrokerBuilder addAugmentation(Class<? extends Augmentation<DomConcurrentDataBroker>> augmentationType, Augmentation<DomConcurrentDataBroker> augmentationValue) {
        if (augmentationValue == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<DomConcurrentDataBroker>>, Augmentation<DomConcurrentDataBroker>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public DomConcurrentDataBrokerBuilder removeAugmentation(Class<? extends Augmentation<DomConcurrentDataBroker>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public DomConcurrentDataBroker build() {
        return new DomConcurrentDataBrokerImpl(this);
    }

    private static final class DomConcurrentDataBrokerImpl
    implements DomConcurrentDataBroker {
        private final ConfigDataStore _configDataStore;
        private final Integer _maxDataBrokerCommitQueueSize;
        private final Integer _maxDataBrokerFutureCallbackPoolSize;
        private final Integer _maxDataBrokerFutureCallbackQueueSize;
        private final OperationalDataStore _operationalDataStore;
        private final SchemaService _schemaService;
        private Map<Class<? extends Augmentation<DomConcurrentDataBroker>>, Augmentation<DomConcurrentDataBroker>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<DomConcurrentDataBroker> getImplementedInterface() {
            return DomConcurrentDataBroker.class;
        }

        private DomConcurrentDataBrokerImpl(DomConcurrentDataBrokerBuilder base) {
            this._configDataStore = base.getConfigDataStore();
            this._maxDataBrokerCommitQueueSize = base.getMaxDataBrokerCommitQueueSize();
            this._maxDataBrokerFutureCallbackPoolSize = base.getMaxDataBrokerFutureCallbackPoolSize();
            this._maxDataBrokerFutureCallbackQueueSize = base.getMaxDataBrokerFutureCallbackQueueSize();
            this._operationalDataStore = base.getOperationalDataStore();
            this._schemaService = base.getSchemaService();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<DomConcurrentDataBroker>>, Augmentation<DomConcurrentDataBroker>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<DomConcurrentDataBroker>>, Augmentation<DomConcurrentDataBroker>>(base.augmentation);
                }
            }
        }

        public ConfigDataStore getConfigDataStore() {
            return this._configDataStore;
        }

        public Integer getMaxDataBrokerCommitQueueSize() {
            return this._maxDataBrokerCommitQueueSize;
        }

        public Integer getMaxDataBrokerFutureCallbackPoolSize() {
            return this._maxDataBrokerFutureCallbackPoolSize;
        }

        public Integer getMaxDataBrokerFutureCallbackQueueSize() {
            return this._maxDataBrokerFutureCallbackQueueSize;
        }

        public OperationalDataStore getOperationalDataStore() {
            return this._operationalDataStore;
        }

        public SchemaService getSchemaService() {
            return this._schemaService;
        }

        public <E extends Augmentation<DomConcurrentDataBroker>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._configDataStore);
            result = 31 * result + Objects.hashCode(this._maxDataBrokerCommitQueueSize);
            result = 31 * result + Objects.hashCode(this._maxDataBrokerFutureCallbackPoolSize);
            result = 31 * result + Objects.hashCode(this._maxDataBrokerFutureCallbackQueueSize);
            result = 31 * result + Objects.hashCode(this._operationalDataStore);
            result = 31 * result + Objects.hashCode(this._schemaService);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!DomConcurrentDataBroker.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            DomConcurrentDataBroker other = (DomConcurrentDataBroker)obj;
            if (!Objects.equals(this._configDataStore, other.getConfigDataStore())) {
                return false;
            }
            if (!Objects.equals(this._maxDataBrokerCommitQueueSize, other.getMaxDataBrokerCommitQueueSize())) {
                return false;
            }
            if (!Objects.equals(this._maxDataBrokerFutureCallbackPoolSize, other.getMaxDataBrokerFutureCallbackPoolSize())) {
                return false;
            }
            if (!Objects.equals(this._maxDataBrokerFutureCallbackQueueSize, other.getMaxDataBrokerFutureCallbackQueueSize())) {
                return false;
            }
            if (!Objects.equals(this._operationalDataStore, other.getOperationalDataStore())) {
                return false;
            }
            if (!Objects.equals(this._schemaService, other.getSchemaService())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                DomConcurrentDataBrokerImpl otherImpl = (DomConcurrentDataBrokerImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<DomConcurrentDataBroker>>, Augmentation<DomConcurrentDataBroker>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            String name = "DomConcurrentDataBroker [";
            StringBuilder builder = new StringBuilder(name);
            if (this._configDataStore != null) {
                builder.append("_configDataStore=");
                builder.append(this._configDataStore);
                builder.append(", ");
            }
            if (this._maxDataBrokerCommitQueueSize != null) {
                builder.append("_maxDataBrokerCommitQueueSize=");
                builder.append(this._maxDataBrokerCommitQueueSize);
                builder.append(", ");
            }
            if (this._maxDataBrokerFutureCallbackPoolSize != null) {
                builder.append("_maxDataBrokerFutureCallbackPoolSize=");
                builder.append(this._maxDataBrokerFutureCallbackPoolSize);
                builder.append(", ");
            }
            if (this._maxDataBrokerFutureCallbackQueueSize != null) {
                builder.append("_maxDataBrokerFutureCallbackQueueSize=");
                builder.append(this._maxDataBrokerFutureCallbackQueueSize);
                builder.append(", ");
            }
            if (this._operationalDataStore != null) {
                builder.append("_operationalDataStore=");
                builder.append(this._operationalDataStore);
                builder.append(", ");
            }
            if (this._schemaService != null) {
                builder.append("_schemaService=");
                builder.append(this._schemaService);
            }
            int builderLength = builder.length();
            int builderAdditionalLength = builder.substring(name.length(), builderLength).length();
            if (builderAdditionalLength > 2 && !builder.substring(builderLength - 2, builderLength).equals(", ")) {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

