/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.clustering.entity.owners.rev150804.entity.owners;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.clustering.entity.owners.rev150804.entity.owners.EntityType;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.clustering.entity.owners.rev150804.entity.owners.EntityTypeKey;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.clustering.entity.owners.rev150804.entity.owners.entity.type.Entity;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class EntityTypeBuilder
implements Builder<EntityType> {
    private List<Entity> _entity;
    private EntityTypeKey _key;
    private String _type;
    Map<Class<? extends Augmentation<EntityType>>, Augmentation<EntityType>> augmentation = Collections.emptyMap();

    public EntityTypeBuilder() {
    }

    public EntityTypeBuilder(EntityType base) {
        AugmentationHolder casted;
        if (base.getKey() == null) {
            this._key = new EntityTypeKey(base.getType());
            this._type = base.getType();
        } else {
            this._key = base.getKey();
            this._type = this._key.getType();
        }
        this._entity = base.getEntity();
        if (base instanceof EntityTypeImpl) {
            EntityTypeImpl impl = (EntityTypeImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<EntityType>>, Augmentation<EntityType>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)base).augmentations().isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<EntityType>>, Augmentation<EntityType>>(casted.augmentations());
        }
    }

    public List<Entity> getEntity() {
        return this._entity;
    }

    public EntityTypeKey getKey() {
        return this._key;
    }

    public String getType() {
        return this._type;
    }

    public <E extends Augmentation<EntityType>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public EntityTypeBuilder setEntity(List<Entity> value) {
        this._entity = value;
        return this;
    }

    public EntityTypeBuilder setKey(EntityTypeKey value) {
        this._key = value;
        return this;
    }

    public EntityTypeBuilder setType(String value) {
        this._type = value;
        return this;
    }

    public EntityTypeBuilder addAugmentation(Class<? extends Augmentation<EntityType>> augmentationType, Augmentation<EntityType> augmentationValue) {
        if (augmentationValue == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<EntityType>>, Augmentation<EntityType>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public EntityTypeBuilder removeAugmentation(Class<? extends Augmentation<EntityType>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public EntityType build() {
        return new EntityTypeImpl(this);
    }

    private static final class EntityTypeImpl
    implements EntityType {
        private final List<Entity> _entity;
        private final EntityTypeKey _key;
        private final String _type;
        private Map<Class<? extends Augmentation<EntityType>>, Augmentation<EntityType>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<EntityType> getImplementedInterface() {
            return EntityType.class;
        }

        private EntityTypeImpl(EntityTypeBuilder base) {
            if (base.getKey() == null) {
                this._key = new EntityTypeKey(base.getType());
                this._type = base.getType();
            } else {
                this._key = base.getKey();
                this._type = this._key.getType();
            }
            this._entity = base.getEntity();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<EntityType>>, Augmentation<EntityType>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<EntityType>>, Augmentation<EntityType>>(base.augmentation);
                }
            }
        }

        @Override
        public List<Entity> getEntity() {
            return this._entity;
        }

        @Override
        public EntityTypeKey getKey() {
            return this._key;
        }

        @Override
        public String getType() {
            return this._type;
        }

        public <E extends Augmentation<EntityType>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._entity);
            result = 31 * result + Objects.hashCode(this._key);
            result = 31 * result + Objects.hashCode(this._type);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!EntityType.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            EntityType other = (EntityType)obj;
            if (!Objects.equals(this._entity, other.getEntity())) {
                return false;
            }
            if (!Objects.equals(this._key, other.getKey())) {
                return false;
            }
            if (!Objects.equals(this._type, other.getType())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                EntityTypeImpl otherImpl = (EntityTypeImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<EntityType>>, Augmentation<EntityType>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            String name = "EntityType [";
            StringBuilder builder = new StringBuilder(name);
            if (this._entity != null) {
                builder.append("_entity=");
                builder.append(this._entity);
                builder.append(", ");
            }
            if (this._key != null) {
                builder.append("_key=");
                builder.append(this._key);
                builder.append(", ");
            }
            if (this._type != null) {
                builder.append("_type=");
                builder.append(this._type);
            }
            int builderLength = builder.length();
            int builderAdditionalLength = builder.substring(name.length(), builderLength).length();
            if (builderAdditionalLength > 2 && !builder.substring(builderLength - 2, builderLength).equals(", ")) {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

