/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.clustering.entity.owners.rev150804.entity.owners.entity.type;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.clustering.entity.owners.rev150804.entity.owners.entity.type.Entity;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.clustering.entity.owners.rev150804.entity.owners.entity.type.EntityKey;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.clustering.entity.owners.rev150804.entity.owners.entity.type.entity.Candidate;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.binding.InstanceIdentifier;

public class EntityBuilder
implements Builder<Entity> {
    private List<Candidate> _candidate;
    private InstanceIdentifier<?> _id;
    private EntityKey _key;
    private String _owner;
    Map<Class<? extends Augmentation<Entity>>, Augmentation<Entity>> augmentation = Collections.emptyMap();

    public EntityBuilder() {
    }

    public EntityBuilder(Entity base) {
        AugmentationHolder casted;
        if (base.getKey() == null) {
            this._key = new EntityKey(base.getId());
            this._id = base.getId();
        } else {
            this._key = base.getKey();
            this._id = this._key.getId();
        }
        this._candidate = base.getCandidate();
        this._owner = base.getOwner();
        if (base instanceof EntityImpl) {
            EntityImpl impl = (EntityImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<Entity>>, Augmentation<Entity>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)base).augmentations().isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Entity>>, Augmentation<Entity>>(casted.augmentations());
        }
    }

    public List<Candidate> getCandidate() {
        return this._candidate;
    }

    public InstanceIdentifier<?> getId() {
        return this._id;
    }

    public EntityKey getKey() {
        return this._key;
    }

    public String getOwner() {
        return this._owner;
    }

    public <E extends Augmentation<Entity>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public EntityBuilder setCandidate(List<Candidate> value) {
        this._candidate = value;
        return this;
    }

    public EntityBuilder setId(InstanceIdentifier<?> value) {
        this._id = value;
        return this;
    }

    public EntityBuilder setKey(EntityKey value) {
        this._key = value;
        return this;
    }

    public EntityBuilder setOwner(String value) {
        this._owner = value;
        return this;
    }

    public EntityBuilder addAugmentation(Class<? extends Augmentation<Entity>> augmentationType, Augmentation<Entity> augmentationValue) {
        if (augmentationValue == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Entity>>, Augmentation<Entity>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public EntityBuilder removeAugmentation(Class<? extends Augmentation<Entity>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public Entity build() {
        return new EntityImpl(this);
    }

    private static final class EntityImpl
    implements Entity {
        private final List<Candidate> _candidate;
        private final InstanceIdentifier<?> _id;
        private final EntityKey _key;
        private final String _owner;
        private Map<Class<? extends Augmentation<Entity>>, Augmentation<Entity>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<Entity> getImplementedInterface() {
            return Entity.class;
        }

        private EntityImpl(EntityBuilder base) {
            if (base.getKey() == null) {
                this._key = new EntityKey(base.getId());
                this._id = base.getId();
            } else {
                this._key = base.getKey();
                this._id = this._key.getId();
            }
            this._candidate = base.getCandidate();
            this._owner = base.getOwner();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<Entity>>, Augmentation<Entity>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<Entity>>, Augmentation<Entity>>(base.augmentation);
                }
            }
        }

        @Override
        public List<Candidate> getCandidate() {
            return this._candidate;
        }

        @Override
        public InstanceIdentifier<?> getId() {
            return this._id;
        }

        @Override
        public EntityKey getKey() {
            return this._key;
        }

        @Override
        public String getOwner() {
            return this._owner;
        }

        public <E extends Augmentation<Entity>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._candidate);
            result = 31 * result + Objects.hashCode(this._id);
            result = 31 * result + Objects.hashCode(this._key);
            result = 31 * result + Objects.hashCode(this._owner);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!Entity.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            Entity other = (Entity)obj;
            if (!Objects.equals(this._candidate, other.getCandidate())) {
                return false;
            }
            if (!Objects.equals(this._id, other.getId())) {
                return false;
            }
            if (!Objects.equals(this._key, other.getKey())) {
                return false;
            }
            if (!Objects.equals(this._owner, other.getOwner())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                EntityImpl otherImpl = (EntityImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<Entity>>, Augmentation<Entity>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            String name = "Entity [";
            StringBuilder builder = new StringBuilder(name);
            if (this._candidate != null) {
                builder.append("_candidate=");
                builder.append(this._candidate);
                builder.append(", ");
            }
            if (this._id != null) {
                builder.append("_id=");
                builder.append(this._id);
                builder.append(", ");
            }
            if (this._key != null) {
                builder.append("_key=");
                builder.append(this._key);
                builder.append(", ");
            }
            if (this._owner != null) {
                builder.append("_owner=");
                builder.append(this._owner);
            }
            int builderLength = builder.length();
            int builderAdditionalLength = builder.substring(name.length(), builderLength).length();
            if (builderAdditionalLength > 2 && !builder.substring(builderLength - 2, builderLength).equals(", ")) {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

