package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.concurrent.data.broker.rev141124.modules.module.configuration;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.dom.impl.rev131028.dom.broker.config.ConfigDataStore;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.dom.impl.rev131028.dom.broker.config.OperationalDataStore;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.dom.impl.rev131028.dom.broker.config.SchemaService;
import java.util.HashMap;
import org.opendaylight.yangtools.concepts.Builder;
import java.util.Objects;
import java.util.Collections;
import java.util.Map;

/**
 * Class that builds {@link org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.concurrent.data.broker.rev141124.modules.module.configuration.DomConcurrentDataBroker} instances.
 *
 * @see org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.concurrent.data.broker.rev141124.modules.module.configuration.DomConcurrentDataBroker
 *
 */
public class DomConcurrentDataBrokerBuilder implements Builder<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.concurrent.data.broker.rev141124.modules.module.configuration.DomConcurrentDataBroker> {

    private ConfigDataStore _configDataStore;
    private java.lang.Integer _maxDataBrokerCommitQueueSize;
    private java.lang.Integer _maxDataBrokerFutureCallbackPoolSize;
    private java.lang.Integer _maxDataBrokerFutureCallbackQueueSize;
    private OperationalDataStore _operationalDataStore;
    private SchemaService _schemaService;

    Map<java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.concurrent.data.broker.rev141124.modules.module.configuration.DomConcurrentDataBroker>>, Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.concurrent.data.broker.rev141124.modules.module.configuration.DomConcurrentDataBroker>> augmentation = Collections.emptyMap();

    public DomConcurrentDataBrokerBuilder() {
    }
    public DomConcurrentDataBrokerBuilder(org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.dom.impl.rev131028.DomBrokerConfig arg) {
        this._schemaService = arg.getSchemaService();
        this._configDataStore = arg.getConfigDataStore();
        this._operationalDataStore = arg.getOperationalDataStore();
        this._maxDataBrokerFutureCallbackQueueSize = arg.getMaxDataBrokerFutureCallbackQueueSize();
        this._maxDataBrokerFutureCallbackPoolSize = arg.getMaxDataBrokerFutureCallbackPoolSize();
        this._maxDataBrokerCommitQueueSize = arg.getMaxDataBrokerCommitQueueSize();
    }

    public DomConcurrentDataBrokerBuilder(DomConcurrentDataBroker base) {
        this._configDataStore = base.getConfigDataStore();
        this._maxDataBrokerCommitQueueSize = base.getMaxDataBrokerCommitQueueSize();
        this._maxDataBrokerFutureCallbackPoolSize = base.getMaxDataBrokerFutureCallbackPoolSize();
        this._maxDataBrokerFutureCallbackQueueSize = base.getMaxDataBrokerFutureCallbackQueueSize();
        this._operationalDataStore = base.getOperationalDataStore();
        this._schemaService = base.getSchemaService();
        if (base instanceof DomConcurrentDataBrokerImpl) {
            DomConcurrentDataBrokerImpl impl = (DomConcurrentDataBrokerImpl) base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder) {
            @SuppressWarnings("unchecked")
            AugmentationHolder<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.concurrent.data.broker.rev141124.modules.module.configuration.DomConcurrentDataBroker> casted =(AugmentationHolder<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.concurrent.data.broker.rev141124.modules.module.configuration.DomConcurrentDataBroker>) base;
            if (!casted.augmentations().isEmpty()) {
                this.augmentation = new HashMap<>(casted.augmentations());
            }
        }
    }

    /**
     *Set fields from given grouping argument. Valid argument is instance of one of following types:
     * <ul>
     * <li>org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.dom.impl.rev131028.DomBrokerConfig</li>
     * </ul>
     *
     * @param arg grouping object
     * @throws IllegalArgumentException if given argument is none of valid types
    */
    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.dom.impl.rev131028.DomBrokerConfig) {
            this._schemaService = ((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.dom.impl.rev131028.DomBrokerConfig)arg).getSchemaService();
            this._configDataStore = ((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.dom.impl.rev131028.DomBrokerConfig)arg).getConfigDataStore();
            this._operationalDataStore = ((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.dom.impl.rev131028.DomBrokerConfig)arg).getOperationalDataStore();
            this._maxDataBrokerFutureCallbackQueueSize = ((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.dom.impl.rev131028.DomBrokerConfig)arg).getMaxDataBrokerFutureCallbackQueueSize();
            this._maxDataBrokerFutureCallbackPoolSize = ((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.dom.impl.rev131028.DomBrokerConfig)arg).getMaxDataBrokerFutureCallbackPoolSize();
            this._maxDataBrokerCommitQueueSize = ((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.dom.impl.rev131028.DomBrokerConfig)arg).getMaxDataBrokerCommitQueueSize();
            isValidArg = true;
        }
        if (!isValidArg) {
            throw new IllegalArgumentException(
              "expected one of: [org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.dom.impl.rev131028.DomBrokerConfig] \n" +
              "but was: " + arg
            );
        }
    }

    public ConfigDataStore getConfigDataStore() {
        return _configDataStore;
    }
    
    public java.lang.Integer getMaxDataBrokerCommitQueueSize() {
        return _maxDataBrokerCommitQueueSize;
    }
    
    public java.lang.Integer getMaxDataBrokerFutureCallbackPoolSize() {
        return _maxDataBrokerFutureCallbackPoolSize;
    }
    
    public java.lang.Integer getMaxDataBrokerFutureCallbackQueueSize() {
        return _maxDataBrokerFutureCallbackQueueSize;
    }
    
    public OperationalDataStore getOperationalDataStore() {
        return _operationalDataStore;
    }
    
    public SchemaService getSchemaService() {
        return _schemaService;
    }
    
    @SuppressWarnings("unchecked")
    public <E extends Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.concurrent.data.broker.rev141124.modules.module.configuration.DomConcurrentDataBroker>> E getAugmentation(java.lang.Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E) augmentation.get(augmentationType);
    }

     
    public DomConcurrentDataBrokerBuilder setConfigDataStore(final ConfigDataStore value) {
        this._configDataStore = value;
        return this;
    }
    
     
     private static void checkMaxDataBrokerCommitQueueSizeRange(final int value) {
         if (value >= 0 && value <= 65535) {
             return;
         }
         throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0..65535]].", value));
     }
    
    public DomConcurrentDataBrokerBuilder setMaxDataBrokerCommitQueueSize(final java.lang.Integer value) {
    if (value != null) {
        checkMaxDataBrokerCommitQueueSizeRange(value);
    }
        this._maxDataBrokerCommitQueueSize = value;
        return this;
    }
    
     
     private static void checkMaxDataBrokerFutureCallbackPoolSizeRange(final int value) {
         if (value >= 0 && value <= 65535) {
             return;
         }
         throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0..65535]].", value));
     }
    
    public DomConcurrentDataBrokerBuilder setMaxDataBrokerFutureCallbackPoolSize(final java.lang.Integer value) {
    if (value != null) {
        checkMaxDataBrokerFutureCallbackPoolSizeRange(value);
    }
        this._maxDataBrokerFutureCallbackPoolSize = value;
        return this;
    }
    
     
     private static void checkMaxDataBrokerFutureCallbackQueueSizeRange(final int value) {
         if (value >= 0 && value <= 65535) {
             return;
         }
         throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0..65535]].", value));
     }
    
    public DomConcurrentDataBrokerBuilder setMaxDataBrokerFutureCallbackQueueSize(final java.lang.Integer value) {
    if (value != null) {
        checkMaxDataBrokerFutureCallbackQueueSizeRange(value);
    }
        this._maxDataBrokerFutureCallbackQueueSize = value;
        return this;
    }
    
     
    public DomConcurrentDataBrokerBuilder setOperationalDataStore(final OperationalDataStore value) {
        this._operationalDataStore = value;
        return this;
    }
    
     
    public DomConcurrentDataBrokerBuilder setSchemaService(final SchemaService value) {
        this._schemaService = value;
        return this;
    }
    
    public DomConcurrentDataBrokerBuilder addAugmentation(java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.concurrent.data.broker.rev141124.modules.module.configuration.DomConcurrentDataBroker>> augmentationType, Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.concurrent.data.broker.rev141124.modules.module.configuration.DomConcurrentDataBroker> augmentationValue) {
        if (augmentationValue == null) {
            return removeAugmentation(augmentationType);
        }
    
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }
    
    public DomConcurrentDataBrokerBuilder removeAugmentation(java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.concurrent.data.broker.rev141124.modules.module.configuration.DomConcurrentDataBroker>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public DomConcurrentDataBroker build() {
        return new DomConcurrentDataBrokerImpl(this);
    }

    private static final class DomConcurrentDataBrokerImpl implements DomConcurrentDataBroker {

        @Override
        public java.lang.Class<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.concurrent.data.broker.rev141124.modules.module.configuration.DomConcurrentDataBroker> getImplementedInterface() {
            return org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.concurrent.data.broker.rev141124.modules.module.configuration.DomConcurrentDataBroker.class;
        }

        private final ConfigDataStore _configDataStore;
        private final java.lang.Integer _maxDataBrokerCommitQueueSize;
        private final java.lang.Integer _maxDataBrokerFutureCallbackPoolSize;
        private final java.lang.Integer _maxDataBrokerFutureCallbackQueueSize;
        private final OperationalDataStore _operationalDataStore;
        private final SchemaService _schemaService;

        private Map<java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.concurrent.data.broker.rev141124.modules.module.configuration.DomConcurrentDataBroker>>, Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.concurrent.data.broker.rev141124.modules.module.configuration.DomConcurrentDataBroker>> augmentation = Collections.emptyMap();

        private DomConcurrentDataBrokerImpl(DomConcurrentDataBrokerBuilder base) {
            this._configDataStore = base.getConfigDataStore();
            this._maxDataBrokerCommitQueueSize = base.getMaxDataBrokerCommitQueueSize();
            this._maxDataBrokerFutureCallbackPoolSize = base.getMaxDataBrokerFutureCallbackPoolSize();
            this._maxDataBrokerFutureCallbackQueueSize = base.getMaxDataBrokerFutureCallbackQueueSize();
            this._operationalDataStore = base.getOperationalDataStore();
            this._schemaService = base.getSchemaService();
            switch (base.augmentation.size()) {
            case 0:
                this.augmentation = Collections.emptyMap();
                break;
            case 1:
                final Map.Entry<java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.concurrent.data.broker.rev141124.modules.module.configuration.DomConcurrentDataBroker>>, Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.concurrent.data.broker.rev141124.modules.module.configuration.DomConcurrentDataBroker>> e = base.augmentation.entrySet().iterator().next();
                this.augmentation = Collections.<java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.concurrent.data.broker.rev141124.modules.module.configuration.DomConcurrentDataBroker>>, Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.concurrent.data.broker.rev141124.modules.module.configuration.DomConcurrentDataBroker>>singletonMap(e.getKey(), e.getValue());
                break;
            default :
                this.augmentation = new HashMap<>(base.augmentation);
            }
        }

        @Override
        public ConfigDataStore getConfigDataStore() {
            return _configDataStore;
        }
        
        @Override
        public java.lang.Integer getMaxDataBrokerCommitQueueSize() {
            return _maxDataBrokerCommitQueueSize;
        }
        
        @Override
        public java.lang.Integer getMaxDataBrokerFutureCallbackPoolSize() {
            return _maxDataBrokerFutureCallbackPoolSize;
        }
        
        @Override
        public java.lang.Integer getMaxDataBrokerFutureCallbackQueueSize() {
            return _maxDataBrokerFutureCallbackQueueSize;
        }
        
        @Override
        public OperationalDataStore getOperationalDataStore() {
            return _operationalDataStore;
        }
        
        @Override
        public SchemaService getSchemaService() {
            return _schemaService;
        }
        
        @SuppressWarnings("unchecked")
        @Override
        public <E extends Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.concurrent.data.broker.rev141124.modules.module.configuration.DomConcurrentDataBroker>> E getAugmentation(java.lang.Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E) augmentation.get(augmentationType);
        }

        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int prime = 31;
            int result = 1;
            result = prime * result + Objects.hashCode(_configDataStore);
            result = prime * result + Objects.hashCode(_maxDataBrokerCommitQueueSize);
            result = prime * result + Objects.hashCode(_maxDataBrokerFutureCallbackPoolSize);
            result = prime * result + Objects.hashCode(_maxDataBrokerFutureCallbackQueueSize);
            result = prime * result + Objects.hashCode(_operationalDataStore);
            result = prime * result + Objects.hashCode(_schemaService);
            result = prime * result + Objects.hashCode(augmentation);
        
            hash = result;
            hashValid = true;
            return result;
        }

        @Override
        public boolean equals(java.lang.Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.concurrent.data.broker.rev141124.modules.module.configuration.DomConcurrentDataBroker.class.equals(((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.concurrent.data.broker.rev141124.modules.module.configuration.DomConcurrentDataBroker other = (org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.concurrent.data.broker.rev141124.modules.module.configuration.DomConcurrentDataBroker)obj;
            if (!Objects.equals(_configDataStore, other.getConfigDataStore())) {
                return false;
            }
            if (!Objects.equals(_maxDataBrokerCommitQueueSize, other.getMaxDataBrokerCommitQueueSize())) {
                return false;
            }
            if (!Objects.equals(_maxDataBrokerFutureCallbackPoolSize, other.getMaxDataBrokerFutureCallbackPoolSize())) {
                return false;
            }
            if (!Objects.equals(_maxDataBrokerFutureCallbackQueueSize, other.getMaxDataBrokerFutureCallbackQueueSize())) {
                return false;
            }
            if (!Objects.equals(_operationalDataStore, other.getOperationalDataStore())) {
                return false;
            }
            if (!Objects.equals(_schemaService, other.getSchemaService())) {
                return false;
            }
            if (getClass() == obj.getClass()) {
                // Simple case: we are comparing against self
                DomConcurrentDataBrokerImpl otherImpl = (DomConcurrentDataBrokerImpl) obj;
                if (!Objects.equals(augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                // Hard case: compare our augments with presence there...
                for (Map.Entry<java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.concurrent.data.broker.rev141124.modules.module.configuration.DomConcurrentDataBroker>>, Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.concurrent.data.broker.rev141124.modules.module.configuration.DomConcurrentDataBroker>> e : augmentation.entrySet()) {
                    if (!e.getValue().equals(other.getAugmentation(e.getKey()))) {
                        return false;
                    }
                }
                // .. and give the other one the chance to do the same
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        @Override
        public java.lang.String toString() {
            java.lang.String name = "DomConcurrentDataBroker [";
            java.lang.StringBuilder builder = new java.lang.StringBuilder (name);
            if (_configDataStore != null) {
                builder.append("_configDataStore=");
                builder.append(_configDataStore);
                builder.append(", ");
            }
            if (_maxDataBrokerCommitQueueSize != null) {
                builder.append("_maxDataBrokerCommitQueueSize=");
                builder.append(_maxDataBrokerCommitQueueSize);
                builder.append(", ");
            }
            if (_maxDataBrokerFutureCallbackPoolSize != null) {
                builder.append("_maxDataBrokerFutureCallbackPoolSize=");
                builder.append(_maxDataBrokerFutureCallbackPoolSize);
                builder.append(", ");
            }
            if (_maxDataBrokerFutureCallbackQueueSize != null) {
                builder.append("_maxDataBrokerFutureCallbackQueueSize=");
                builder.append(_maxDataBrokerFutureCallbackQueueSize);
                builder.append(", ");
            }
            if (_operationalDataStore != null) {
                builder.append("_operationalDataStore=");
                builder.append(_operationalDataStore);
                builder.append(", ");
            }
            if (_schemaService != null) {
                builder.append("_schemaService=");
                builder.append(_schemaService);
            }
            final int builderLength = builder.length();
            final int builderAdditionalLength = builder.substring(name.length(), builderLength).length();
            if (builderAdditionalLength > 2 && !builder.substring(builderLength - 2, builderLength).equals(", ")) {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(augmentation.values());
            return builder.append(']').toString();
        }
    }

}
