package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.concurrent.data.broker.rev141124.modules.module.state;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;
import java.util.HashMap;
import org.opendaylight.yangtools.concepts.Builder;
import java.util.Objects;
import java.math.BigInteger;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.yang.types.rev130715.DateAndTime;
import java.util.Collections;
import java.util.Map;

/**
 * Class that builds {@link org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.concurrent.data.broker.rev141124.modules.module.state.DomConcurrentDataBroker} instances.
 *
 * @see org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.concurrent.data.broker.rev141124.modules.module.state.DomConcurrentDataBroker
 *
 */
public class DomConcurrentDataBrokerBuilder implements Builder<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.concurrent.data.broker.rev141124.modules.module.state.DomConcurrentDataBroker> {

    private BigInteger _averageCommit;
    private BigInteger _longestCommitDuration;
    private DateAndTime _longestCommitTimestamp;
    private BigInteger _shortestCommitDuration;
    private DateAndTime _shortestCommitTimestamp;
    private BigInteger _totalCommits;

    Map<java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.concurrent.data.broker.rev141124.modules.module.state.DomConcurrentDataBroker>>, Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.concurrent.data.broker.rev141124.modules.module.state.DomConcurrentDataBroker>> augmentation = Collections.emptyMap();

    public DomConcurrentDataBrokerBuilder() {
    }
    public DomConcurrentDataBrokerBuilder(org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.dom.impl.rev131028.DomBrokerOperational arg) {
        this._totalCommits = arg.getTotalCommits();
        this._averageCommit = arg.getAverageCommit();
        this._longestCommitDuration = arg.getLongestCommitDuration();
        this._longestCommitTimestamp = arg.getLongestCommitTimestamp();
        this._shortestCommitDuration = arg.getShortestCommitDuration();
        this._shortestCommitTimestamp = arg.getShortestCommitTimestamp();
    }

    public DomConcurrentDataBrokerBuilder(DomConcurrentDataBroker base) {
        this._averageCommit = base.getAverageCommit();
        this._longestCommitDuration = base.getLongestCommitDuration();
        this._longestCommitTimestamp = base.getLongestCommitTimestamp();
        this._shortestCommitDuration = base.getShortestCommitDuration();
        this._shortestCommitTimestamp = base.getShortestCommitTimestamp();
        this._totalCommits = base.getTotalCommits();
        if (base instanceof DomConcurrentDataBrokerImpl) {
            DomConcurrentDataBrokerImpl impl = (DomConcurrentDataBrokerImpl) base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder) {
            @SuppressWarnings("unchecked")
            AugmentationHolder<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.concurrent.data.broker.rev141124.modules.module.state.DomConcurrentDataBroker> casted =(AugmentationHolder<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.concurrent.data.broker.rev141124.modules.module.state.DomConcurrentDataBroker>) base;
            if (!casted.augmentations().isEmpty()) {
                this.augmentation = new HashMap<>(casted.augmentations());
            }
        }
    }

    /**
     *Set fields from given grouping argument. Valid argument is instance of one of following types:
     * <ul>
     * <li>org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.dom.impl.rev131028.DomBrokerOperational</li>
     * </ul>
     *
     * @param arg grouping object
     * @throws IllegalArgumentException if given argument is none of valid types
    */
    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.dom.impl.rev131028.DomBrokerOperational) {
            this._totalCommits = ((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.dom.impl.rev131028.DomBrokerOperational)arg).getTotalCommits();
            this._averageCommit = ((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.dom.impl.rev131028.DomBrokerOperational)arg).getAverageCommit();
            this._longestCommitDuration = ((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.dom.impl.rev131028.DomBrokerOperational)arg).getLongestCommitDuration();
            this._longestCommitTimestamp = ((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.dom.impl.rev131028.DomBrokerOperational)arg).getLongestCommitTimestamp();
            this._shortestCommitDuration = ((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.dom.impl.rev131028.DomBrokerOperational)arg).getShortestCommitDuration();
            this._shortestCommitTimestamp = ((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.dom.impl.rev131028.DomBrokerOperational)arg).getShortestCommitTimestamp();
            isValidArg = true;
        }
        if (!isValidArg) {
            throw new IllegalArgumentException(
              "expected one of: [org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.dom.impl.rev131028.DomBrokerOperational] \n" +
              "but was: " + arg
            );
        }
    }

    public BigInteger getAverageCommit() {
        return _averageCommit;
    }
    
    public BigInteger getLongestCommitDuration() {
        return _longestCommitDuration;
    }
    
    public DateAndTime getLongestCommitTimestamp() {
        return _longestCommitTimestamp;
    }
    
    public BigInteger getShortestCommitDuration() {
        return _shortestCommitDuration;
    }
    
    public DateAndTime getShortestCommitTimestamp() {
        return _shortestCommitTimestamp;
    }
    
    public BigInteger getTotalCommits() {
        return _totalCommits;
    }
    
    @SuppressWarnings("unchecked")
    public <E extends Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.concurrent.data.broker.rev141124.modules.module.state.DomConcurrentDataBroker>> E getAugmentation(java.lang.Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E) augmentation.get(augmentationType);
    }

     
     private static final com.google.common.collect.Range<java.math.BigInteger>[] CHECKAVERAGECOMMITRANGE_RANGES;
     static {
         @SuppressWarnings("unchecked")
         final com.google.common.collect.Range<java.math.BigInteger>[] a = (com.google.common.collect.Range<java.math.BigInteger>[]) java.lang.reflect.Array.newInstance(com.google.common.collect.Range.class, 1);
         a[0] = com.google.common.collect.Range.closed(java.math.BigInteger.ZERO, new java.math.BigInteger("18446744073709551615"));
         CHECKAVERAGECOMMITRANGE_RANGES = a;
     }
     private static void checkAverageCommitRange(final java.math.BigInteger value) {
         for (com.google.common.collect.Range<java.math.BigInteger> r : CHECKAVERAGECOMMITRANGE_RANGES) {
             if (r.contains(value)) {
                 return;
             }
         }
         throw new IllegalArgumentException(String.format("Invalid range: %s, expected: %s.", value, java.util.Arrays.asList(CHECKAVERAGECOMMITRANGE_RANGES)));
     }
    
    public DomConcurrentDataBrokerBuilder setAverageCommit(final BigInteger value) {
    if (value != null) {
        checkAverageCommitRange(value);
    }
        this._averageCommit = value;
        return this;
    }
    
     
     private static final com.google.common.collect.Range<java.math.BigInteger>[] CHECKLONGESTCOMMITDURATIONRANGE_RANGES;
     static {
         @SuppressWarnings("unchecked")
         final com.google.common.collect.Range<java.math.BigInteger>[] a = (com.google.common.collect.Range<java.math.BigInteger>[]) java.lang.reflect.Array.newInstance(com.google.common.collect.Range.class, 1);
         a[0] = com.google.common.collect.Range.closed(java.math.BigInteger.ZERO, new java.math.BigInteger("18446744073709551615"));
         CHECKLONGESTCOMMITDURATIONRANGE_RANGES = a;
     }
     private static void checkLongestCommitDurationRange(final java.math.BigInteger value) {
         for (com.google.common.collect.Range<java.math.BigInteger> r : CHECKLONGESTCOMMITDURATIONRANGE_RANGES) {
             if (r.contains(value)) {
                 return;
             }
         }
         throw new IllegalArgumentException(String.format("Invalid range: %s, expected: %s.", value, java.util.Arrays.asList(CHECKLONGESTCOMMITDURATIONRANGE_RANGES)));
     }
    
    public DomConcurrentDataBrokerBuilder setLongestCommitDuration(final BigInteger value) {
    if (value != null) {
        checkLongestCommitDurationRange(value);
    }
        this._longestCommitDuration = value;
        return this;
    }
    
     
    public DomConcurrentDataBrokerBuilder setLongestCommitTimestamp(final DateAndTime value) {
        this._longestCommitTimestamp = value;
        return this;
    }
    
     
     private static final com.google.common.collect.Range<java.math.BigInteger>[] CHECKSHORTESTCOMMITDURATIONRANGE_RANGES;
     static {
         @SuppressWarnings("unchecked")
         final com.google.common.collect.Range<java.math.BigInteger>[] a = (com.google.common.collect.Range<java.math.BigInteger>[]) java.lang.reflect.Array.newInstance(com.google.common.collect.Range.class, 1);
         a[0] = com.google.common.collect.Range.closed(java.math.BigInteger.ZERO, new java.math.BigInteger("18446744073709551615"));
         CHECKSHORTESTCOMMITDURATIONRANGE_RANGES = a;
     }
     private static void checkShortestCommitDurationRange(final java.math.BigInteger value) {
         for (com.google.common.collect.Range<java.math.BigInteger> r : CHECKSHORTESTCOMMITDURATIONRANGE_RANGES) {
             if (r.contains(value)) {
                 return;
             }
         }
         throw new IllegalArgumentException(String.format("Invalid range: %s, expected: %s.", value, java.util.Arrays.asList(CHECKSHORTESTCOMMITDURATIONRANGE_RANGES)));
     }
    
    public DomConcurrentDataBrokerBuilder setShortestCommitDuration(final BigInteger value) {
    if (value != null) {
        checkShortestCommitDurationRange(value);
    }
        this._shortestCommitDuration = value;
        return this;
    }
    
     
    public DomConcurrentDataBrokerBuilder setShortestCommitTimestamp(final DateAndTime value) {
        this._shortestCommitTimestamp = value;
        return this;
    }
    
     
     private static final com.google.common.collect.Range<java.math.BigInteger>[] CHECKTOTALCOMMITSRANGE_RANGES;
     static {
         @SuppressWarnings("unchecked")
         final com.google.common.collect.Range<java.math.BigInteger>[] a = (com.google.common.collect.Range<java.math.BigInteger>[]) java.lang.reflect.Array.newInstance(com.google.common.collect.Range.class, 1);
         a[0] = com.google.common.collect.Range.closed(java.math.BigInteger.ZERO, new java.math.BigInteger("18446744073709551615"));
         CHECKTOTALCOMMITSRANGE_RANGES = a;
     }
     private static void checkTotalCommitsRange(final java.math.BigInteger value) {
         for (com.google.common.collect.Range<java.math.BigInteger> r : CHECKTOTALCOMMITSRANGE_RANGES) {
             if (r.contains(value)) {
                 return;
             }
         }
         throw new IllegalArgumentException(String.format("Invalid range: %s, expected: %s.", value, java.util.Arrays.asList(CHECKTOTALCOMMITSRANGE_RANGES)));
     }
    
    public DomConcurrentDataBrokerBuilder setTotalCommits(final BigInteger value) {
    if (value != null) {
        checkTotalCommitsRange(value);
    }
        this._totalCommits = value;
        return this;
    }
    
    public DomConcurrentDataBrokerBuilder addAugmentation(java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.concurrent.data.broker.rev141124.modules.module.state.DomConcurrentDataBroker>> augmentationType, Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.concurrent.data.broker.rev141124.modules.module.state.DomConcurrentDataBroker> augmentationValue) {
        if (augmentationValue == null) {
            return removeAugmentation(augmentationType);
        }
    
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }
    
    public DomConcurrentDataBrokerBuilder removeAugmentation(java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.concurrent.data.broker.rev141124.modules.module.state.DomConcurrentDataBroker>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public DomConcurrentDataBroker build() {
        return new DomConcurrentDataBrokerImpl(this);
    }

    private static final class DomConcurrentDataBrokerImpl implements DomConcurrentDataBroker {

        @Override
        public java.lang.Class<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.concurrent.data.broker.rev141124.modules.module.state.DomConcurrentDataBroker> getImplementedInterface() {
            return org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.concurrent.data.broker.rev141124.modules.module.state.DomConcurrentDataBroker.class;
        }

        private final BigInteger _averageCommit;
        private final BigInteger _longestCommitDuration;
        private final DateAndTime _longestCommitTimestamp;
        private final BigInteger _shortestCommitDuration;
        private final DateAndTime _shortestCommitTimestamp;
        private final BigInteger _totalCommits;

        private Map<java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.concurrent.data.broker.rev141124.modules.module.state.DomConcurrentDataBroker>>, Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.concurrent.data.broker.rev141124.modules.module.state.DomConcurrentDataBroker>> augmentation = Collections.emptyMap();

        private DomConcurrentDataBrokerImpl(DomConcurrentDataBrokerBuilder base) {
            this._averageCommit = base.getAverageCommit();
            this._longestCommitDuration = base.getLongestCommitDuration();
            this._longestCommitTimestamp = base.getLongestCommitTimestamp();
            this._shortestCommitDuration = base.getShortestCommitDuration();
            this._shortestCommitTimestamp = base.getShortestCommitTimestamp();
            this._totalCommits = base.getTotalCommits();
            switch (base.augmentation.size()) {
            case 0:
                this.augmentation = Collections.emptyMap();
                break;
            case 1:
                final Map.Entry<java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.concurrent.data.broker.rev141124.modules.module.state.DomConcurrentDataBroker>>, Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.concurrent.data.broker.rev141124.modules.module.state.DomConcurrentDataBroker>> e = base.augmentation.entrySet().iterator().next();
                this.augmentation = Collections.<java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.concurrent.data.broker.rev141124.modules.module.state.DomConcurrentDataBroker>>, Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.concurrent.data.broker.rev141124.modules.module.state.DomConcurrentDataBroker>>singletonMap(e.getKey(), e.getValue());
                break;
            default :
                this.augmentation = new HashMap<>(base.augmentation);
            }
        }

        @Override
        public BigInteger getAverageCommit() {
            return _averageCommit;
        }
        
        @Override
        public BigInteger getLongestCommitDuration() {
            return _longestCommitDuration;
        }
        
        @Override
        public DateAndTime getLongestCommitTimestamp() {
            return _longestCommitTimestamp;
        }
        
        @Override
        public BigInteger getShortestCommitDuration() {
            return _shortestCommitDuration;
        }
        
        @Override
        public DateAndTime getShortestCommitTimestamp() {
            return _shortestCommitTimestamp;
        }
        
        @Override
        public BigInteger getTotalCommits() {
            return _totalCommits;
        }
        
        @SuppressWarnings("unchecked")
        @Override
        public <E extends Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.concurrent.data.broker.rev141124.modules.module.state.DomConcurrentDataBroker>> E getAugmentation(java.lang.Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E) augmentation.get(augmentationType);
        }

        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int prime = 31;
            int result = 1;
            result = prime * result + Objects.hashCode(_averageCommit);
            result = prime * result + Objects.hashCode(_longestCommitDuration);
            result = prime * result + Objects.hashCode(_longestCommitTimestamp);
            result = prime * result + Objects.hashCode(_shortestCommitDuration);
            result = prime * result + Objects.hashCode(_shortestCommitTimestamp);
            result = prime * result + Objects.hashCode(_totalCommits);
            result = prime * result + Objects.hashCode(augmentation);
        
            hash = result;
            hashValid = true;
            return result;
        }

        @Override
        public boolean equals(java.lang.Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.concurrent.data.broker.rev141124.modules.module.state.DomConcurrentDataBroker.class.equals(((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.concurrent.data.broker.rev141124.modules.module.state.DomConcurrentDataBroker other = (org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.concurrent.data.broker.rev141124.modules.module.state.DomConcurrentDataBroker)obj;
            if (!Objects.equals(_averageCommit, other.getAverageCommit())) {
                return false;
            }
            if (!Objects.equals(_longestCommitDuration, other.getLongestCommitDuration())) {
                return false;
            }
            if (!Objects.equals(_longestCommitTimestamp, other.getLongestCommitTimestamp())) {
                return false;
            }
            if (!Objects.equals(_shortestCommitDuration, other.getShortestCommitDuration())) {
                return false;
            }
            if (!Objects.equals(_shortestCommitTimestamp, other.getShortestCommitTimestamp())) {
                return false;
            }
            if (!Objects.equals(_totalCommits, other.getTotalCommits())) {
                return false;
            }
            if (getClass() == obj.getClass()) {
                // Simple case: we are comparing against self
                DomConcurrentDataBrokerImpl otherImpl = (DomConcurrentDataBrokerImpl) obj;
                if (!Objects.equals(augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                // Hard case: compare our augments with presence there...
                for (Map.Entry<java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.concurrent.data.broker.rev141124.modules.module.state.DomConcurrentDataBroker>>, Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.concurrent.data.broker.rev141124.modules.module.state.DomConcurrentDataBroker>> e : augmentation.entrySet()) {
                    if (!e.getValue().equals(other.getAugmentation(e.getKey()))) {
                        return false;
                    }
                }
                // .. and give the other one the chance to do the same
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        @Override
        public java.lang.String toString() {
            java.lang.String name = "DomConcurrentDataBroker [";
            java.lang.StringBuilder builder = new java.lang.StringBuilder (name);
            if (_averageCommit != null) {
                builder.append("_averageCommit=");
                builder.append(_averageCommit);
                builder.append(", ");
            }
            if (_longestCommitDuration != null) {
                builder.append("_longestCommitDuration=");
                builder.append(_longestCommitDuration);
                builder.append(", ");
            }
            if (_longestCommitTimestamp != null) {
                builder.append("_longestCommitTimestamp=");
                builder.append(_longestCommitTimestamp);
                builder.append(", ");
            }
            if (_shortestCommitDuration != null) {
                builder.append("_shortestCommitDuration=");
                builder.append(_shortestCommitDuration);
                builder.append(", ");
            }
            if (_shortestCommitTimestamp != null) {
                builder.append("_shortestCommitTimestamp=");
                builder.append(_shortestCommitTimestamp);
                builder.append(", ");
            }
            if (_totalCommits != null) {
                builder.append("_totalCommits=");
                builder.append(_totalCommits);
            }
            final int builderLength = builder.length();
            final int builderAdditionalLength = builder.substring(name.length(), builderLength).length();
            if (builderAdditionalLength > 2 && !builder.substring(builderLength - 2, builderLength).equals(", ")) {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(augmentation.values());
            return builder.append(']').toString();
        }
    }

}
