package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.distributed.datastore.provider.rev140612;
import java.io.Serializable;
import java.beans.ConstructorProperties;
import java.util.Objects;

public class NonZeroUint32Type
 implements Serializable {
    private static final long serialVersionUID = -7519597503656647670L;
    private final java.lang.Long _value;

    private static void check_valueRange(final long value) {
        if (value >= 1L && value <= 4294967295L) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[1..4294967295]].", value));
    }

    @ConstructorProperties("value")
    public NonZeroUint32Type(java.lang.Long _value) {
        if (_value != null) {
            check_valueRange(_value);
        }
    
    
        Objects.requireNonNull(_value, "Supplied value may not be null");
    
        this._value = _value;
    }
    
    /**
     * Creates a copy from Source Object.
     *
     * @param source Source object
     */
    public NonZeroUint32Type(NonZeroUint32Type source) {
        this._value = source._value;
    }

    public static NonZeroUint32Type getDefaultInstance(String defaultValue) {
        return new NonZeroUint32Type(java.lang.Long.valueOf(defaultValue));
    }

    public java.lang.Long getValue() {
        return _value;
    }


    @Override
    public int hashCode() {
        final int prime = 31;
        int result = 1;
        result = prime * result + Objects.hashCode(_value);
        return result;
    }

    @Override
    public boolean equals(java.lang.Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (getClass() != obj.getClass()) {
            return false;
        }
        NonZeroUint32Type other = (NonZeroUint32Type) obj;
        if (!Objects.equals(_value, other._value)) {
            return false;
        }
        return true;
    }

    @Override
    public java.lang.String toString() {
        java.lang.StringBuilder builder = new java.lang.StringBuilder(org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.distributed.datastore.provider.rev140612.NonZeroUint32Type.class.getSimpleName()).append(" [");
        boolean first = true;
    
        if (_value != null) {
            if (first) {
                first = false;
            } else {
                builder.append(", ");
            }
            builder.append("_value=");
            builder.append(_value);
        }
        return builder.append(']').toString();
    }
}

