package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.distributed.datastore.provider.rev140612;
import java.io.Serializable;
import java.beans.ConstructorProperties;
import java.util.Objects;

public class Percentage
 implements Serializable {
    private static final long serialVersionUID = 482899018947419815L;
    private final java.lang.Short _value;

    private static void check_valueRange(final short value) {
        if (value >= (short)0 && value <= (short)100) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0..100]].", value));
    }

    @ConstructorProperties("value")
    public Percentage(java.lang.Short _value) {
        if (_value != null) {
            check_valueRange(_value);
        }
    
    
        Objects.requireNonNull(_value, "Supplied value may not be null");
    
        this._value = _value;
    }
    
    /**
     * Creates a copy from Source Object.
     *
     * @param source Source object
     */
    public Percentage(Percentage source) {
        this._value = source._value;
    }

    public static Percentage getDefaultInstance(String defaultValue) {
        return new Percentage(java.lang.Short.valueOf(defaultValue));
    }

    public java.lang.Short getValue() {
        return _value;
    }


    @Override
    public int hashCode() {
        final int prime = 31;
        int result = 1;
        result = prime * result + Objects.hashCode(_value);
        return result;
    }

    @Override
    public boolean equals(java.lang.Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (getClass() != obj.getClass()) {
            return false;
        }
        Percentage other = (Percentage) obj;
        if (!Objects.equals(_value, other._value)) {
            return false;
        }
        return true;
    }

    @Override
    public java.lang.String toString() {
        java.lang.StringBuilder builder = new java.lang.StringBuilder(org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.distributed.datastore.provider.rev140612.Percentage.class.getSimpleName()).append(" [");
        boolean first = true;
    
        if (_value != null) {
            if (first) {
                first = false;
            } else {
                builder.append(", ");
            }
            builder.append("_value=");
            builder.append(_value);
        }
        return builder.append(']').toString();
    }
}

