package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.distributed.datastore.provider.rev140612.modules.module.configuration;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.distributed.datastore.provider.rev140612.modules.module.configuration.distributed.config.datastore.provider.ConfigSchemaService;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.distributed.datastore.provider.rev140612.modules.module.configuration.distributed.config.datastore.provider.ConfigProperties;
import java.util.HashMap;
import org.opendaylight.yangtools.concepts.Builder;
import java.util.Objects;
import java.util.Collections;
import java.util.Map;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.distributed.datastore.provider.rev140612.modules.module.configuration.distributed.config.datastore.provider.ConfigActorSystemProvider;

/**
 * Class that builds {@link org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.distributed.datastore.provider.rev140612.modules.module.configuration.DistributedConfigDatastoreProvider} instances.
 *
 * @see org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.distributed.datastore.provider.rev140612.modules.module.configuration.DistributedConfigDatastoreProvider
 *
 */
public class DistributedConfigDatastoreProviderBuilder implements Builder<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.distributed.datastore.provider.rev140612.modules.module.configuration.DistributedConfigDatastoreProvider> {

    private ConfigActorSystemProvider _configActorSystemProvider;
    private ConfigProperties _configProperties;
    private ConfigSchemaService _configSchemaService;

    Map<java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.distributed.datastore.provider.rev140612.modules.module.configuration.DistributedConfigDatastoreProvider>>, Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.distributed.datastore.provider.rev140612.modules.module.configuration.DistributedConfigDatastoreProvider>> augmentation = Collections.emptyMap();

    public DistributedConfigDatastoreProviderBuilder() {
    }

    public DistributedConfigDatastoreProviderBuilder(DistributedConfigDatastoreProvider base) {
        this._configActorSystemProvider = base.getConfigActorSystemProvider();
        this._configProperties = base.getConfigProperties();
        this._configSchemaService = base.getConfigSchemaService();
        if (base instanceof DistributedConfigDatastoreProviderImpl) {
            DistributedConfigDatastoreProviderImpl impl = (DistributedConfigDatastoreProviderImpl) base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder) {
            @SuppressWarnings("unchecked")
            AugmentationHolder<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.distributed.datastore.provider.rev140612.modules.module.configuration.DistributedConfigDatastoreProvider> casted =(AugmentationHolder<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.distributed.datastore.provider.rev140612.modules.module.configuration.DistributedConfigDatastoreProvider>) base;
            if (!casted.augmentations().isEmpty()) {
                this.augmentation = new HashMap<>(casted.augmentations());
            }
        }
    }


    public ConfigActorSystemProvider getConfigActorSystemProvider() {
        return _configActorSystemProvider;
    }
    
    public ConfigProperties getConfigProperties() {
        return _configProperties;
    }
    
    public ConfigSchemaService getConfigSchemaService() {
        return _configSchemaService;
    }
    
    @SuppressWarnings("unchecked")
    public <E extends Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.distributed.datastore.provider.rev140612.modules.module.configuration.DistributedConfigDatastoreProvider>> E getAugmentation(java.lang.Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E) augmentation.get(augmentationType);
    }

     
    public DistributedConfigDatastoreProviderBuilder setConfigActorSystemProvider(final ConfigActorSystemProvider value) {
        this._configActorSystemProvider = value;
        return this;
    }
    
     
    public DistributedConfigDatastoreProviderBuilder setConfigProperties(final ConfigProperties value) {
        this._configProperties = value;
        return this;
    }
    
     
    public DistributedConfigDatastoreProviderBuilder setConfigSchemaService(final ConfigSchemaService value) {
        this._configSchemaService = value;
        return this;
    }
    
    public DistributedConfigDatastoreProviderBuilder addAugmentation(java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.distributed.datastore.provider.rev140612.modules.module.configuration.DistributedConfigDatastoreProvider>> augmentationType, Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.distributed.datastore.provider.rev140612.modules.module.configuration.DistributedConfigDatastoreProvider> augmentationValue) {
        if (augmentationValue == null) {
            return removeAugmentation(augmentationType);
        }
    
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }
    
    public DistributedConfigDatastoreProviderBuilder removeAugmentation(java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.distributed.datastore.provider.rev140612.modules.module.configuration.DistributedConfigDatastoreProvider>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public DistributedConfigDatastoreProvider build() {
        return new DistributedConfigDatastoreProviderImpl(this);
    }

    private static final class DistributedConfigDatastoreProviderImpl implements DistributedConfigDatastoreProvider {

        @Override
        public java.lang.Class<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.distributed.datastore.provider.rev140612.modules.module.configuration.DistributedConfigDatastoreProvider> getImplementedInterface() {
            return org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.distributed.datastore.provider.rev140612.modules.module.configuration.DistributedConfigDatastoreProvider.class;
        }

        private final ConfigActorSystemProvider _configActorSystemProvider;
        private final ConfigProperties _configProperties;
        private final ConfigSchemaService _configSchemaService;

        private Map<java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.distributed.datastore.provider.rev140612.modules.module.configuration.DistributedConfigDatastoreProvider>>, Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.distributed.datastore.provider.rev140612.modules.module.configuration.DistributedConfigDatastoreProvider>> augmentation = Collections.emptyMap();

        private DistributedConfigDatastoreProviderImpl(DistributedConfigDatastoreProviderBuilder base) {
            this._configActorSystemProvider = base.getConfigActorSystemProvider();
            this._configProperties = base.getConfigProperties();
            this._configSchemaService = base.getConfigSchemaService();
            switch (base.augmentation.size()) {
            case 0:
                this.augmentation = Collections.emptyMap();
                break;
            case 1:
                final Map.Entry<java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.distributed.datastore.provider.rev140612.modules.module.configuration.DistributedConfigDatastoreProvider>>, Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.distributed.datastore.provider.rev140612.modules.module.configuration.DistributedConfigDatastoreProvider>> e = base.augmentation.entrySet().iterator().next();
                this.augmentation = Collections.<java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.distributed.datastore.provider.rev140612.modules.module.configuration.DistributedConfigDatastoreProvider>>, Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.distributed.datastore.provider.rev140612.modules.module.configuration.DistributedConfigDatastoreProvider>>singletonMap(e.getKey(), e.getValue());
                break;
            default :
                this.augmentation = new HashMap<>(base.augmentation);
            }
        }

        @Override
        public ConfigActorSystemProvider getConfigActorSystemProvider() {
            return _configActorSystemProvider;
        }
        
        @Override
        public ConfigProperties getConfigProperties() {
            return _configProperties;
        }
        
        @Override
        public ConfigSchemaService getConfigSchemaService() {
            return _configSchemaService;
        }
        
        @SuppressWarnings("unchecked")
        @Override
        public <E extends Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.distributed.datastore.provider.rev140612.modules.module.configuration.DistributedConfigDatastoreProvider>> E getAugmentation(java.lang.Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E) augmentation.get(augmentationType);
        }

        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int prime = 31;
            int result = 1;
            result = prime * result + Objects.hashCode(_configActorSystemProvider);
            result = prime * result + Objects.hashCode(_configProperties);
            result = prime * result + Objects.hashCode(_configSchemaService);
            result = prime * result + Objects.hashCode(augmentation);
        
            hash = result;
            hashValid = true;
            return result;
        }

        @Override
        public boolean equals(java.lang.Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.distributed.datastore.provider.rev140612.modules.module.configuration.DistributedConfigDatastoreProvider.class.equals(((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.distributed.datastore.provider.rev140612.modules.module.configuration.DistributedConfigDatastoreProvider other = (org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.distributed.datastore.provider.rev140612.modules.module.configuration.DistributedConfigDatastoreProvider)obj;
            if (!Objects.equals(_configActorSystemProvider, other.getConfigActorSystemProvider())) {
                return false;
            }
            if (!Objects.equals(_configProperties, other.getConfigProperties())) {
                return false;
            }
            if (!Objects.equals(_configSchemaService, other.getConfigSchemaService())) {
                return false;
            }
            if (getClass() == obj.getClass()) {
                // Simple case: we are comparing against self
                DistributedConfigDatastoreProviderImpl otherImpl = (DistributedConfigDatastoreProviderImpl) obj;
                if (!Objects.equals(augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                // Hard case: compare our augments with presence there...
                for (Map.Entry<java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.distributed.datastore.provider.rev140612.modules.module.configuration.DistributedConfigDatastoreProvider>>, Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.distributed.datastore.provider.rev140612.modules.module.configuration.DistributedConfigDatastoreProvider>> e : augmentation.entrySet()) {
                    if (!e.getValue().equals(other.getAugmentation(e.getKey()))) {
                        return false;
                    }
                }
                // .. and give the other one the chance to do the same
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        @Override
        public java.lang.String toString() {
            java.lang.String name = "DistributedConfigDatastoreProvider [";
            java.lang.StringBuilder builder = new java.lang.StringBuilder (name);
            if (_configActorSystemProvider != null) {
                builder.append("_configActorSystemProvider=");
                builder.append(_configActorSystemProvider);
                builder.append(", ");
            }
            if (_configProperties != null) {
                builder.append("_configProperties=");
                builder.append(_configProperties);
                builder.append(", ");
            }
            if (_configSchemaService != null) {
                builder.append("_configSchemaService=");
                builder.append(_configSchemaService);
            }
            final int builderLength = builder.length();
            final int builderAdditionalLength = builder.substring(name.length(), builderLength).length();
            if (builderAdditionalLength > 2 && !builder.substring(builderLength - 2, builderLength).equals(", ")) {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(augmentation.values());
            return builder.append(']').toString();
        }
    }

}
