package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.distributed.datastore.provider.rev140612.modules.module.configuration;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.distributed.datastore.provider.rev140612.modules.module.configuration.distributed.operational.datastore.provider.OperationalProperties;
import org.opendaylight.yangtools.yang.binding.DataObject;
import java.util.HashMap;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.distributed.datastore.provider.rev140612.modules.module.configuration.distributed.operational.datastore.provider.OperationalSchemaService;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.distributed.datastore.provider.rev140612.modules.module.configuration.distributed.operational.datastore.provider.OperationalActorSystemProvider;
import java.util.Collections;
import java.util.Map;

/**
 * Class that builds {@link org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.distributed.datastore.provider.rev140612.modules.module.configuration.DistributedOperationalDatastoreProvider} instances.
 *
 * @see org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.distributed.datastore.provider.rev140612.modules.module.configuration.DistributedOperationalDatastoreProvider
 *
 */
public class DistributedOperationalDatastoreProviderBuilder implements Builder<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.distributed.datastore.provider.rev140612.modules.module.configuration.DistributedOperationalDatastoreProvider> {

    private OperationalActorSystemProvider _operationalActorSystemProvider;
    private OperationalProperties _operationalProperties;
    private OperationalSchemaService _operationalSchemaService;

    Map<java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.distributed.datastore.provider.rev140612.modules.module.configuration.DistributedOperationalDatastoreProvider>>, Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.distributed.datastore.provider.rev140612.modules.module.configuration.DistributedOperationalDatastoreProvider>> augmentation = Collections.emptyMap();

    public DistributedOperationalDatastoreProviderBuilder() {
    }

    public DistributedOperationalDatastoreProviderBuilder(DistributedOperationalDatastoreProvider base) {
        this._operationalActorSystemProvider = base.getOperationalActorSystemProvider();
        this._operationalProperties = base.getOperationalProperties();
        this._operationalSchemaService = base.getOperationalSchemaService();
        if (base instanceof DistributedOperationalDatastoreProviderImpl) {
            DistributedOperationalDatastoreProviderImpl impl = (DistributedOperationalDatastoreProviderImpl) base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder) {
            @SuppressWarnings("unchecked")
            AugmentationHolder<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.distributed.datastore.provider.rev140612.modules.module.configuration.DistributedOperationalDatastoreProvider> casted =(AugmentationHolder<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.distributed.datastore.provider.rev140612.modules.module.configuration.DistributedOperationalDatastoreProvider>) base;
            if (!casted.augmentations().isEmpty()) {
                this.augmentation = new HashMap<>(casted.augmentations());
            }
        }
    }


    public OperationalActorSystemProvider getOperationalActorSystemProvider() {
        return _operationalActorSystemProvider;
    }
    
    public OperationalProperties getOperationalProperties() {
        return _operationalProperties;
    }
    
    public OperationalSchemaService getOperationalSchemaService() {
        return _operationalSchemaService;
    }
    
    @SuppressWarnings("unchecked")
    public <E extends Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.distributed.datastore.provider.rev140612.modules.module.configuration.DistributedOperationalDatastoreProvider>> E getAugmentation(java.lang.Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E) augmentation.get(augmentationType);
    }

     
    public DistributedOperationalDatastoreProviderBuilder setOperationalActorSystemProvider(final OperationalActorSystemProvider value) {
        this._operationalActorSystemProvider = value;
        return this;
    }
    
     
    public DistributedOperationalDatastoreProviderBuilder setOperationalProperties(final OperationalProperties value) {
        this._operationalProperties = value;
        return this;
    }
    
     
    public DistributedOperationalDatastoreProviderBuilder setOperationalSchemaService(final OperationalSchemaService value) {
        this._operationalSchemaService = value;
        return this;
    }
    
    public DistributedOperationalDatastoreProviderBuilder addAugmentation(java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.distributed.datastore.provider.rev140612.modules.module.configuration.DistributedOperationalDatastoreProvider>> augmentationType, Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.distributed.datastore.provider.rev140612.modules.module.configuration.DistributedOperationalDatastoreProvider> augmentationValue) {
        if (augmentationValue == null) {
            return removeAugmentation(augmentationType);
        }
    
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }
    
    public DistributedOperationalDatastoreProviderBuilder removeAugmentation(java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.distributed.datastore.provider.rev140612.modules.module.configuration.DistributedOperationalDatastoreProvider>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public DistributedOperationalDatastoreProvider build() {
        return new DistributedOperationalDatastoreProviderImpl(this);
    }

    private static final class DistributedOperationalDatastoreProviderImpl implements DistributedOperationalDatastoreProvider {

        @Override
        public java.lang.Class<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.distributed.datastore.provider.rev140612.modules.module.configuration.DistributedOperationalDatastoreProvider> getImplementedInterface() {
            return org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.distributed.datastore.provider.rev140612.modules.module.configuration.DistributedOperationalDatastoreProvider.class;
        }

        private final OperationalActorSystemProvider _operationalActorSystemProvider;
        private final OperationalProperties _operationalProperties;
        private final OperationalSchemaService _operationalSchemaService;

        private Map<java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.distributed.datastore.provider.rev140612.modules.module.configuration.DistributedOperationalDatastoreProvider>>, Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.distributed.datastore.provider.rev140612.modules.module.configuration.DistributedOperationalDatastoreProvider>> augmentation = Collections.emptyMap();

        private DistributedOperationalDatastoreProviderImpl(DistributedOperationalDatastoreProviderBuilder base) {
            this._operationalActorSystemProvider = base.getOperationalActorSystemProvider();
            this._operationalProperties = base.getOperationalProperties();
            this._operationalSchemaService = base.getOperationalSchemaService();
            switch (base.augmentation.size()) {
            case 0:
                this.augmentation = Collections.emptyMap();
                break;
            case 1:
                final Map.Entry<java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.distributed.datastore.provider.rev140612.modules.module.configuration.DistributedOperationalDatastoreProvider>>, Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.distributed.datastore.provider.rev140612.modules.module.configuration.DistributedOperationalDatastoreProvider>> e = base.augmentation.entrySet().iterator().next();
                this.augmentation = Collections.<java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.distributed.datastore.provider.rev140612.modules.module.configuration.DistributedOperationalDatastoreProvider>>, Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.distributed.datastore.provider.rev140612.modules.module.configuration.DistributedOperationalDatastoreProvider>>singletonMap(e.getKey(), e.getValue());
                break;
            default :
                this.augmentation = new HashMap<>(base.augmentation);
            }
        }

        @Override
        public OperationalActorSystemProvider getOperationalActorSystemProvider() {
            return _operationalActorSystemProvider;
        }
        
        @Override
        public OperationalProperties getOperationalProperties() {
            return _operationalProperties;
        }
        
        @Override
        public OperationalSchemaService getOperationalSchemaService() {
            return _operationalSchemaService;
        }
        
        @SuppressWarnings("unchecked")
        @Override
        public <E extends Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.distributed.datastore.provider.rev140612.modules.module.configuration.DistributedOperationalDatastoreProvider>> E getAugmentation(java.lang.Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E) augmentation.get(augmentationType);
        }

        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int prime = 31;
            int result = 1;
            result = prime * result + Objects.hashCode(_operationalActorSystemProvider);
            result = prime * result + Objects.hashCode(_operationalProperties);
            result = prime * result + Objects.hashCode(_operationalSchemaService);
            result = prime * result + Objects.hashCode(augmentation);
        
            hash = result;
            hashValid = true;
            return result;
        }

        @Override
        public boolean equals(java.lang.Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.distributed.datastore.provider.rev140612.modules.module.configuration.DistributedOperationalDatastoreProvider.class.equals(((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.distributed.datastore.provider.rev140612.modules.module.configuration.DistributedOperationalDatastoreProvider other = (org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.distributed.datastore.provider.rev140612.modules.module.configuration.DistributedOperationalDatastoreProvider)obj;
            if (!Objects.equals(_operationalActorSystemProvider, other.getOperationalActorSystemProvider())) {
                return false;
            }
            if (!Objects.equals(_operationalProperties, other.getOperationalProperties())) {
                return false;
            }
            if (!Objects.equals(_operationalSchemaService, other.getOperationalSchemaService())) {
                return false;
            }
            if (getClass() == obj.getClass()) {
                // Simple case: we are comparing against self
                DistributedOperationalDatastoreProviderImpl otherImpl = (DistributedOperationalDatastoreProviderImpl) obj;
                if (!Objects.equals(augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                // Hard case: compare our augments with presence there...
                for (Map.Entry<java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.distributed.datastore.provider.rev140612.modules.module.configuration.DistributedOperationalDatastoreProvider>>, Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.distributed.datastore.provider.rev140612.modules.module.configuration.DistributedOperationalDatastoreProvider>> e : augmentation.entrySet()) {
                    if (!e.getValue().equals(other.getAugmentation(e.getKey()))) {
                        return false;
                    }
                }
                // .. and give the other one the chance to do the same
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        @Override
        public java.lang.String toString() {
            java.lang.String name = "DistributedOperationalDatastoreProvider [";
            java.lang.StringBuilder builder = new java.lang.StringBuilder (name);
            if (_operationalActorSystemProvider != null) {
                builder.append("_operationalActorSystemProvider=");
                builder.append(_operationalActorSystemProvider);
                builder.append(", ");
            }
            if (_operationalProperties != null) {
                builder.append("_operationalProperties=");
                builder.append(_operationalProperties);
                builder.append(", ");
            }
            if (_operationalSchemaService != null) {
                builder.append("_operationalSchemaService=");
                builder.append(_operationalSchemaService);
            }
            final int builderLength = builder.length();
            final int builderAdditionalLength = builder.substring(name.length(), builderLength).length();
            if (builderAdditionalLength > 2 && !builder.substring(builderLength - 2, builderLength).equals(", ")) {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(augmentation.values());
            return builder.append(']').toString();
        }
    }

}
