package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.distributed.datastore.provider.rev140612.modules.module.configuration.distributed.config.datastore.provider;
import org.opendaylight.yangtools.yang.binding.ChildOf;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.distributed.datastore.provider.rev140612.DataStoreProperties;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.rev130405.modules.Module;
import org.opendaylight.yangtools.yang.binding.Augmentable;

/**
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>distributed-datastore-provider</b>
 * <pre>
 * container config-properties {
 *     leaf max-shard-data-change-executor-queue-size {
 *         type max-shard-data-change-executor-queue-size;
 *     }
 *     leaf max-shard-data-change-executor-pool-size {
 *         type max-shard-data-change-executor-pool-size;
 *     }
 *     leaf max-shard-data-change-listener-queue-size {
 *         type max-shard-data-change-listener-queue-size;
 *     }
 *     leaf max-shard-data-store-executor-queue-size {
 *         type max-shard-data-store-executor-queue-size;
 *     }
 *     leaf shard-transaction-idle-timeout-in-minutes {
 *         type shard-transaction-idle-timeout-in-minutes;
 *     }
 *     leaf shard-snapshot-batch-count {
 *         type shard-snapshot-batch-count;
 *     }
 *     leaf shard-snapshot-data-threshold-percentage {
 *         type shard-snapshot-data-threshold-percentage;
 *     }
 *     leaf shard-heartbeat-interval-in-millis {
 *         type shard-heartbeat-interval-in-millis;
 *     }
 *     leaf shard-election-timeout-factor {
 *         type shard-election-timeout-factor;
 *     }
 *     leaf operation-timeout-in-seconds {
 *         type operation-timeout-in-seconds;
 *     }
 *     leaf shard-journal-recovery-log-batch-size {
 *         type shard-journal-recovery-log-batch-size;
 *     }
 *     leaf shard-transaction-commit-timeout-in-seconds {
 *         type shard-transaction-commit-timeout-in-seconds;
 *     }
 *     leaf shard-transaction-commit-queue-capacity {
 *         type shard-transaction-commit-queue-capacity;
 *     }
 *     leaf shard-commit-queue-expiry-timeout-in-seconds {
 *         type shard-commit-queue-expiry-timeout-in-seconds;
 *     }
 *     leaf shard-initialization-timeout-in-seconds {
 *         type shard-initialization-timeout-in-seconds;
 *     }
 *     leaf shard-leader-election-timeout-in-seconds {
 *         type shard-leader-election-timeout-in-seconds;
 *     }
 *     leaf shard-batched-modification-count {
 *         type shard-batched-modification-count;
 *     }
 *     leaf enable-metric-capture {
 *         type enable-metric-capture;
 *     }
 *     leaf bounded-mailbox-capacity {
 *         type bounded-mailbox-capacity;
 *     }
 *     leaf persistent {
 *         type persistent;
 *     }
 *     leaf shard-isolated-leader-check-interval-in-millis {
 *         type shard-isolated-leader-check-interval-in-millis;
 *     }
 *     leaf transaction-creation-initial-rate-limit {
 *         type transaction-creation-initial-rate-limit;
 *     }
 *     leaf transaction-debug-context-enabled {
 *         type transaction-debug-context-enabled;
 *     }
 *     leaf custom-raft-policy-implementation {
 *         type custom-raft-policy-implementation;
 *     }
 *     leaf shard-snapshot-chunk-size {
 *         type shard-snapshot-chunk-size;
 *         status DEPRECATED;
 *     }
 *     leaf maximum-message-slice-size {
 *         type maximum-message-slice-size;
 *     }
 *     leaf use-tell-based-protocol {
 *         type use-tell-based-protocol;
 *     }
 *     leaf file-backed-streaming-threshold-in-megabytes {
 *         type file-backed-streaming-threshold-in-megabytes;
 *     }
 *     leaf sync-index-threshold {
 *         type sync-index-threshold;
 *     }
 *     leaf backend-aliveness-timer-interval-in-seconds {
 *         type backend-aliveness-timer-interval-in-seconds;
 *     }
 *     leaf frontend-request-timeout-in-seconds {
 *         type frontend-request-timeout-in-seconds;
 *     }
 *     leaf frontend-no-progress-timeout-in-seconds {
 *         type frontend-no-progress-timeout-in-seconds;
 *     }
 *     uses data-store-properties;
 * }
 * </pre>The schema path to identify an instance is
 * <i>distributed-datastore-provider/modules/module/configuration/(urn:opendaylight:params:xml:ns:yang:controller:config:distributed-datastore-provider?revision=2014-06-12)distributed-config-datastore-provider/config-properties</i>
 *
 * <p>To create instances of this class use {@link ConfigPropertiesBuilder}.
 * @see ConfigPropertiesBuilder
 *
 */
public interface ConfigProperties
    extends
    ChildOf<Module>,
    Augmentable<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.distributed.datastore.provider.rev140612.modules.module.configuration.distributed.config.datastore.provider.ConfigProperties>,
    DataStoreProperties
{



    public static final QName QNAME = org.opendaylight.yangtools.yang.common.QName.create("urn:opendaylight:params:xml:ns:yang:controller:config:distributed-datastore-provider",
        "2014-06-12", "config-properties").intern();


}

