package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.distributed.datastore.provider.rev140612.modules.module.configuration.distributed.operational.datastore.provider;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.distributed.datastore.provider.rev140612.OperationTimeoutType;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.distributed.datastore.provider.rev140612.Percentage;
import java.util.HashMap;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.distributed.datastore.provider.rev140612.NonZeroUint32Type;
import java.util.Objects;
import java.util.Collections;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.distributed.datastore.provider.rev140612.HeartbeatIntervalType;
import java.util.Map;

/**
 * Class that builds {@link org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.distributed.datastore.provider.rev140612.modules.module.configuration.distributed.operational.datastore.provider.OperationalProperties} instances.
 *
 * @see org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.distributed.datastore.provider.rev140612.modules.module.configuration.distributed.operational.datastore.provider.OperationalProperties
 *
 */
public class OperationalPropertiesBuilder implements Builder<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.distributed.datastore.provider.rev140612.modules.module.configuration.distributed.operational.datastore.provider.OperationalProperties> {

    private NonZeroUint32Type _backendAlivenessTimerIntervalInSeconds;
    private NonZeroUint32Type _boundedMailboxCapacity;
    private java.lang.String _customRaftPolicyImplementation;
    private NonZeroUint32Type _fileBackedStreamingThresholdInMegabytes;
    private NonZeroUint32Type _frontendNoProgressTimeoutInSeconds;
    private NonZeroUint32Type _frontendRequestTimeoutInSeconds;
    private NonZeroUint32Type _maxShardDataChangeExecutorPoolSize;
    private NonZeroUint32Type _maxShardDataChangeExecutorQueueSize;
    private NonZeroUint32Type _maxShardDataChangeListenerQueueSize;
    private NonZeroUint32Type _maxShardDataStoreExecutorQueueSize;
    private NonZeroUint32Type _maximumMessageSliceSize;
    private OperationTimeoutType _operationTimeoutInSeconds;
    private NonZeroUint32Type _shardBatchedModificationCount;
    private NonZeroUint32Type _shardCommitQueueExpiryTimeoutInSeconds;
    private NonZeroUint32Type _shardElectionTimeoutFactor;
    private HeartbeatIntervalType _shardHeartbeatIntervalInMillis;
    private NonZeroUint32Type _shardInitializationTimeoutInSeconds;
    private HeartbeatIntervalType _shardIsolatedLeaderCheckIntervalInMillis;
    private NonZeroUint32Type _shardJournalRecoveryLogBatchSize;
    private NonZeroUint32Type _shardLeaderElectionTimeoutInSeconds;
    private NonZeroUint32Type _shardSnapshotBatchCount;
    private NonZeroUint32Type _shardSnapshotChunkSize;
    private Percentage _shardSnapshotDataThresholdPercentage;
    private NonZeroUint32Type _shardTransactionCommitQueueCapacity;
    private NonZeroUint32Type _shardTransactionCommitTimeoutInSeconds;
    private NonZeroUint32Type _shardTransactionIdleTimeoutInMinutes;
    private NonZeroUint32Type _syncIndexThreshold;
    private NonZeroUint32Type _transactionCreationInitialRateLimit;
    private java.lang.Boolean _enableMetricCapture;
    private java.lang.Boolean _persistent;
    private java.lang.Boolean _transactionDebugContextEnabled;
    private java.lang.Boolean _useTellBasedProtocol;

    Map<java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.distributed.datastore.provider.rev140612.modules.module.configuration.distributed.operational.datastore.provider.OperationalProperties>>, Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.distributed.datastore.provider.rev140612.modules.module.configuration.distributed.operational.datastore.provider.OperationalProperties>> augmentation = Collections.emptyMap();

    public OperationalPropertiesBuilder() {
    }
    public OperationalPropertiesBuilder(org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.distributed.datastore.provider.rev140612.DataStoreProperties arg) {
        this._maxShardDataChangeExecutorQueueSize = arg.getMaxShardDataChangeExecutorQueueSize();
        this._maxShardDataChangeExecutorPoolSize = arg.getMaxShardDataChangeExecutorPoolSize();
        this._maxShardDataChangeListenerQueueSize = arg.getMaxShardDataChangeListenerQueueSize();
        this._maxShardDataStoreExecutorQueueSize = arg.getMaxShardDataStoreExecutorQueueSize();
        this._shardTransactionIdleTimeoutInMinutes = arg.getShardTransactionIdleTimeoutInMinutes();
        this._shardSnapshotBatchCount = arg.getShardSnapshotBatchCount();
        this._shardSnapshotDataThresholdPercentage = arg.getShardSnapshotDataThresholdPercentage();
        this._shardHeartbeatIntervalInMillis = arg.getShardHeartbeatIntervalInMillis();
        this._shardElectionTimeoutFactor = arg.getShardElectionTimeoutFactor();
        this._operationTimeoutInSeconds = arg.getOperationTimeoutInSeconds();
        this._shardJournalRecoveryLogBatchSize = arg.getShardJournalRecoveryLogBatchSize();
        this._shardTransactionCommitTimeoutInSeconds = arg.getShardTransactionCommitTimeoutInSeconds();
        this._shardTransactionCommitQueueCapacity = arg.getShardTransactionCommitQueueCapacity();
        this._shardCommitQueueExpiryTimeoutInSeconds = arg.getShardCommitQueueExpiryTimeoutInSeconds();
        this._shardInitializationTimeoutInSeconds = arg.getShardInitializationTimeoutInSeconds();
        this._shardLeaderElectionTimeoutInSeconds = arg.getShardLeaderElectionTimeoutInSeconds();
        this._shardBatchedModificationCount = arg.getShardBatchedModificationCount();
        this._enableMetricCapture = arg.isEnableMetricCapture();
        this._boundedMailboxCapacity = arg.getBoundedMailboxCapacity();
        this._persistent = arg.isPersistent();
        this._shardIsolatedLeaderCheckIntervalInMillis = arg.getShardIsolatedLeaderCheckIntervalInMillis();
        this._transactionCreationInitialRateLimit = arg.getTransactionCreationInitialRateLimit();
        this._transactionDebugContextEnabled = arg.isTransactionDebugContextEnabled();
        this._customRaftPolicyImplementation = arg.getCustomRaftPolicyImplementation();
        this._shardSnapshotChunkSize = arg.getShardSnapshotChunkSize();
        this._maximumMessageSliceSize = arg.getMaximumMessageSliceSize();
        this._useTellBasedProtocol = arg.isUseTellBasedProtocol();
        this._fileBackedStreamingThresholdInMegabytes = arg.getFileBackedStreamingThresholdInMegabytes();
        this._syncIndexThreshold = arg.getSyncIndexThreshold();
        this._backendAlivenessTimerIntervalInSeconds = arg.getBackendAlivenessTimerIntervalInSeconds();
        this._frontendRequestTimeoutInSeconds = arg.getFrontendRequestTimeoutInSeconds();
        this._frontendNoProgressTimeoutInSeconds = arg.getFrontendNoProgressTimeoutInSeconds();
    }

    public OperationalPropertiesBuilder(OperationalProperties base) {
        this._backendAlivenessTimerIntervalInSeconds = base.getBackendAlivenessTimerIntervalInSeconds();
        this._boundedMailboxCapacity = base.getBoundedMailboxCapacity();
        this._customRaftPolicyImplementation = base.getCustomRaftPolicyImplementation();
        this._fileBackedStreamingThresholdInMegabytes = base.getFileBackedStreamingThresholdInMegabytes();
        this._frontendNoProgressTimeoutInSeconds = base.getFrontendNoProgressTimeoutInSeconds();
        this._frontendRequestTimeoutInSeconds = base.getFrontendRequestTimeoutInSeconds();
        this._maxShardDataChangeExecutorPoolSize = base.getMaxShardDataChangeExecutorPoolSize();
        this._maxShardDataChangeExecutorQueueSize = base.getMaxShardDataChangeExecutorQueueSize();
        this._maxShardDataChangeListenerQueueSize = base.getMaxShardDataChangeListenerQueueSize();
        this._maxShardDataStoreExecutorQueueSize = base.getMaxShardDataStoreExecutorQueueSize();
        this._maximumMessageSliceSize = base.getMaximumMessageSliceSize();
        this._operationTimeoutInSeconds = base.getOperationTimeoutInSeconds();
        this._shardBatchedModificationCount = base.getShardBatchedModificationCount();
        this._shardCommitQueueExpiryTimeoutInSeconds = base.getShardCommitQueueExpiryTimeoutInSeconds();
        this._shardElectionTimeoutFactor = base.getShardElectionTimeoutFactor();
        this._shardHeartbeatIntervalInMillis = base.getShardHeartbeatIntervalInMillis();
        this._shardInitializationTimeoutInSeconds = base.getShardInitializationTimeoutInSeconds();
        this._shardIsolatedLeaderCheckIntervalInMillis = base.getShardIsolatedLeaderCheckIntervalInMillis();
        this._shardJournalRecoveryLogBatchSize = base.getShardJournalRecoveryLogBatchSize();
        this._shardLeaderElectionTimeoutInSeconds = base.getShardLeaderElectionTimeoutInSeconds();
        this._shardSnapshotBatchCount = base.getShardSnapshotBatchCount();
        this._shardSnapshotChunkSize = base.getShardSnapshotChunkSize();
        this._shardSnapshotDataThresholdPercentage = base.getShardSnapshotDataThresholdPercentage();
        this._shardTransactionCommitQueueCapacity = base.getShardTransactionCommitQueueCapacity();
        this._shardTransactionCommitTimeoutInSeconds = base.getShardTransactionCommitTimeoutInSeconds();
        this._shardTransactionIdleTimeoutInMinutes = base.getShardTransactionIdleTimeoutInMinutes();
        this._syncIndexThreshold = base.getSyncIndexThreshold();
        this._transactionCreationInitialRateLimit = base.getTransactionCreationInitialRateLimit();
        this._enableMetricCapture = base.isEnableMetricCapture();
        this._persistent = base.isPersistent();
        this._transactionDebugContextEnabled = base.isTransactionDebugContextEnabled();
        this._useTellBasedProtocol = base.isUseTellBasedProtocol();
        if (base instanceof OperationalPropertiesImpl) {
            OperationalPropertiesImpl impl = (OperationalPropertiesImpl) base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder) {
            @SuppressWarnings("unchecked")
            AugmentationHolder<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.distributed.datastore.provider.rev140612.modules.module.configuration.distributed.operational.datastore.provider.OperationalProperties> casted =(AugmentationHolder<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.distributed.datastore.provider.rev140612.modules.module.configuration.distributed.operational.datastore.provider.OperationalProperties>) base;
            if (!casted.augmentations().isEmpty()) {
                this.augmentation = new HashMap<>(casted.augmentations());
            }
        }
    }

    /**
     *Set fields from given grouping argument. Valid argument is instance of one of following types:
     * <ul>
     * <li>org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.distributed.datastore.provider.rev140612.DataStoreProperties</li>
     * </ul>
     *
     * @param arg grouping object
     * @throws IllegalArgumentException if given argument is none of valid types
    */
    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.distributed.datastore.provider.rev140612.DataStoreProperties) {
            this._maxShardDataChangeExecutorQueueSize = ((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.distributed.datastore.provider.rev140612.DataStoreProperties)arg).getMaxShardDataChangeExecutorQueueSize();
            this._maxShardDataChangeExecutorPoolSize = ((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.distributed.datastore.provider.rev140612.DataStoreProperties)arg).getMaxShardDataChangeExecutorPoolSize();
            this._maxShardDataChangeListenerQueueSize = ((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.distributed.datastore.provider.rev140612.DataStoreProperties)arg).getMaxShardDataChangeListenerQueueSize();
            this._maxShardDataStoreExecutorQueueSize = ((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.distributed.datastore.provider.rev140612.DataStoreProperties)arg).getMaxShardDataStoreExecutorQueueSize();
            this._shardTransactionIdleTimeoutInMinutes = ((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.distributed.datastore.provider.rev140612.DataStoreProperties)arg).getShardTransactionIdleTimeoutInMinutes();
            this._shardSnapshotBatchCount = ((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.distributed.datastore.provider.rev140612.DataStoreProperties)arg).getShardSnapshotBatchCount();
            this._shardSnapshotDataThresholdPercentage = ((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.distributed.datastore.provider.rev140612.DataStoreProperties)arg).getShardSnapshotDataThresholdPercentage();
            this._shardHeartbeatIntervalInMillis = ((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.distributed.datastore.provider.rev140612.DataStoreProperties)arg).getShardHeartbeatIntervalInMillis();
            this._shardElectionTimeoutFactor = ((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.distributed.datastore.provider.rev140612.DataStoreProperties)arg).getShardElectionTimeoutFactor();
            this._operationTimeoutInSeconds = ((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.distributed.datastore.provider.rev140612.DataStoreProperties)arg).getOperationTimeoutInSeconds();
            this._shardJournalRecoveryLogBatchSize = ((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.distributed.datastore.provider.rev140612.DataStoreProperties)arg).getShardJournalRecoveryLogBatchSize();
            this._shardTransactionCommitTimeoutInSeconds = ((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.distributed.datastore.provider.rev140612.DataStoreProperties)arg).getShardTransactionCommitTimeoutInSeconds();
            this._shardTransactionCommitQueueCapacity = ((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.distributed.datastore.provider.rev140612.DataStoreProperties)arg).getShardTransactionCommitQueueCapacity();
            this._shardCommitQueueExpiryTimeoutInSeconds = ((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.distributed.datastore.provider.rev140612.DataStoreProperties)arg).getShardCommitQueueExpiryTimeoutInSeconds();
            this._shardInitializationTimeoutInSeconds = ((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.distributed.datastore.provider.rev140612.DataStoreProperties)arg).getShardInitializationTimeoutInSeconds();
            this._shardLeaderElectionTimeoutInSeconds = ((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.distributed.datastore.provider.rev140612.DataStoreProperties)arg).getShardLeaderElectionTimeoutInSeconds();
            this._shardBatchedModificationCount = ((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.distributed.datastore.provider.rev140612.DataStoreProperties)arg).getShardBatchedModificationCount();
            this._enableMetricCapture = ((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.distributed.datastore.provider.rev140612.DataStoreProperties)arg).isEnableMetricCapture();
            this._boundedMailboxCapacity = ((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.distributed.datastore.provider.rev140612.DataStoreProperties)arg).getBoundedMailboxCapacity();
            this._persistent = ((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.distributed.datastore.provider.rev140612.DataStoreProperties)arg).isPersistent();
            this._shardIsolatedLeaderCheckIntervalInMillis = ((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.distributed.datastore.provider.rev140612.DataStoreProperties)arg).getShardIsolatedLeaderCheckIntervalInMillis();
            this._transactionCreationInitialRateLimit = ((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.distributed.datastore.provider.rev140612.DataStoreProperties)arg).getTransactionCreationInitialRateLimit();
            this._transactionDebugContextEnabled = ((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.distributed.datastore.provider.rev140612.DataStoreProperties)arg).isTransactionDebugContextEnabled();
            this._customRaftPolicyImplementation = ((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.distributed.datastore.provider.rev140612.DataStoreProperties)arg).getCustomRaftPolicyImplementation();
            this._shardSnapshotChunkSize = ((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.distributed.datastore.provider.rev140612.DataStoreProperties)arg).getShardSnapshotChunkSize();
            this._maximumMessageSliceSize = ((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.distributed.datastore.provider.rev140612.DataStoreProperties)arg).getMaximumMessageSliceSize();
            this._useTellBasedProtocol = ((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.distributed.datastore.provider.rev140612.DataStoreProperties)arg).isUseTellBasedProtocol();
            this._fileBackedStreamingThresholdInMegabytes = ((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.distributed.datastore.provider.rev140612.DataStoreProperties)arg).getFileBackedStreamingThresholdInMegabytes();
            this._syncIndexThreshold = ((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.distributed.datastore.provider.rev140612.DataStoreProperties)arg).getSyncIndexThreshold();
            this._backendAlivenessTimerIntervalInSeconds = ((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.distributed.datastore.provider.rev140612.DataStoreProperties)arg).getBackendAlivenessTimerIntervalInSeconds();
            this._frontendRequestTimeoutInSeconds = ((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.distributed.datastore.provider.rev140612.DataStoreProperties)arg).getFrontendRequestTimeoutInSeconds();
            this._frontendNoProgressTimeoutInSeconds = ((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.distributed.datastore.provider.rev140612.DataStoreProperties)arg).getFrontendNoProgressTimeoutInSeconds();
            isValidArg = true;
        }
        if (!isValidArg) {
            throw new IllegalArgumentException(
              "expected one of: [org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.distributed.datastore.provider.rev140612.DataStoreProperties] \n" +
              "but was: " + arg
            );
        }
    }

    public NonZeroUint32Type getBackendAlivenessTimerIntervalInSeconds() {
        return _backendAlivenessTimerIntervalInSeconds;
    }
    
    public NonZeroUint32Type getBoundedMailboxCapacity() {
        return _boundedMailboxCapacity;
    }
    
    public java.lang.String getCustomRaftPolicyImplementation() {
        return _customRaftPolicyImplementation;
    }
    
    public NonZeroUint32Type getFileBackedStreamingThresholdInMegabytes() {
        return _fileBackedStreamingThresholdInMegabytes;
    }
    
    public NonZeroUint32Type getFrontendNoProgressTimeoutInSeconds() {
        return _frontendNoProgressTimeoutInSeconds;
    }
    
    public NonZeroUint32Type getFrontendRequestTimeoutInSeconds() {
        return _frontendRequestTimeoutInSeconds;
    }
    
    public NonZeroUint32Type getMaxShardDataChangeExecutorPoolSize() {
        return _maxShardDataChangeExecutorPoolSize;
    }
    
    public NonZeroUint32Type getMaxShardDataChangeExecutorQueueSize() {
        return _maxShardDataChangeExecutorQueueSize;
    }
    
    public NonZeroUint32Type getMaxShardDataChangeListenerQueueSize() {
        return _maxShardDataChangeListenerQueueSize;
    }
    
    public NonZeroUint32Type getMaxShardDataStoreExecutorQueueSize() {
        return _maxShardDataStoreExecutorQueueSize;
    }
    
    public NonZeroUint32Type getMaximumMessageSliceSize() {
        return _maximumMessageSliceSize;
    }
    
    public OperationTimeoutType getOperationTimeoutInSeconds() {
        return _operationTimeoutInSeconds;
    }
    
    public NonZeroUint32Type getShardBatchedModificationCount() {
        return _shardBatchedModificationCount;
    }
    
    public NonZeroUint32Type getShardCommitQueueExpiryTimeoutInSeconds() {
        return _shardCommitQueueExpiryTimeoutInSeconds;
    }
    
    public NonZeroUint32Type getShardElectionTimeoutFactor() {
        return _shardElectionTimeoutFactor;
    }
    
    public HeartbeatIntervalType getShardHeartbeatIntervalInMillis() {
        return _shardHeartbeatIntervalInMillis;
    }
    
    public NonZeroUint32Type getShardInitializationTimeoutInSeconds() {
        return _shardInitializationTimeoutInSeconds;
    }
    
    public HeartbeatIntervalType getShardIsolatedLeaderCheckIntervalInMillis() {
        return _shardIsolatedLeaderCheckIntervalInMillis;
    }
    
    public NonZeroUint32Type getShardJournalRecoveryLogBatchSize() {
        return _shardJournalRecoveryLogBatchSize;
    }
    
    public NonZeroUint32Type getShardLeaderElectionTimeoutInSeconds() {
        return _shardLeaderElectionTimeoutInSeconds;
    }
    
    public NonZeroUint32Type getShardSnapshotBatchCount() {
        return _shardSnapshotBatchCount;
    }
    
    public NonZeroUint32Type getShardSnapshotChunkSize() {
        return _shardSnapshotChunkSize;
    }
    
    public Percentage getShardSnapshotDataThresholdPercentage() {
        return _shardSnapshotDataThresholdPercentage;
    }
    
    public NonZeroUint32Type getShardTransactionCommitQueueCapacity() {
        return _shardTransactionCommitQueueCapacity;
    }
    
    public NonZeroUint32Type getShardTransactionCommitTimeoutInSeconds() {
        return _shardTransactionCommitTimeoutInSeconds;
    }
    
    public NonZeroUint32Type getShardTransactionIdleTimeoutInMinutes() {
        return _shardTransactionIdleTimeoutInMinutes;
    }
    
    public NonZeroUint32Type getSyncIndexThreshold() {
        return _syncIndexThreshold;
    }
    
    public NonZeroUint32Type getTransactionCreationInitialRateLimit() {
        return _transactionCreationInitialRateLimit;
    }
    
    public java.lang.Boolean isEnableMetricCapture() {
        return _enableMetricCapture;
    }
    
    public java.lang.Boolean isPersistent() {
        return _persistent;
    }
    
    public java.lang.Boolean isTransactionDebugContextEnabled() {
        return _transactionDebugContextEnabled;
    }
    
    public java.lang.Boolean isUseTellBasedProtocol() {
        return _useTellBasedProtocol;
    }
    
    @SuppressWarnings("unchecked")
    public <E extends Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.distributed.datastore.provider.rev140612.modules.module.configuration.distributed.operational.datastore.provider.OperationalProperties>> E getAugmentation(java.lang.Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E) augmentation.get(augmentationType);
    }

     
    public OperationalPropertiesBuilder setBackendAlivenessTimerIntervalInSeconds(final NonZeroUint32Type value) {
        this._backendAlivenessTimerIntervalInSeconds = value;
        return this;
    }
    
     
    public OperationalPropertiesBuilder setBoundedMailboxCapacity(final NonZeroUint32Type value) {
        this._boundedMailboxCapacity = value;
        return this;
    }
    
     
    public OperationalPropertiesBuilder setCustomRaftPolicyImplementation(final java.lang.String value) {
        this._customRaftPolicyImplementation = value;
        return this;
    }
    
     
    public OperationalPropertiesBuilder setFileBackedStreamingThresholdInMegabytes(final NonZeroUint32Type value) {
        this._fileBackedStreamingThresholdInMegabytes = value;
        return this;
    }
    
     
    public OperationalPropertiesBuilder setFrontendNoProgressTimeoutInSeconds(final NonZeroUint32Type value) {
        this._frontendNoProgressTimeoutInSeconds = value;
        return this;
    }
    
     
    public OperationalPropertiesBuilder setFrontendRequestTimeoutInSeconds(final NonZeroUint32Type value) {
        this._frontendRequestTimeoutInSeconds = value;
        return this;
    }
    
     
    public OperationalPropertiesBuilder setMaxShardDataChangeExecutorPoolSize(final NonZeroUint32Type value) {
        this._maxShardDataChangeExecutorPoolSize = value;
        return this;
    }
    
     
    public OperationalPropertiesBuilder setMaxShardDataChangeExecutorQueueSize(final NonZeroUint32Type value) {
        this._maxShardDataChangeExecutorQueueSize = value;
        return this;
    }
    
     
    public OperationalPropertiesBuilder setMaxShardDataChangeListenerQueueSize(final NonZeroUint32Type value) {
        this._maxShardDataChangeListenerQueueSize = value;
        return this;
    }
    
     
    public OperationalPropertiesBuilder setMaxShardDataStoreExecutorQueueSize(final NonZeroUint32Type value) {
        this._maxShardDataStoreExecutorQueueSize = value;
        return this;
    }
    
     
    public OperationalPropertiesBuilder setMaximumMessageSliceSize(final NonZeroUint32Type value) {
        this._maximumMessageSliceSize = value;
        return this;
    }
    
     
    public OperationalPropertiesBuilder setOperationTimeoutInSeconds(final OperationTimeoutType value) {
        this._operationTimeoutInSeconds = value;
        return this;
    }
    
     
    public OperationalPropertiesBuilder setShardBatchedModificationCount(final NonZeroUint32Type value) {
        this._shardBatchedModificationCount = value;
        return this;
    }
    
     
    public OperationalPropertiesBuilder setShardCommitQueueExpiryTimeoutInSeconds(final NonZeroUint32Type value) {
        this._shardCommitQueueExpiryTimeoutInSeconds = value;
        return this;
    }
    
     
    public OperationalPropertiesBuilder setShardElectionTimeoutFactor(final NonZeroUint32Type value) {
        this._shardElectionTimeoutFactor = value;
        return this;
    }
    
     
    public OperationalPropertiesBuilder setShardHeartbeatIntervalInMillis(final HeartbeatIntervalType value) {
        this._shardHeartbeatIntervalInMillis = value;
        return this;
    }
    
     
    public OperationalPropertiesBuilder setShardInitializationTimeoutInSeconds(final NonZeroUint32Type value) {
        this._shardInitializationTimeoutInSeconds = value;
        return this;
    }
    
     
    public OperationalPropertiesBuilder setShardIsolatedLeaderCheckIntervalInMillis(final HeartbeatIntervalType value) {
        this._shardIsolatedLeaderCheckIntervalInMillis = value;
        return this;
    }
    
     
    public OperationalPropertiesBuilder setShardJournalRecoveryLogBatchSize(final NonZeroUint32Type value) {
        this._shardJournalRecoveryLogBatchSize = value;
        return this;
    }
    
     
    public OperationalPropertiesBuilder setShardLeaderElectionTimeoutInSeconds(final NonZeroUint32Type value) {
        this._shardLeaderElectionTimeoutInSeconds = value;
        return this;
    }
    
     
    public OperationalPropertiesBuilder setShardSnapshotBatchCount(final NonZeroUint32Type value) {
        this._shardSnapshotBatchCount = value;
        return this;
    }
    
     
    public OperationalPropertiesBuilder setShardSnapshotChunkSize(final NonZeroUint32Type value) {
        this._shardSnapshotChunkSize = value;
        return this;
    }
    
     
    public OperationalPropertiesBuilder setShardSnapshotDataThresholdPercentage(final Percentage value) {
        this._shardSnapshotDataThresholdPercentage = value;
        return this;
    }
    
     
    public OperationalPropertiesBuilder setShardTransactionCommitQueueCapacity(final NonZeroUint32Type value) {
        this._shardTransactionCommitQueueCapacity = value;
        return this;
    }
    
     
    public OperationalPropertiesBuilder setShardTransactionCommitTimeoutInSeconds(final NonZeroUint32Type value) {
        this._shardTransactionCommitTimeoutInSeconds = value;
        return this;
    }
    
     
    public OperationalPropertiesBuilder setShardTransactionIdleTimeoutInMinutes(final NonZeroUint32Type value) {
        this._shardTransactionIdleTimeoutInMinutes = value;
        return this;
    }
    
     
    public OperationalPropertiesBuilder setSyncIndexThreshold(final NonZeroUint32Type value) {
        this._syncIndexThreshold = value;
        return this;
    }
    
     
    public OperationalPropertiesBuilder setTransactionCreationInitialRateLimit(final NonZeroUint32Type value) {
        this._transactionCreationInitialRateLimit = value;
        return this;
    }
    
     
    public OperationalPropertiesBuilder setEnableMetricCapture(final java.lang.Boolean value) {
        this._enableMetricCapture = value;
        return this;
    }
    
     
    public OperationalPropertiesBuilder setPersistent(final java.lang.Boolean value) {
        this._persistent = value;
        return this;
    }
    
     
    public OperationalPropertiesBuilder setTransactionDebugContextEnabled(final java.lang.Boolean value) {
        this._transactionDebugContextEnabled = value;
        return this;
    }
    
     
    public OperationalPropertiesBuilder setUseTellBasedProtocol(final java.lang.Boolean value) {
        this._useTellBasedProtocol = value;
        return this;
    }
    
    public OperationalPropertiesBuilder addAugmentation(java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.distributed.datastore.provider.rev140612.modules.module.configuration.distributed.operational.datastore.provider.OperationalProperties>> augmentationType, Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.distributed.datastore.provider.rev140612.modules.module.configuration.distributed.operational.datastore.provider.OperationalProperties> augmentationValue) {
        if (augmentationValue == null) {
            return removeAugmentation(augmentationType);
        }
    
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }
    
    public OperationalPropertiesBuilder removeAugmentation(java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.distributed.datastore.provider.rev140612.modules.module.configuration.distributed.operational.datastore.provider.OperationalProperties>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public OperationalProperties build() {
        return new OperationalPropertiesImpl(this);
    }

    private static final class OperationalPropertiesImpl implements OperationalProperties {

        @Override
        public java.lang.Class<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.distributed.datastore.provider.rev140612.modules.module.configuration.distributed.operational.datastore.provider.OperationalProperties> getImplementedInterface() {
            return org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.distributed.datastore.provider.rev140612.modules.module.configuration.distributed.operational.datastore.provider.OperationalProperties.class;
        }

        private final NonZeroUint32Type _backendAlivenessTimerIntervalInSeconds;
        private final NonZeroUint32Type _boundedMailboxCapacity;
        private final java.lang.String _customRaftPolicyImplementation;
        private final NonZeroUint32Type _fileBackedStreamingThresholdInMegabytes;
        private final NonZeroUint32Type _frontendNoProgressTimeoutInSeconds;
        private final NonZeroUint32Type _frontendRequestTimeoutInSeconds;
        private final NonZeroUint32Type _maxShardDataChangeExecutorPoolSize;
        private final NonZeroUint32Type _maxShardDataChangeExecutorQueueSize;
        private final NonZeroUint32Type _maxShardDataChangeListenerQueueSize;
        private final NonZeroUint32Type _maxShardDataStoreExecutorQueueSize;
        private final NonZeroUint32Type _maximumMessageSliceSize;
        private final OperationTimeoutType _operationTimeoutInSeconds;
        private final NonZeroUint32Type _shardBatchedModificationCount;
        private final NonZeroUint32Type _shardCommitQueueExpiryTimeoutInSeconds;
        private final NonZeroUint32Type _shardElectionTimeoutFactor;
        private final HeartbeatIntervalType _shardHeartbeatIntervalInMillis;
        private final NonZeroUint32Type _shardInitializationTimeoutInSeconds;
        private final HeartbeatIntervalType _shardIsolatedLeaderCheckIntervalInMillis;
        private final NonZeroUint32Type _shardJournalRecoveryLogBatchSize;
        private final NonZeroUint32Type _shardLeaderElectionTimeoutInSeconds;
        private final NonZeroUint32Type _shardSnapshotBatchCount;
        private final NonZeroUint32Type _shardSnapshotChunkSize;
        private final Percentage _shardSnapshotDataThresholdPercentage;
        private final NonZeroUint32Type _shardTransactionCommitQueueCapacity;
        private final NonZeroUint32Type _shardTransactionCommitTimeoutInSeconds;
        private final NonZeroUint32Type _shardTransactionIdleTimeoutInMinutes;
        private final NonZeroUint32Type _syncIndexThreshold;
        private final NonZeroUint32Type _transactionCreationInitialRateLimit;
        private final java.lang.Boolean _enableMetricCapture;
        private final java.lang.Boolean _persistent;
        private final java.lang.Boolean _transactionDebugContextEnabled;
        private final java.lang.Boolean _useTellBasedProtocol;

        private Map<java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.distributed.datastore.provider.rev140612.modules.module.configuration.distributed.operational.datastore.provider.OperationalProperties>>, Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.distributed.datastore.provider.rev140612.modules.module.configuration.distributed.operational.datastore.provider.OperationalProperties>> augmentation = Collections.emptyMap();

        private OperationalPropertiesImpl(OperationalPropertiesBuilder base) {
            this._backendAlivenessTimerIntervalInSeconds = base.getBackendAlivenessTimerIntervalInSeconds();
            this._boundedMailboxCapacity = base.getBoundedMailboxCapacity();
            this._customRaftPolicyImplementation = base.getCustomRaftPolicyImplementation();
            this._fileBackedStreamingThresholdInMegabytes = base.getFileBackedStreamingThresholdInMegabytes();
            this._frontendNoProgressTimeoutInSeconds = base.getFrontendNoProgressTimeoutInSeconds();
            this._frontendRequestTimeoutInSeconds = base.getFrontendRequestTimeoutInSeconds();
            this._maxShardDataChangeExecutorPoolSize = base.getMaxShardDataChangeExecutorPoolSize();
            this._maxShardDataChangeExecutorQueueSize = base.getMaxShardDataChangeExecutorQueueSize();
            this._maxShardDataChangeListenerQueueSize = base.getMaxShardDataChangeListenerQueueSize();
            this._maxShardDataStoreExecutorQueueSize = base.getMaxShardDataStoreExecutorQueueSize();
            this._maximumMessageSliceSize = base.getMaximumMessageSliceSize();
            this._operationTimeoutInSeconds = base.getOperationTimeoutInSeconds();
            this._shardBatchedModificationCount = base.getShardBatchedModificationCount();
            this._shardCommitQueueExpiryTimeoutInSeconds = base.getShardCommitQueueExpiryTimeoutInSeconds();
            this._shardElectionTimeoutFactor = base.getShardElectionTimeoutFactor();
            this._shardHeartbeatIntervalInMillis = base.getShardHeartbeatIntervalInMillis();
            this._shardInitializationTimeoutInSeconds = base.getShardInitializationTimeoutInSeconds();
            this._shardIsolatedLeaderCheckIntervalInMillis = base.getShardIsolatedLeaderCheckIntervalInMillis();
            this._shardJournalRecoveryLogBatchSize = base.getShardJournalRecoveryLogBatchSize();
            this._shardLeaderElectionTimeoutInSeconds = base.getShardLeaderElectionTimeoutInSeconds();
            this._shardSnapshotBatchCount = base.getShardSnapshotBatchCount();
            this._shardSnapshotChunkSize = base.getShardSnapshotChunkSize();
            this._shardSnapshotDataThresholdPercentage = base.getShardSnapshotDataThresholdPercentage();
            this._shardTransactionCommitQueueCapacity = base.getShardTransactionCommitQueueCapacity();
            this._shardTransactionCommitTimeoutInSeconds = base.getShardTransactionCommitTimeoutInSeconds();
            this._shardTransactionIdleTimeoutInMinutes = base.getShardTransactionIdleTimeoutInMinutes();
            this._syncIndexThreshold = base.getSyncIndexThreshold();
            this._transactionCreationInitialRateLimit = base.getTransactionCreationInitialRateLimit();
            this._enableMetricCapture = base.isEnableMetricCapture();
            this._persistent = base.isPersistent();
            this._transactionDebugContextEnabled = base.isTransactionDebugContextEnabled();
            this._useTellBasedProtocol = base.isUseTellBasedProtocol();
            switch (base.augmentation.size()) {
            case 0:
                this.augmentation = Collections.emptyMap();
                break;
            case 1:
                final Map.Entry<java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.distributed.datastore.provider.rev140612.modules.module.configuration.distributed.operational.datastore.provider.OperationalProperties>>, Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.distributed.datastore.provider.rev140612.modules.module.configuration.distributed.operational.datastore.provider.OperationalProperties>> e = base.augmentation.entrySet().iterator().next();
                this.augmentation = Collections.<java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.distributed.datastore.provider.rev140612.modules.module.configuration.distributed.operational.datastore.provider.OperationalProperties>>, Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.distributed.datastore.provider.rev140612.modules.module.configuration.distributed.operational.datastore.provider.OperationalProperties>>singletonMap(e.getKey(), e.getValue());
                break;
            default :
                this.augmentation = new HashMap<>(base.augmentation);
            }
        }

        @Override
        public NonZeroUint32Type getBackendAlivenessTimerIntervalInSeconds() {
            return _backendAlivenessTimerIntervalInSeconds;
        }
        
        @Override
        public NonZeroUint32Type getBoundedMailboxCapacity() {
            return _boundedMailboxCapacity;
        }
        
        @Override
        public java.lang.String getCustomRaftPolicyImplementation() {
            return _customRaftPolicyImplementation;
        }
        
        @Override
        public NonZeroUint32Type getFileBackedStreamingThresholdInMegabytes() {
            return _fileBackedStreamingThresholdInMegabytes;
        }
        
        @Override
        public NonZeroUint32Type getFrontendNoProgressTimeoutInSeconds() {
            return _frontendNoProgressTimeoutInSeconds;
        }
        
        @Override
        public NonZeroUint32Type getFrontendRequestTimeoutInSeconds() {
            return _frontendRequestTimeoutInSeconds;
        }
        
        @Override
        public NonZeroUint32Type getMaxShardDataChangeExecutorPoolSize() {
            return _maxShardDataChangeExecutorPoolSize;
        }
        
        @Override
        public NonZeroUint32Type getMaxShardDataChangeExecutorQueueSize() {
            return _maxShardDataChangeExecutorQueueSize;
        }
        
        @Override
        public NonZeroUint32Type getMaxShardDataChangeListenerQueueSize() {
            return _maxShardDataChangeListenerQueueSize;
        }
        
        @Override
        public NonZeroUint32Type getMaxShardDataStoreExecutorQueueSize() {
            return _maxShardDataStoreExecutorQueueSize;
        }
        
        @Override
        public NonZeroUint32Type getMaximumMessageSliceSize() {
            return _maximumMessageSliceSize;
        }
        
        @Override
        public OperationTimeoutType getOperationTimeoutInSeconds() {
            return _operationTimeoutInSeconds;
        }
        
        @Override
        public NonZeroUint32Type getShardBatchedModificationCount() {
            return _shardBatchedModificationCount;
        }
        
        @Override
        public NonZeroUint32Type getShardCommitQueueExpiryTimeoutInSeconds() {
            return _shardCommitQueueExpiryTimeoutInSeconds;
        }
        
        @Override
        public NonZeroUint32Type getShardElectionTimeoutFactor() {
            return _shardElectionTimeoutFactor;
        }
        
        @Override
        public HeartbeatIntervalType getShardHeartbeatIntervalInMillis() {
            return _shardHeartbeatIntervalInMillis;
        }
        
        @Override
        public NonZeroUint32Type getShardInitializationTimeoutInSeconds() {
            return _shardInitializationTimeoutInSeconds;
        }
        
        @Override
        public HeartbeatIntervalType getShardIsolatedLeaderCheckIntervalInMillis() {
            return _shardIsolatedLeaderCheckIntervalInMillis;
        }
        
        @Override
        public NonZeroUint32Type getShardJournalRecoveryLogBatchSize() {
            return _shardJournalRecoveryLogBatchSize;
        }
        
        @Override
        public NonZeroUint32Type getShardLeaderElectionTimeoutInSeconds() {
            return _shardLeaderElectionTimeoutInSeconds;
        }
        
        @Override
        public NonZeroUint32Type getShardSnapshotBatchCount() {
            return _shardSnapshotBatchCount;
        }
        
        @Override
        public NonZeroUint32Type getShardSnapshotChunkSize() {
            return _shardSnapshotChunkSize;
        }
        
        @Override
        public Percentage getShardSnapshotDataThresholdPercentage() {
            return _shardSnapshotDataThresholdPercentage;
        }
        
        @Override
        public NonZeroUint32Type getShardTransactionCommitQueueCapacity() {
            return _shardTransactionCommitQueueCapacity;
        }
        
        @Override
        public NonZeroUint32Type getShardTransactionCommitTimeoutInSeconds() {
            return _shardTransactionCommitTimeoutInSeconds;
        }
        
        @Override
        public NonZeroUint32Type getShardTransactionIdleTimeoutInMinutes() {
            return _shardTransactionIdleTimeoutInMinutes;
        }
        
        @Override
        public NonZeroUint32Type getSyncIndexThreshold() {
            return _syncIndexThreshold;
        }
        
        @Override
        public NonZeroUint32Type getTransactionCreationInitialRateLimit() {
            return _transactionCreationInitialRateLimit;
        }
        
        @Override
        public java.lang.Boolean isEnableMetricCapture() {
            return _enableMetricCapture;
        }
        
        @Override
        public java.lang.Boolean isPersistent() {
            return _persistent;
        }
        
        @Override
        public java.lang.Boolean isTransactionDebugContextEnabled() {
            return _transactionDebugContextEnabled;
        }
        
        @Override
        public java.lang.Boolean isUseTellBasedProtocol() {
            return _useTellBasedProtocol;
        }
        
        @SuppressWarnings("unchecked")
        @Override
        public <E extends Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.distributed.datastore.provider.rev140612.modules.module.configuration.distributed.operational.datastore.provider.OperationalProperties>> E getAugmentation(java.lang.Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E) augmentation.get(augmentationType);
        }

        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int prime = 31;
            int result = 1;
            result = prime * result + Objects.hashCode(_backendAlivenessTimerIntervalInSeconds);
            result = prime * result + Objects.hashCode(_boundedMailboxCapacity);
            result = prime * result + Objects.hashCode(_customRaftPolicyImplementation);
            result = prime * result + Objects.hashCode(_fileBackedStreamingThresholdInMegabytes);
            result = prime * result + Objects.hashCode(_frontendNoProgressTimeoutInSeconds);
            result = prime * result + Objects.hashCode(_frontendRequestTimeoutInSeconds);
            result = prime * result + Objects.hashCode(_maxShardDataChangeExecutorPoolSize);
            result = prime * result + Objects.hashCode(_maxShardDataChangeExecutorQueueSize);
            result = prime * result + Objects.hashCode(_maxShardDataChangeListenerQueueSize);
            result = prime * result + Objects.hashCode(_maxShardDataStoreExecutorQueueSize);
            result = prime * result + Objects.hashCode(_maximumMessageSliceSize);
            result = prime * result + Objects.hashCode(_operationTimeoutInSeconds);
            result = prime * result + Objects.hashCode(_shardBatchedModificationCount);
            result = prime * result + Objects.hashCode(_shardCommitQueueExpiryTimeoutInSeconds);
            result = prime * result + Objects.hashCode(_shardElectionTimeoutFactor);
            result = prime * result + Objects.hashCode(_shardHeartbeatIntervalInMillis);
            result = prime * result + Objects.hashCode(_shardInitializationTimeoutInSeconds);
            result = prime * result + Objects.hashCode(_shardIsolatedLeaderCheckIntervalInMillis);
            result = prime * result + Objects.hashCode(_shardJournalRecoveryLogBatchSize);
            result = prime * result + Objects.hashCode(_shardLeaderElectionTimeoutInSeconds);
            result = prime * result + Objects.hashCode(_shardSnapshotBatchCount);
            result = prime * result + Objects.hashCode(_shardSnapshotChunkSize);
            result = prime * result + Objects.hashCode(_shardSnapshotDataThresholdPercentage);
            result = prime * result + Objects.hashCode(_shardTransactionCommitQueueCapacity);
            result = prime * result + Objects.hashCode(_shardTransactionCommitTimeoutInSeconds);
            result = prime * result + Objects.hashCode(_shardTransactionIdleTimeoutInMinutes);
            result = prime * result + Objects.hashCode(_syncIndexThreshold);
            result = prime * result + Objects.hashCode(_transactionCreationInitialRateLimit);
            result = prime * result + Objects.hashCode(_enableMetricCapture);
            result = prime * result + Objects.hashCode(_persistent);
            result = prime * result + Objects.hashCode(_transactionDebugContextEnabled);
            result = prime * result + Objects.hashCode(_useTellBasedProtocol);
            result = prime * result + Objects.hashCode(augmentation);
        
            hash = result;
            hashValid = true;
            return result;
        }

        @Override
        public boolean equals(java.lang.Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.distributed.datastore.provider.rev140612.modules.module.configuration.distributed.operational.datastore.provider.OperationalProperties.class.equals(((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.distributed.datastore.provider.rev140612.modules.module.configuration.distributed.operational.datastore.provider.OperationalProperties other = (org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.distributed.datastore.provider.rev140612.modules.module.configuration.distributed.operational.datastore.provider.OperationalProperties)obj;
            if (!Objects.equals(_backendAlivenessTimerIntervalInSeconds, other.getBackendAlivenessTimerIntervalInSeconds())) {
                return false;
            }
            if (!Objects.equals(_boundedMailboxCapacity, other.getBoundedMailboxCapacity())) {
                return false;
            }
            if (!Objects.equals(_customRaftPolicyImplementation, other.getCustomRaftPolicyImplementation())) {
                return false;
            }
            if (!Objects.equals(_fileBackedStreamingThresholdInMegabytes, other.getFileBackedStreamingThresholdInMegabytes())) {
                return false;
            }
            if (!Objects.equals(_frontendNoProgressTimeoutInSeconds, other.getFrontendNoProgressTimeoutInSeconds())) {
                return false;
            }
            if (!Objects.equals(_frontendRequestTimeoutInSeconds, other.getFrontendRequestTimeoutInSeconds())) {
                return false;
            }
            if (!Objects.equals(_maxShardDataChangeExecutorPoolSize, other.getMaxShardDataChangeExecutorPoolSize())) {
                return false;
            }
            if (!Objects.equals(_maxShardDataChangeExecutorQueueSize, other.getMaxShardDataChangeExecutorQueueSize())) {
                return false;
            }
            if (!Objects.equals(_maxShardDataChangeListenerQueueSize, other.getMaxShardDataChangeListenerQueueSize())) {
                return false;
            }
            if (!Objects.equals(_maxShardDataStoreExecutorQueueSize, other.getMaxShardDataStoreExecutorQueueSize())) {
                return false;
            }
            if (!Objects.equals(_maximumMessageSliceSize, other.getMaximumMessageSliceSize())) {
                return false;
            }
            if (!Objects.equals(_operationTimeoutInSeconds, other.getOperationTimeoutInSeconds())) {
                return false;
            }
            if (!Objects.equals(_shardBatchedModificationCount, other.getShardBatchedModificationCount())) {
                return false;
            }
            if (!Objects.equals(_shardCommitQueueExpiryTimeoutInSeconds, other.getShardCommitQueueExpiryTimeoutInSeconds())) {
                return false;
            }
            if (!Objects.equals(_shardElectionTimeoutFactor, other.getShardElectionTimeoutFactor())) {
                return false;
            }
            if (!Objects.equals(_shardHeartbeatIntervalInMillis, other.getShardHeartbeatIntervalInMillis())) {
                return false;
            }
            if (!Objects.equals(_shardInitializationTimeoutInSeconds, other.getShardInitializationTimeoutInSeconds())) {
                return false;
            }
            if (!Objects.equals(_shardIsolatedLeaderCheckIntervalInMillis, other.getShardIsolatedLeaderCheckIntervalInMillis())) {
                return false;
            }
            if (!Objects.equals(_shardJournalRecoveryLogBatchSize, other.getShardJournalRecoveryLogBatchSize())) {
                return false;
            }
            if (!Objects.equals(_shardLeaderElectionTimeoutInSeconds, other.getShardLeaderElectionTimeoutInSeconds())) {
                return false;
            }
            if (!Objects.equals(_shardSnapshotBatchCount, other.getShardSnapshotBatchCount())) {
                return false;
            }
            if (!Objects.equals(_shardSnapshotChunkSize, other.getShardSnapshotChunkSize())) {
                return false;
            }
            if (!Objects.equals(_shardSnapshotDataThresholdPercentage, other.getShardSnapshotDataThresholdPercentage())) {
                return false;
            }
            if (!Objects.equals(_shardTransactionCommitQueueCapacity, other.getShardTransactionCommitQueueCapacity())) {
                return false;
            }
            if (!Objects.equals(_shardTransactionCommitTimeoutInSeconds, other.getShardTransactionCommitTimeoutInSeconds())) {
                return false;
            }
            if (!Objects.equals(_shardTransactionIdleTimeoutInMinutes, other.getShardTransactionIdleTimeoutInMinutes())) {
                return false;
            }
            if (!Objects.equals(_syncIndexThreshold, other.getSyncIndexThreshold())) {
                return false;
            }
            if (!Objects.equals(_transactionCreationInitialRateLimit, other.getTransactionCreationInitialRateLimit())) {
                return false;
            }
            if (!Objects.equals(_enableMetricCapture, other.isEnableMetricCapture())) {
                return false;
            }
            if (!Objects.equals(_persistent, other.isPersistent())) {
                return false;
            }
            if (!Objects.equals(_transactionDebugContextEnabled, other.isTransactionDebugContextEnabled())) {
                return false;
            }
            if (!Objects.equals(_useTellBasedProtocol, other.isUseTellBasedProtocol())) {
                return false;
            }
            if (getClass() == obj.getClass()) {
                // Simple case: we are comparing against self
                OperationalPropertiesImpl otherImpl = (OperationalPropertiesImpl) obj;
                if (!Objects.equals(augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                // Hard case: compare our augments with presence there...
                for (Map.Entry<java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.distributed.datastore.provider.rev140612.modules.module.configuration.distributed.operational.datastore.provider.OperationalProperties>>, Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.distributed.datastore.provider.rev140612.modules.module.configuration.distributed.operational.datastore.provider.OperationalProperties>> e : augmentation.entrySet()) {
                    if (!e.getValue().equals(other.getAugmentation(e.getKey()))) {
                        return false;
                    }
                }
                // .. and give the other one the chance to do the same
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        @Override
        public java.lang.String toString() {
            java.lang.String name = "OperationalProperties [";
            java.lang.StringBuilder builder = new java.lang.StringBuilder (name);
            if (_backendAlivenessTimerIntervalInSeconds != null) {
                builder.append("_backendAlivenessTimerIntervalInSeconds=");
                builder.append(_backendAlivenessTimerIntervalInSeconds);
                builder.append(", ");
            }
            if (_boundedMailboxCapacity != null) {
                builder.append("_boundedMailboxCapacity=");
                builder.append(_boundedMailboxCapacity);
                builder.append(", ");
            }
            if (_customRaftPolicyImplementation != null) {
                builder.append("_customRaftPolicyImplementation=");
                builder.append(_customRaftPolicyImplementation);
                builder.append(", ");
            }
            if (_fileBackedStreamingThresholdInMegabytes != null) {
                builder.append("_fileBackedStreamingThresholdInMegabytes=");
                builder.append(_fileBackedStreamingThresholdInMegabytes);
                builder.append(", ");
            }
            if (_frontendNoProgressTimeoutInSeconds != null) {
                builder.append("_frontendNoProgressTimeoutInSeconds=");
                builder.append(_frontendNoProgressTimeoutInSeconds);
                builder.append(", ");
            }
            if (_frontendRequestTimeoutInSeconds != null) {
                builder.append("_frontendRequestTimeoutInSeconds=");
                builder.append(_frontendRequestTimeoutInSeconds);
                builder.append(", ");
            }
            if (_maxShardDataChangeExecutorPoolSize != null) {
                builder.append("_maxShardDataChangeExecutorPoolSize=");
                builder.append(_maxShardDataChangeExecutorPoolSize);
                builder.append(", ");
            }
            if (_maxShardDataChangeExecutorQueueSize != null) {
                builder.append("_maxShardDataChangeExecutorQueueSize=");
                builder.append(_maxShardDataChangeExecutorQueueSize);
                builder.append(", ");
            }
            if (_maxShardDataChangeListenerQueueSize != null) {
                builder.append("_maxShardDataChangeListenerQueueSize=");
                builder.append(_maxShardDataChangeListenerQueueSize);
                builder.append(", ");
            }
            if (_maxShardDataStoreExecutorQueueSize != null) {
                builder.append("_maxShardDataStoreExecutorQueueSize=");
                builder.append(_maxShardDataStoreExecutorQueueSize);
                builder.append(", ");
            }
            if (_maximumMessageSliceSize != null) {
                builder.append("_maximumMessageSliceSize=");
                builder.append(_maximumMessageSliceSize);
                builder.append(", ");
            }
            if (_operationTimeoutInSeconds != null) {
                builder.append("_operationTimeoutInSeconds=");
                builder.append(_operationTimeoutInSeconds);
                builder.append(", ");
            }
            if (_shardBatchedModificationCount != null) {
                builder.append("_shardBatchedModificationCount=");
                builder.append(_shardBatchedModificationCount);
                builder.append(", ");
            }
            if (_shardCommitQueueExpiryTimeoutInSeconds != null) {
                builder.append("_shardCommitQueueExpiryTimeoutInSeconds=");
                builder.append(_shardCommitQueueExpiryTimeoutInSeconds);
                builder.append(", ");
            }
            if (_shardElectionTimeoutFactor != null) {
                builder.append("_shardElectionTimeoutFactor=");
                builder.append(_shardElectionTimeoutFactor);
                builder.append(", ");
            }
            if (_shardHeartbeatIntervalInMillis != null) {
                builder.append("_shardHeartbeatIntervalInMillis=");
                builder.append(_shardHeartbeatIntervalInMillis);
                builder.append(", ");
            }
            if (_shardInitializationTimeoutInSeconds != null) {
                builder.append("_shardInitializationTimeoutInSeconds=");
                builder.append(_shardInitializationTimeoutInSeconds);
                builder.append(", ");
            }
            if (_shardIsolatedLeaderCheckIntervalInMillis != null) {
                builder.append("_shardIsolatedLeaderCheckIntervalInMillis=");
                builder.append(_shardIsolatedLeaderCheckIntervalInMillis);
                builder.append(", ");
            }
            if (_shardJournalRecoveryLogBatchSize != null) {
                builder.append("_shardJournalRecoveryLogBatchSize=");
                builder.append(_shardJournalRecoveryLogBatchSize);
                builder.append(", ");
            }
            if (_shardLeaderElectionTimeoutInSeconds != null) {
                builder.append("_shardLeaderElectionTimeoutInSeconds=");
                builder.append(_shardLeaderElectionTimeoutInSeconds);
                builder.append(", ");
            }
            if (_shardSnapshotBatchCount != null) {
                builder.append("_shardSnapshotBatchCount=");
                builder.append(_shardSnapshotBatchCount);
                builder.append(", ");
            }
            if (_shardSnapshotChunkSize != null) {
                builder.append("_shardSnapshotChunkSize=");
                builder.append(_shardSnapshotChunkSize);
                builder.append(", ");
            }
            if (_shardSnapshotDataThresholdPercentage != null) {
                builder.append("_shardSnapshotDataThresholdPercentage=");
                builder.append(_shardSnapshotDataThresholdPercentage);
                builder.append(", ");
            }
            if (_shardTransactionCommitQueueCapacity != null) {
                builder.append("_shardTransactionCommitQueueCapacity=");
                builder.append(_shardTransactionCommitQueueCapacity);
                builder.append(", ");
            }
            if (_shardTransactionCommitTimeoutInSeconds != null) {
                builder.append("_shardTransactionCommitTimeoutInSeconds=");
                builder.append(_shardTransactionCommitTimeoutInSeconds);
                builder.append(", ");
            }
            if (_shardTransactionIdleTimeoutInMinutes != null) {
                builder.append("_shardTransactionIdleTimeoutInMinutes=");
                builder.append(_shardTransactionIdleTimeoutInMinutes);
                builder.append(", ");
            }
            if (_syncIndexThreshold != null) {
                builder.append("_syncIndexThreshold=");
                builder.append(_syncIndexThreshold);
                builder.append(", ");
            }
            if (_transactionCreationInitialRateLimit != null) {
                builder.append("_transactionCreationInitialRateLimit=");
                builder.append(_transactionCreationInitialRateLimit);
                builder.append(", ");
            }
            if (_enableMetricCapture != null) {
                builder.append("_enableMetricCapture=");
                builder.append(_enableMetricCapture);
                builder.append(", ");
            }
            if (_persistent != null) {
                builder.append("_persistent=");
                builder.append(_persistent);
                builder.append(", ");
            }
            if (_transactionDebugContextEnabled != null) {
                builder.append("_transactionDebugContextEnabled=");
                builder.append(_transactionDebugContextEnabled);
                builder.append(", ");
            }
            if (_useTellBasedProtocol != null) {
                builder.append("_useTellBasedProtocol=");
                builder.append(_useTellBasedProtocol);
            }
            final int builderLength = builder.length();
            final int builderAdditionalLength = builder.substring(name.length(), builderLength).length();
            if (builderAdditionalLength > 2 && !builder.substring(builderLength - 2, builderLength).equals(", ")) {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(augmentation.values());
            return builder.append(']').toString();
        }
    }

}
