package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.clustering.entity.owners.rev150804;
import org.opendaylight.yangtools.yang.binding.ChildOf;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.clustering.entity.owners.rev150804.entity.owners.EntityType;
import org.opendaylight.yangtools.yang.common.QName;
import java.util.List;
import org.opendaylight.yangtools.yang.binding.Augmentable;

/**
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>entity-owners</b>
 * <pre>
 * container entity-owners {
 *     list entity-type {
 *         key "type";
 *         leaf type {
 *             type string;
 *         }
 *         list entity {
 *             key "id";
 *             leaf id {
 *                 type instance-identifier;
 *             }
 *             leaf owner {
 *                 type string;
 *             }
 *             list candidate {
 *                 key "name";
 *                 leaf name {
 *                     type string;
 *                 }
 *             }
 *         }
 *     }
 * }
 * </pre>The schema path to identify an instance is
 * <i>entity-owners/entity-owners</i>
 *
 * <p>To create instances of this class use {@link EntityOwnersBuilder}.
 * @see EntityOwnersBuilder
 *
 */
public interface EntityOwners
    extends
    ChildOf<EntityOwnersData>,
    Augmentable<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.clustering.entity.owners.rev150804.EntityOwners>
{



    public static final QName QNAME = org.opendaylight.yangtools.yang.common.QName.create("urn:opendaylight:params:xml:ns:yang:controller:md:sal:clustering:entity-owners",
        "2015-08-04", "entity-owners").intern();

    /**
     * @return <code>java.util.List</code> <code>entityType</code>, or <code>null</code> if not present
     */
    List<EntityType> getEntityType();

}

