package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.clustering.entity.owners.rev150804.entity.owners;
import org.opendaylight.yangtools.yang.binding.ChildOf;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.clustering.entity.owners.rev150804.entity.owners.entity.type.Entity;
import org.opendaylight.yangtools.yang.common.QName;
import java.util.List;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.clustering.entity.owners.rev150804.EntityOwners;
import org.opendaylight.yangtools.yang.binding.Augmentable;
import org.opendaylight.yangtools.yang.binding.Identifiable;

/**
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>entity-owners</b>
 * <pre>
 * list entity-type {
 *     key "type";
 *     leaf type {
 *         type string;
 *     }
 *     list entity {
 *         key "id";
 *         leaf id {
 *             type instance-identifier;
 *         }
 *         leaf owner {
 *             type string;
 *         }
 *         list candidate {
 *             key "name";
 *             leaf name {
 *                 type string;
 *             }
 *         }
 *     }
 * }
 * </pre>The schema path to identify an instance is
 * <i>entity-owners/entity-owners/entity-type</i>
 *
 * <p>To create instances of this class use {@link EntityTypeBuilder}.
 * @see EntityTypeBuilder
 * @see EntityTypeKey
 *
 */
public interface EntityType
    extends
    ChildOf<EntityOwners>,
    Augmentable<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.clustering.entity.owners.rev150804.entity.owners.EntityType>,
    Identifiable<EntityTypeKey>
{



    public static final QName QNAME = org.opendaylight.yangtools.yang.common.QName.create("urn:opendaylight:params:xml:ns:yang:controller:md:sal:clustering:entity-owners",
        "2015-08-04", "entity-type").intern();

    /**
     * @return <code>java.lang.String</code> <code>type</code>, or <code>null</code> if not present
     */
    java.lang.String getType();
    
    /**
     * @return <code>java.util.List</code> <code>entity</code>, or <code>null</code> if not present
     */
    List<Entity> getEntity();
    
    /**
     * Returns Primary Key of Yang List Type
     *
     *
     *
     * @return <code>org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.clustering.entity.owners.rev150804.entity.owners.EntityTypeKey</code> <code>key</code>, or <code>null</code> if not present
     */
    EntityTypeKey getKey();

}

