package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.clustering.entity.owners.rev150804.entity.owners.entity.type;
import org.opendaylight.yangtools.yang.binding.ChildOf;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.clustering.entity.owners.rev150804.entity.owners.EntityType;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.clustering.entity.owners.rev150804.entity.owners.entity.type.entity.Candidate;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.binding.InstanceIdentifier;
import java.util.List;
import org.opendaylight.yangtools.yang.binding.Augmentable;
import org.opendaylight.yangtools.yang.binding.Identifiable;

/**
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>entity-owners</b>
 * <pre>
 * list entity {
 *     key "id";
 *     leaf id {
 *         type instance-identifier;
 *     }
 *     leaf owner {
 *         type string;
 *     }
 *     list candidate {
 *         key "name";
 *         leaf name {
 *             type string;
 *         }
 *     }
 * }
 * </pre>The schema path to identify an instance is
 * <i>entity-owners/entity-owners/entity-type/entity</i>
 *
 * <p>To create instances of this class use {@link EntityBuilder}.
 * @see EntityBuilder
 * @see EntityKey
 *
 */
public interface Entity
    extends
    ChildOf<EntityType>,
    Augmentable<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.clustering.entity.owners.rev150804.entity.owners.entity.type.Entity>,
    Identifiable<EntityKey>
{



    public static final QName QNAME = org.opendaylight.yangtools.yang.common.QName.create("urn:opendaylight:params:xml:ns:yang:controller:md:sal:clustering:entity-owners",
        "2015-08-04", "entity").intern();

    /**
     * @return <code>org.opendaylight.yangtools.yang.binding.InstanceIdentifier</code> <code>id</code>, or <code>null</code> if not present
     */
    InstanceIdentifier<?> getId();
    
    /**
     * @return <code>java.lang.String</code> <code>owner</code>, or <code>null</code> if not present
     */
    java.lang.String getOwner();
    
    /**
     * @return <code>java.util.List</code> <code>candidate</code>, or <code>null</code> if not present
     */
    List<Candidate> getCandidate();
    
    /**
     * Returns Primary Key of Yang List Type
     *
     *
     *
     * @return <code>org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.clustering.entity.owners.rev150804.entity.owners.entity.type.EntityKey</code> <code>key</code>, or <code>null</code> if not present
     */
    EntityKey getKey();

}

