package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.clustering.entity.owners.rev150804.entity.owners.entity.type.entity;
import org.opendaylight.yangtools.yang.binding.ChildOf;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.clustering.entity.owners.rev150804.entity.owners.entity.type.Entity;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.binding.Augmentable;
import org.opendaylight.yangtools.yang.binding.Identifiable;

/**
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>entity-owners</b>
 * <pre>
 * list candidate {
 *     key "name";
 *     leaf name {
 *         type string;
 *     }
 * }
 * </pre>The schema path to identify an instance is
 * <i>entity-owners/entity-owners/entity-type/entity/candidate</i>
 *
 * <p>To create instances of this class use {@link CandidateBuilder}.
 * @see CandidateBuilder
 * @see CandidateKey
 *
 */
public interface Candidate
    extends
    ChildOf<Entity>,
    Augmentable<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.clustering.entity.owners.rev150804.entity.owners.entity.type.entity.Candidate>,
    Identifiable<CandidateKey>
{



    public static final QName QNAME = org.opendaylight.yangtools.yang.common.QName.create("urn:opendaylight:params:xml:ns:yang:controller:md:sal:clustering:entity-owners",
        "2015-08-04", "candidate").intern();

    /**
     * @return <code>java.lang.String</code> <code>name</code>, or <code>null</code> if not present
     */
    java.lang.String getName();
    
    /**
     * Returns Primary Key of Yang List Type
     *
     *
     *
     * @return <code>org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.clustering.entity.owners.rev150804.entity.owners.entity.type.entity.CandidateKey</code> <code>key</code>, or <code>null</code> if not present
     */
    CandidateKey getKey();

}

