package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.clustering.prefix.shard.configuration.rev170110;
import org.opendaylight.yangtools.yang.binding.ChildOf;
import org.opendaylight.yangtools.yang.common.QName;
import java.util.List;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.clustering.prefix.shard.configuration.rev170110.prefix.shards.Shard;
import org.opendaylight.yangtools.yang.binding.Augmentable;

/**
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>prefix-shard-configuration</b>
 * <pre>
 * container prefix-shards {
 *     list shard {
 *         key "prefix";
 *         leaf prefix {
 *             type instance-identifier;
 *         }
 *         container replicas {
 *             leaf-list replica {
 *                 type string;
 *             }
 *         }
 *     }
 * }
 * </pre>The schema path to identify an instance is
 * <i>prefix-shard-configuration/prefix-shards</i>
 *
 * <p>To create instances of this class use {@link PrefixShardsBuilder}.
 * @see PrefixShardsBuilder
 *
 */
public interface PrefixShards
    extends
    ChildOf<PrefixShardConfigurationData>,
    Augmentable<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.clustering.prefix.shard.configuration.rev170110.PrefixShards>
{



    public static final QName QNAME = org.opendaylight.yangtools.yang.common.QName.create("urn:opendaylight:params:xml:ns:yang:controller:md:sal:clustering:prefix-shard-configuration",
        "2017-01-10", "prefix-shards").intern();

    /**
     * List of prefix-based shards configured.
     *
     *
     *
     * @return <code>java.util.List</code> <code>shard</code>, or <code>null</code> if not present
     */
    List<Shard> getShard();

}

