package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.clustering.prefix.shard.configuration.rev170110.prefix.shards;
import org.opendaylight.yangtools.yang.binding.ChildOf;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.binding.InstanceIdentifier;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.clustering.prefix.shard.configuration.rev170110.prefix.shards.shard.Replicas;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.clustering.prefix.shard.configuration.rev170110.PrefixShards;
import org.opendaylight.yangtools.yang.binding.Augmentable;
import org.opendaylight.yangtools.yang.binding.Identifiable;

/**
 * List of prefix-based shards configured.
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>prefix-shard-configuration</b>
 * <pre>
 * list shard {
 *     key "prefix";
 *     leaf prefix {
 *         type instance-identifier;
 *     }
 *     container replicas {
 *         leaf-list replica {
 *             type string;
 *         }
 *     }
 * }
 * </pre>The schema path to identify an instance is
 * <i>prefix-shard-configuration/prefix-shards/shard</i>
 *
 * <p>To create instances of this class use {@link ShardBuilder}.
 * @see ShardBuilder
 * @see ShardKey
 *
 */
public interface Shard
    extends
    ChildOf<PrefixShards>,
    Augmentable<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.clustering.prefix.shard.configuration.rev170110.prefix.shards.Shard>,
    Identifiable<ShardKey>
{



    public static final QName QNAME = org.opendaylight.yangtools.yang.common.QName.create("urn:opendaylight:params:xml:ns:yang:controller:md:sal:clustering:prefix-shard-configuration",
        "2017-01-10", "shard").intern();

    /**
     * Prefix that this shard is rooted at.
     *
     *
     *
     * @return <code>org.opendaylight.yangtools.yang.binding.InstanceIdentifier</code> <code>prefix</code>, or <code>null</code> if not present
     */
    InstanceIdentifier<?> getPrefix();
    
    /**
     * List of cluster member nodes that this shard is replicated on
     *
     *
     *
     * @return <code>org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.clustering.prefix.shard.configuration.rev170110.prefix.shards.shard.Replicas</code> <code>replicas</code>, or <code>null</code> if not present
     */
    Replicas getReplicas();
    
    /**
     * Returns Primary Key of Yang List Type
     *
     *
     *
     * @return <code>org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.clustering.prefix.shard.configuration.rev170110.prefix.shards.ShardKey</code> <code>key</code>, or <code>null</code> if not present
     */
    ShardKey getKey();

}

