package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.clustering.prefix.shard.configuration.rev170110.prefix.shards;
import org.opendaylight.yangtools.yang.binding.Identifier;
import java.util.Objects;
import org.opendaylight.yangtools.yang.binding.InstanceIdentifier;

public class ShardKey
 implements Identifier<Shard> {
    private static final long serialVersionUID = 5708500082193372476L;
    private final InstanceIdentifier<?> _prefix;


    public ShardKey(InstanceIdentifier<?> _prefix) {
    
    
        this._prefix = _prefix;
    }
    
    /**
     * Creates a copy from Source Object.
     *
     * @param source Source object
     */
    public ShardKey(ShardKey source) {
        this._prefix = source._prefix;
    }


    public InstanceIdentifier<?> getPrefix() {
        return _prefix;
    }


    @Override
    public int hashCode() {
        final int prime = 31;
        int result = 1;
        result = prime * result + Objects.hashCode(_prefix);
        return result;
    }

    @Override
    public boolean equals(java.lang.Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (getClass() != obj.getClass()) {
            return false;
        }
        ShardKey other = (ShardKey) obj;
        if (!Objects.equals(_prefix, other._prefix)) {
            return false;
        }
        return true;
    }

    @Override
    public java.lang.String toString() {
        java.lang.StringBuilder builder = new java.lang.StringBuilder(org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.clustering.prefix.shard.configuration.rev170110.prefix.shards.ShardKey.class.getSimpleName()).append(" [");
        boolean first = true;
    
        if (_prefix != null) {
            if (first) {
                first = false;
            } else {
                builder.append(", ");
            }
            builder.append("_prefix=");
            builder.append(_prefix);
        }
        return builder.append(']').toString();
    }
}

