package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.clustering.prefix.shard.configuration.rev170110.prefix.shards.shard;
import org.opendaylight.yangtools.yang.binding.ChildOf;
import org.opendaylight.yangtools.yang.common.QName;
import java.util.List;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.clustering.prefix.shard.configuration.rev170110.prefix.shards.Shard;
import org.opendaylight.yangtools.yang.binding.Augmentable;

/**
 * List of cluster member nodes that this shard is replicated on
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>prefix-shard-configuration</b>
 * <pre>
 * container replicas {
 *     leaf-list replica {
 *         type string;
 *     }
 * }
 * </pre>The schema path to identify an instance is
 * <i>prefix-shard-configuration/prefix-shards/shard/replicas</i>
 *
 * <p>To create instances of this class use {@link ReplicasBuilder}.
 * @see ReplicasBuilder
 *
 */
public interface Replicas
    extends
    ChildOf<Shard>,
    Augmentable<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.clustering.prefix.shard.configuration.rev170110.prefix.shards.shard.Replicas>
{



    public static final QName QNAME = org.opendaylight.yangtools.yang.common.QName.create("urn:opendaylight:params:xml:ns:yang:controller:md:sal:clustering:prefix-shard-configuration",
        "2017-01-10", "replicas").intern();

    /**
     * @return <code>java.util.List</code> <code>replica</code>, or <code>null</code> if not present
     */
    List<java.lang.String> getReplica();

}

