package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.distributed.datastore.provider.rev140612;
import java.lang.Boolean;
import java.lang.Deprecated;
import java.lang.String;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.QName;

/**
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>distributed-datastore-provider</b>
 * <pre>
 * grouping data-store-properties {
 *   leaf max-shard-data-change-executor-queue-size {
 *     default 1000;
 *     type non-zero-uint32-type;
 *   }
 *   leaf max-shard-data-change-executor-pool-size {
 *     default 20;
 *     type non-zero-uint32-type;
 *   }
 *   leaf max-shard-data-change-listener-queue-size {
 *     default 1000;
 *     type non-zero-uint32-type;
 *   }
 *   leaf max-shard-data-store-executor-queue-size {
 *     default 5000;
 *     type non-zero-uint32-type;
 *   }
 *   leaf shard-transaction-idle-timeout-in-minutes {
 *     default 10;
 *     type non-zero-uint32-type;
 *   }
 *   leaf shard-snapshot-batch-count {
 *     default 20000;
 *     type non-zero-uint32-type;
 *   }
 *   leaf shard-snapshot-data-threshold-percentage {
 *     default 12;
 *     type percentage;
 *   }
 *   leaf shard-heartbeat-interval-in-millis {
 *     default 500;
 *     type heartbeat-interval-type;
 *   }
 *   leaf shard-election-timeout-factor {
 *     default 20;
 *     type non-zero-uint32-type;
 *   }
 *   leaf operation-timeout-in-seconds {
 *     default 5;
 *     type operation-timeout-type;
 *   }
 *   leaf shard-journal-recovery-log-batch-size {
 *     default 1;
 *     type non-zero-uint32-type;
 *   }
 *   leaf shard-transaction-commit-timeout-in-seconds {
 *     default 30;
 *     type non-zero-uint32-type;
 *   }
 *   leaf shard-transaction-commit-queue-capacity {
 *     default 50000;
 *     type non-zero-uint32-type;
 *   }
 *   leaf shard-commit-queue-expiry-timeout-in-seconds {
 *     default 120;
 *     type non-zero-uint32-type;
 *   }
 *   leaf shard-initialization-timeout-in-seconds {
 *     default 300;
 *     type non-zero-uint32-type;
 *   }
 *   leaf shard-leader-election-timeout-in-seconds {
 *     default 30;
 *     type non-zero-uint32-type;
 *   }
 *   leaf shard-batched-modification-count {
 *     default 1000;
 *     type non-zero-uint32-type;
 *   }
 *   leaf enable-metric-capture {
 *     default false;
 *     type boolean;
 *   }
 *   leaf bounded-mailbox-capacity {
 *     default 1000;
 *     type non-zero-uint32-type;
 *   }
 *   leaf persistent {
 *     default true;
 *     type boolean;
 *   }
 *   leaf shard-isolated-leader-check-interval-in-millis {
 *     default 5000;
 *     type heartbeat-interval-type;
 *   }
 *   leaf transaction-creation-initial-rate-limit {
 *     default 100;
 *     type non-zero-uint32-type;
 *   }
 *   leaf transaction-debug-context-enabled {
 *     default false;
 *     type boolean;
 *   }
 *   leaf custom-raft-policy-implementation {
 *     default "";
 *     type string;
 *   }
 *   leaf shard-snapshot-chunk-size {
 *     status deprecated;
 *     default 2048000;
 *     type non-zero-uint32-type;
 *   }
 *   leaf maximum-message-slice-size {
 *     default 2048000;
 *     type non-zero-uint32-type;
 *   }
 *   leaf use-tell-based-protocol {
 *     default false;
 *     type boolean;
 *   }
 *   leaf file-backed-streaming-threshold-in-megabytes {
 *     default 128;
 *     type non-zero-uint32-type;
 *   }
 *   leaf sync-index-threshold {
 *     default 10;
 *     type non-zero-uint32-type;
 *   }
 *   leaf backend-aliveness-timer-interval-in-seconds {
 *     default 30;
 *     type non-zero-uint32-type;
 *   }
 *   leaf frontend-request-timeout-in-seconds {
 *     default 120;
 *     type non-zero-uint32-type;
 *   }
 *   leaf frontend-no-progress-timeout-in-seconds {
 *     default 900;
 *     type non-zero-uint32-type;
 *   }
 *   leaf initial-payload-serialized-buffer-capacity {
 *     default 512;
 *     type non-zero-uint32-type;
 *   }
 * }
 * </pre>The schema path to identify an instance is
 * <i>distributed-datastore-provider/data-store-properties</i>
 *
 */
public interface DataStoreProperties
    extends
    DataObject
{



    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("data-store-properties");

    /**
     * The maximum queue size for each shard's data store data change notification 
     * executor.
     *
     *
     *
     * @return <code>org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.distributed.datastore.provider.rev140612.NonZeroUint32Type</code> <code>maxShardDataChangeExecutorQueueSize</code>, or <code>null</code> if not present
     */
    @Nullable NonZeroUint32Type getMaxShardDataChangeExecutorQueueSize();
    
    /**
     * The maximum thread pool size for each shard's data store data change 
     * notification executor.
     *
     *
     *
     * @return <code>org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.distributed.datastore.provider.rev140612.NonZeroUint32Type</code> <code>maxShardDataChangeExecutorPoolSize</code>, or <code>null</code> if not present
     */
    @Nullable NonZeroUint32Type getMaxShardDataChangeExecutorPoolSize();
    
    /**
     * The maximum queue size for each shard's data store data change listener.
     *
     *
     *
     * @return <code>org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.distributed.datastore.provider.rev140612.NonZeroUint32Type</code> <code>maxShardDataChangeListenerQueueSize</code>, or <code>null</code> if not present
     */
    @Nullable NonZeroUint32Type getMaxShardDataChangeListenerQueueSize();
    
    /**
     * The maximum queue size for each shard's data store executor.
     *
     *
     *
     * @return <code>org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.distributed.datastore.provider.rev140612.NonZeroUint32Type</code> <code>maxShardDataStoreExecutorQueueSize</code>, or <code>null</code> if not present
     */
    @Nullable NonZeroUint32Type getMaxShardDataStoreExecutorQueueSize();
    
    /**
     * The maximum amount of time a shard transaction can be idle without receiving any
     * messages before it self-destructs.
     *
     *
     *
     * @return <code>org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.distributed.datastore.provider.rev140612.NonZeroUint32Type</code> <code>shardTransactionIdleTimeoutInMinutes</code>, or <code>null</code> if not present
     */
    @Nullable NonZeroUint32Type getShardTransactionIdleTimeoutInMinutes();
    
    /**
     * The minimum number of entries to be present in the in-memory journal log before 
     * a snapshot is to be taken.
     *
     *
     *
     * @return <code>org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.distributed.datastore.provider.rev140612.NonZeroUint32Type</code> <code>shardSnapshotBatchCount</code>, or <code>null</code> if not present
     */
    @Nullable NonZeroUint32Type getShardSnapshotBatchCount();
    
    /**
     * The percentage of Runtime.maxMemory() used by the in-memory journal log before a
     * snapshot is to be taken
     *
     *
     *
     * @return <code>org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.distributed.datastore.provider.rev140612.Percentage</code> <code>shardSnapshotDataThresholdPercentage</code>, or <code>null</code> if not present
     */
    @Nullable Percentage getShardSnapshotDataThresholdPercentage();
    
    /**
     * The interval at which a shard will send a heart beat message to its remote 
     * shard.
     *
     *
     *
     * @return <code>org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.distributed.datastore.provider.rev140612.HeartbeatIntervalType</code> <code>shardHeartbeatIntervalInMillis</code>, or <code>null</code> if not present
     */
    @Nullable HeartbeatIntervalType getShardHeartbeatIntervalInMillis();
    
    /**
     * The multiplication factor to be used to determine shard election timeout. The 
     * shard election timeoutis determined by multiplying 
     * shard-heartbeat-interval-in-millis with the shard-election-timeout-factor
     *
     *
     *
     * @return <code>org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.distributed.datastore.provider.rev140612.NonZeroUint32Type</code> <code>shardElectionTimeoutFactor</code>, or <code>null</code> if not present
     */
    @Nullable NonZeroUint32Type getShardElectionTimeoutFactor();
    
    /**
     * The maximum amount of time for akka operations (remote or local) to complete 
     * before failing.
     *
     *
     *
     * @return <code>org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.distributed.datastore.provider.rev140612.OperationTimeoutType</code> <code>operationTimeoutInSeconds</code>, or <code>null</code> if not present
     */
    @Nullable OperationTimeoutType getOperationTimeoutInSeconds();
    
    /**
     * The maximum number of journal log entries to batch on recovery for a shard 
     * before committing to the data store.
     *
     *
     *
     * @return <code>org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.distributed.datastore.provider.rev140612.NonZeroUint32Type</code> <code>shardJournalRecoveryLogBatchSize</code>, or <code>null</code> if not present
     */
    @Nullable NonZeroUint32Type getShardJournalRecoveryLogBatchSize();
    
    /**
     * The maximum amount of time a shard transaction three-phase commit can be idle 
     * without receiving the next messages before it aborts the transaction
     *
     *
     *
     * @return <code>org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.distributed.datastore.provider.rev140612.NonZeroUint32Type</code> <code>shardTransactionCommitTimeoutInSeconds</code>, or <code>null</code> if not present
     */
    @Nullable NonZeroUint32Type getShardTransactionCommitTimeoutInSeconds();
    
    /**
     * The maximum allowed capacity for each shard's transaction commit queue.
     *
     *
     *
     * @return <code>org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.distributed.datastore.provider.rev140612.NonZeroUint32Type</code> <code>shardTransactionCommitQueueCapacity</code>, or <code>null</code> if not present
     */
    @Nullable NonZeroUint32Type getShardTransactionCommitQueueCapacity();
    
    /**
     * The maximum amount of time a transaction can remain in a shard's commit queue 
     * waitingto begin the CanCommit phase as coordinated by the broker front-end. 
     * Normally this should bequick but latencies can occur in between transaction 
     * ready and CanCommit or a remote brokercould lose connection and CanCommit might 
     * never occur. Expiring transactions from the queueallows subsequent pending 
     * transaction to be processed.
     *
     *
     *
     * @return <code>org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.distributed.datastore.provider.rev140612.NonZeroUint32Type</code> <code>shardCommitQueueExpiryTimeoutInSeconds</code>, or <code>null</code> if not present
     */
    @Nullable NonZeroUint32Type getShardCommitQueueExpiryTimeoutInSeconds();
    
    /**
     * The maximum amount of time to wait for a shard to initialize from persistenceon 
     * startup before failing an operation (eg transaction create and changelistener 
     * registration).
     *
     *
     *
     * @return <code>org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.distributed.datastore.provider.rev140612.NonZeroUint32Type</code> <code>shardInitializationTimeoutInSeconds</code>, or <code>null</code> if not present
     */
    @Nullable NonZeroUint32Type getShardInitializationTimeoutInSeconds();
    
    /**
     * The maximum amount of time to wait for a shard to elect a leader before failing 
     * an operation (eg transaction create).
     *
     *
     *
     * @return <code>org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.distributed.datastore.provider.rev140612.NonZeroUint32Type</code> <code>shardLeaderElectionTimeoutInSeconds</code>, or <code>null</code> if not present
     */
    @Nullable NonZeroUint32Type getShardLeaderElectionTimeoutInSeconds();
    
    /**
     * The number of transaction modification operations (put, merge, delete) tobatch 
     * before sending to the shard transaction actor. Batching improvesperformance as 
     * less modifications messages are sent to the actor and thuslessens the chance 
     * that the transaction actor's mailbox queue could get full.
     *
     *
     *
     * @return <code>org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.distributed.datastore.provider.rev140612.NonZeroUint32Type</code> <code>shardBatchedModificationCount</code>, or <code>null</code> if not present
     */
    @Nullable NonZeroUint32Type getShardBatchedModificationCount();
    
    /**
     * Enable or disable metric capture.
     *
     *
     *
     * @return <code>java.lang.Boolean</code> <code>enableMetricCapture</code>, or <code>null</code> if not present
     */
    @Nullable Boolean isEnableMetricCapture();
    
    /**
     * Max queue size that an actor's mailbox can reach
     *
     *
     *
     * @return <code>org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.distributed.datastore.provider.rev140612.NonZeroUint32Type</code> <code>boundedMailboxCapacity</code>, or <code>null</code> if not present
     */
    @Nullable NonZeroUint32Type getBoundedMailboxCapacity();
    
    /**
     * Enable or disable data persistence
     *
     *
     *
     * @return <code>java.lang.Boolean</code> <code>persistent</code>, or <code>null</code> if not present
     */
    @Nullable Boolean isPersistent();
    
    /**
     * The interval at which the leader of the shard will check if its 
     * majorityfollowers are active and term itself as isolated
     *
     *
     *
     * @return <code>org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.distributed.datastore.provider.rev140612.HeartbeatIntervalType</code> <code>shardIsolatedLeaderCheckIntervalInMillis</code>, or <code>null</code> if not present
     */
    @Nullable HeartbeatIntervalType getShardIsolatedLeaderCheckIntervalInMillis();
    
    /**
     * The initial number of transactions per second that are allowed before the data 
     * storeshould begin applying back pressure. This number is only used as an initial
     * guidance,subsequently the datastore measures the latency for a commit and 
     * auto-adjusts the rate limit
     *
     *
     *
     * @return <code>org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.distributed.datastore.provider.rev140612.NonZeroUint32Type</code> <code>transactionCreationInitialRateLimit</code>, or <code>null</code> if not present
     */
    @Nullable NonZeroUint32Type getTransactionCreationInitialRateLimit();
    
    /**
     * Enable or disable transaction context debug. This will log the call site trace 
     * fortransactions that fail
     *
     *
     *
     * @return <code>java.lang.Boolean</code> <code>transactionDebugContextEnabled</code>, or <code>null</code> if not present
     */
    @Nullable Boolean isTransactionDebugContextEnabled();
    
    /**
     * A fully qualified java class name. The class should 
     * implementorg.opendaylight.controller.cluster.raft.policy.RaftPolicy. This java 
     * class should beaccessible to the distributed data store OSGi module so that it 
     * can be dynamically loaded viareflection. For now let's assume that these classes
     * to customize raft behaviors should bepresent in the distributed data store 
     * module itself. If this property is set to a class whichcannot be found then the 
     * default raft behavior will be applied
     *
     *
     *
     * @return <code>java.lang.String</code> <code>customRaftPolicyImplementation</code>, or <code>null</code> if not present
     */
    @Nullable String getCustomRaftPolicyImplementation();
    
    /**
     * When sending a snapshot to a follower, this is the maximum size in bytes fora 
     * chunk of data.
     *
     *
     *
     * @return <code>org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.distributed.datastore.provider.rev140612.NonZeroUint32Type</code> <code>shardSnapshotChunkSize</code>, or <code>null</code> if not present
     */
    @Deprecated
    @Nullable NonZeroUint32Type getShardSnapshotChunkSize();
    
    /**
     * When fragmenting messages thru the akka remoting framework, this is themaximum 
     * size in bytes for a message slice.
     *
     *
     *
     * @return <code>org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.distributed.datastore.provider.rev140612.NonZeroUint32Type</code> <code>maximumMessageSliceSize</code>, or <code>null</code> if not present
     */
    @Nullable NonZeroUint32Type getMaximumMessageSliceSize();
    
    /**
     * Use a newer protocol between the frontend and backend. This feature is 
     * consideredexprerimental at this point.
     *
     *
     *
     * @return <code>java.lang.Boolean</code> <code>useTellBasedProtocol</code>, or <code>null</code> if not present
     */
    @Nullable Boolean isUseTellBasedProtocol();
    
    /**
     * When streaming large amounts of data, eg when sending a snapshot to a follower, 
     * thisis the threshold in terms of number of megabytes before it should switch 
     * from storing in memory tobuffering to a file.
     *
     *
     *
     * @return <code>org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.distributed.datastore.provider.rev140612.NonZeroUint32Type</code> <code>fileBackedStreamingThresholdInMegabytes</code>, or <code>null</code> if not present
     */
    @Nullable NonZeroUint32Type getFileBackedStreamingThresholdInMegabytes();
    
    /**
     * Permitted synchronization lag, expressed in terms of RAFT entry count. It a 
     * follower'scommitIndex trails the leader's journal by more than this amount of 
     * entries the followeris considered to be out-of-sync.
     *
     *
     *
     * @return <code>org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.distributed.datastore.provider.rev140612.NonZeroUint32Type</code> <code>syncIndexThreshold</code>, or <code>null</code> if not present
     */
    @Nullable NonZeroUint32Type getSyncIndexThreshold();
    
    /**
     * The timer interval whereby, on expiration after response inactivity from the 
     * back-end,the connection to the back-end is torn down and reconnection is 
     * attempted.
     *
     *
     *
     * @return <code>org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.distributed.datastore.provider.rev140612.NonZeroUint32Type</code> <code>backendAlivenessTimerIntervalInSeconds</code>, or <code>null</code> if not present
     */
    @Nullable NonZeroUint32Type getBackendAlivenessTimerIntervalInSeconds();
    
    /**
     * The timeout interval whereby client frontend transaction requests are failed.
     *
     *
     *
     * @return <code>org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.distributed.datastore.provider.rev140612.NonZeroUint32Type</code> <code>frontendRequestTimeoutInSeconds</code>, or <code>null</code> if not present
     */
    @Nullable NonZeroUint32Type getFrontendRequestTimeoutInSeconds();
    
    /**
     * The timeout interval whereby the client front-end hasn't made progress with 
     * theback-end on any request and terminates.
     *
     *
     *
     * @return <code>org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.distributed.datastore.provider.rev140612.NonZeroUint32Type</code> <code>frontendNoProgressTimeoutInSeconds</code>, or <code>null</code> if not present
     */
    @Nullable NonZeroUint32Type getFrontendNoProgressTimeoutInSeconds();
    
    /**
     * The initial buffer capacity, in bytes, to use when serializing message payloads.
     *
     *
     *
     * @return <code>org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.distributed.datastore.provider.rev140612.NonZeroUint32Type</code> <code>initialPayloadSerializedBufferCapacity</code>, or <code>null</code> if not present
     */
    @Nullable NonZeroUint32Type getInitialPayloadSerializedBufferCapacity();

}

