package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.distributed.datastore.provider.rev140612;
import com.google.common.base.MoreObjects;
import java.lang.Boolean;
import java.lang.Class;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

/**
 * Class that builds {@link DataStorePropertiesContainerBuilder} instances.
 *
 * @see DataStorePropertiesContainerBuilder
 *
 */
public class DataStorePropertiesContainerBuilder implements Builder<DataStorePropertiesContainer> {

    private NonZeroUint32Type _backendAlivenessTimerIntervalInSeconds;
    private NonZeroUint32Type _boundedMailboxCapacity;
    private String _customRaftPolicyImplementation;
    private NonZeroUint32Type _fileBackedStreamingThresholdInMegabytes;
    private NonZeroUint32Type _frontendNoProgressTimeoutInSeconds;
    private NonZeroUint32Type _frontendRequestTimeoutInSeconds;
    private NonZeroUint32Type _initialPayloadSerializedBufferCapacity;
    private NonZeroUint32Type _maxShardDataChangeExecutorPoolSize;
    private NonZeroUint32Type _maxShardDataChangeExecutorQueueSize;
    private NonZeroUint32Type _maxShardDataChangeListenerQueueSize;
    private NonZeroUint32Type _maxShardDataStoreExecutorQueueSize;
    private NonZeroUint32Type _maximumMessageSliceSize;
    private OperationTimeoutType _operationTimeoutInSeconds;
    private NonZeroUint32Type _shardBatchedModificationCount;
    private NonZeroUint32Type _shardCommitQueueExpiryTimeoutInSeconds;
    private NonZeroUint32Type _shardElectionTimeoutFactor;
    private HeartbeatIntervalType _shardHeartbeatIntervalInMillis;
    private NonZeroUint32Type _shardInitializationTimeoutInSeconds;
    private HeartbeatIntervalType _shardIsolatedLeaderCheckIntervalInMillis;
    private NonZeroUint32Type _shardJournalRecoveryLogBatchSize;
    private NonZeroUint32Type _shardLeaderElectionTimeoutInSeconds;
    private NonZeroUint32Type _shardSnapshotBatchCount;
    private NonZeroUint32Type _shardSnapshotChunkSize;
    private Percentage _shardSnapshotDataThresholdPercentage;
    private NonZeroUint32Type _shardTransactionCommitQueueCapacity;
    private NonZeroUint32Type _shardTransactionCommitTimeoutInSeconds;
    private NonZeroUint32Type _shardTransactionIdleTimeoutInMinutes;
    private NonZeroUint32Type _syncIndexThreshold;
    private NonZeroUint32Type _transactionCreationInitialRateLimit;
    private Boolean _enableMetricCapture;
    private Boolean _persistent;
    private Boolean _transactionDebugContextEnabled;
    private Boolean _useTellBasedProtocol;


    Map<Class<? extends Augmentation<DataStorePropertiesContainer>>, Augmentation<DataStorePropertiesContainer>> augmentation = Collections.emptyMap();

    public DataStorePropertiesContainerBuilder() {
    }
    public DataStorePropertiesContainerBuilder(org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.distributed.datastore.provider.rev140612.DataStoreProperties arg) {
        this._maxShardDataChangeExecutorQueueSize = arg.getMaxShardDataChangeExecutorQueueSize();
        this._maxShardDataChangeExecutorPoolSize = arg.getMaxShardDataChangeExecutorPoolSize();
        this._maxShardDataChangeListenerQueueSize = arg.getMaxShardDataChangeListenerQueueSize();
        this._maxShardDataStoreExecutorQueueSize = arg.getMaxShardDataStoreExecutorQueueSize();
        this._shardTransactionIdleTimeoutInMinutes = arg.getShardTransactionIdleTimeoutInMinutes();
        this._shardSnapshotBatchCount = arg.getShardSnapshotBatchCount();
        this._shardSnapshotDataThresholdPercentage = arg.getShardSnapshotDataThresholdPercentage();
        this._shardHeartbeatIntervalInMillis = arg.getShardHeartbeatIntervalInMillis();
        this._shardElectionTimeoutFactor = arg.getShardElectionTimeoutFactor();
        this._operationTimeoutInSeconds = arg.getOperationTimeoutInSeconds();
        this._shardJournalRecoveryLogBatchSize = arg.getShardJournalRecoveryLogBatchSize();
        this._shardTransactionCommitTimeoutInSeconds = arg.getShardTransactionCommitTimeoutInSeconds();
        this._shardTransactionCommitQueueCapacity = arg.getShardTransactionCommitQueueCapacity();
        this._shardCommitQueueExpiryTimeoutInSeconds = arg.getShardCommitQueueExpiryTimeoutInSeconds();
        this._shardInitializationTimeoutInSeconds = arg.getShardInitializationTimeoutInSeconds();
        this._shardLeaderElectionTimeoutInSeconds = arg.getShardLeaderElectionTimeoutInSeconds();
        this._shardBatchedModificationCount = arg.getShardBatchedModificationCount();
        this._enableMetricCapture = arg.isEnableMetricCapture();
        this._boundedMailboxCapacity = arg.getBoundedMailboxCapacity();
        this._persistent = arg.isPersistent();
        this._shardIsolatedLeaderCheckIntervalInMillis = arg.getShardIsolatedLeaderCheckIntervalInMillis();
        this._transactionCreationInitialRateLimit = arg.getTransactionCreationInitialRateLimit();
        this._transactionDebugContextEnabled = arg.isTransactionDebugContextEnabled();
        this._customRaftPolicyImplementation = arg.getCustomRaftPolicyImplementation();
        this._shardSnapshotChunkSize = arg.getShardSnapshotChunkSize();
        this._maximumMessageSliceSize = arg.getMaximumMessageSliceSize();
        this._useTellBasedProtocol = arg.isUseTellBasedProtocol();
        this._fileBackedStreamingThresholdInMegabytes = arg.getFileBackedStreamingThresholdInMegabytes();
        this._syncIndexThreshold = arg.getSyncIndexThreshold();
        this._backendAlivenessTimerIntervalInSeconds = arg.getBackendAlivenessTimerIntervalInSeconds();
        this._frontendRequestTimeoutInSeconds = arg.getFrontendRequestTimeoutInSeconds();
        this._frontendNoProgressTimeoutInSeconds = arg.getFrontendNoProgressTimeoutInSeconds();
        this._initialPayloadSerializedBufferCapacity = arg.getInitialPayloadSerializedBufferCapacity();
    }

    public DataStorePropertiesContainerBuilder(DataStorePropertiesContainer base) {
        if (base instanceof AugmentationHolder) {
            @SuppressWarnings("unchecked")
            Map<Class<? extends Augmentation<DataStorePropertiesContainer>>, Augmentation<DataStorePropertiesContainer>> aug =((AugmentationHolder<DataStorePropertiesContainer>) base).augmentations();
            if (!aug.isEmpty()) {
                this.augmentation = new HashMap<>(aug);
            }
        }
        this._backendAlivenessTimerIntervalInSeconds = base.getBackendAlivenessTimerIntervalInSeconds();
        this._boundedMailboxCapacity = base.getBoundedMailboxCapacity();
        this._customRaftPolicyImplementation = base.getCustomRaftPolicyImplementation();
        this._fileBackedStreamingThresholdInMegabytes = base.getFileBackedStreamingThresholdInMegabytes();
        this._frontendNoProgressTimeoutInSeconds = base.getFrontendNoProgressTimeoutInSeconds();
        this._frontendRequestTimeoutInSeconds = base.getFrontendRequestTimeoutInSeconds();
        this._initialPayloadSerializedBufferCapacity = base.getInitialPayloadSerializedBufferCapacity();
        this._maxShardDataChangeExecutorPoolSize = base.getMaxShardDataChangeExecutorPoolSize();
        this._maxShardDataChangeExecutorQueueSize = base.getMaxShardDataChangeExecutorQueueSize();
        this._maxShardDataChangeListenerQueueSize = base.getMaxShardDataChangeListenerQueueSize();
        this._maxShardDataStoreExecutorQueueSize = base.getMaxShardDataStoreExecutorQueueSize();
        this._maximumMessageSliceSize = base.getMaximumMessageSliceSize();
        this._operationTimeoutInSeconds = base.getOperationTimeoutInSeconds();
        this._shardBatchedModificationCount = base.getShardBatchedModificationCount();
        this._shardCommitQueueExpiryTimeoutInSeconds = base.getShardCommitQueueExpiryTimeoutInSeconds();
        this._shardElectionTimeoutFactor = base.getShardElectionTimeoutFactor();
        this._shardHeartbeatIntervalInMillis = base.getShardHeartbeatIntervalInMillis();
        this._shardInitializationTimeoutInSeconds = base.getShardInitializationTimeoutInSeconds();
        this._shardIsolatedLeaderCheckIntervalInMillis = base.getShardIsolatedLeaderCheckIntervalInMillis();
        this._shardJournalRecoveryLogBatchSize = base.getShardJournalRecoveryLogBatchSize();
        this._shardLeaderElectionTimeoutInSeconds = base.getShardLeaderElectionTimeoutInSeconds();
        this._shardSnapshotBatchCount = base.getShardSnapshotBatchCount();
        this._shardSnapshotChunkSize = base.getShardSnapshotChunkSize();
        this._shardSnapshotDataThresholdPercentage = base.getShardSnapshotDataThresholdPercentage();
        this._shardTransactionCommitQueueCapacity = base.getShardTransactionCommitQueueCapacity();
        this._shardTransactionCommitTimeoutInSeconds = base.getShardTransactionCommitTimeoutInSeconds();
        this._shardTransactionIdleTimeoutInMinutes = base.getShardTransactionIdleTimeoutInMinutes();
        this._syncIndexThreshold = base.getSyncIndexThreshold();
        this._transactionCreationInitialRateLimit = base.getTransactionCreationInitialRateLimit();
        this._enableMetricCapture = base.isEnableMetricCapture();
        this._persistent = base.isPersistent();
        this._transactionDebugContextEnabled = base.isTransactionDebugContextEnabled();
        this._useTellBasedProtocol = base.isUseTellBasedProtocol();
    }

    /**
     * Set fields from given grouping argument. Valid argument is instance of one of following types:
     * <ul>
     * <li>org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.distributed.datastore.provider.rev140612.DataStoreProperties</li>
     * </ul>
     *
     * @param arg grouping object
     * @throws IllegalArgumentException if given argument is none of valid types
    */
    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.distributed.datastore.provider.rev140612.DataStoreProperties) {
            this._maxShardDataChangeExecutorQueueSize = ((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.distributed.datastore.provider.rev140612.DataStoreProperties)arg).getMaxShardDataChangeExecutorQueueSize();
            this._maxShardDataChangeExecutorPoolSize = ((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.distributed.datastore.provider.rev140612.DataStoreProperties)arg).getMaxShardDataChangeExecutorPoolSize();
            this._maxShardDataChangeListenerQueueSize = ((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.distributed.datastore.provider.rev140612.DataStoreProperties)arg).getMaxShardDataChangeListenerQueueSize();
            this._maxShardDataStoreExecutorQueueSize = ((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.distributed.datastore.provider.rev140612.DataStoreProperties)arg).getMaxShardDataStoreExecutorQueueSize();
            this._shardTransactionIdleTimeoutInMinutes = ((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.distributed.datastore.provider.rev140612.DataStoreProperties)arg).getShardTransactionIdleTimeoutInMinutes();
            this._shardSnapshotBatchCount = ((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.distributed.datastore.provider.rev140612.DataStoreProperties)arg).getShardSnapshotBatchCount();
            this._shardSnapshotDataThresholdPercentage = ((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.distributed.datastore.provider.rev140612.DataStoreProperties)arg).getShardSnapshotDataThresholdPercentage();
            this._shardHeartbeatIntervalInMillis = ((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.distributed.datastore.provider.rev140612.DataStoreProperties)arg).getShardHeartbeatIntervalInMillis();
            this._shardElectionTimeoutFactor = ((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.distributed.datastore.provider.rev140612.DataStoreProperties)arg).getShardElectionTimeoutFactor();
            this._operationTimeoutInSeconds = ((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.distributed.datastore.provider.rev140612.DataStoreProperties)arg).getOperationTimeoutInSeconds();
            this._shardJournalRecoveryLogBatchSize = ((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.distributed.datastore.provider.rev140612.DataStoreProperties)arg).getShardJournalRecoveryLogBatchSize();
            this._shardTransactionCommitTimeoutInSeconds = ((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.distributed.datastore.provider.rev140612.DataStoreProperties)arg).getShardTransactionCommitTimeoutInSeconds();
            this._shardTransactionCommitQueueCapacity = ((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.distributed.datastore.provider.rev140612.DataStoreProperties)arg).getShardTransactionCommitQueueCapacity();
            this._shardCommitQueueExpiryTimeoutInSeconds = ((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.distributed.datastore.provider.rev140612.DataStoreProperties)arg).getShardCommitQueueExpiryTimeoutInSeconds();
            this._shardInitializationTimeoutInSeconds = ((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.distributed.datastore.provider.rev140612.DataStoreProperties)arg).getShardInitializationTimeoutInSeconds();
            this._shardLeaderElectionTimeoutInSeconds = ((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.distributed.datastore.provider.rev140612.DataStoreProperties)arg).getShardLeaderElectionTimeoutInSeconds();
            this._shardBatchedModificationCount = ((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.distributed.datastore.provider.rev140612.DataStoreProperties)arg).getShardBatchedModificationCount();
            this._enableMetricCapture = ((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.distributed.datastore.provider.rev140612.DataStoreProperties)arg).isEnableMetricCapture();
            this._boundedMailboxCapacity = ((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.distributed.datastore.provider.rev140612.DataStoreProperties)arg).getBoundedMailboxCapacity();
            this._persistent = ((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.distributed.datastore.provider.rev140612.DataStoreProperties)arg).isPersistent();
            this._shardIsolatedLeaderCheckIntervalInMillis = ((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.distributed.datastore.provider.rev140612.DataStoreProperties)arg).getShardIsolatedLeaderCheckIntervalInMillis();
            this._transactionCreationInitialRateLimit = ((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.distributed.datastore.provider.rev140612.DataStoreProperties)arg).getTransactionCreationInitialRateLimit();
            this._transactionDebugContextEnabled = ((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.distributed.datastore.provider.rev140612.DataStoreProperties)arg).isTransactionDebugContextEnabled();
            this._customRaftPolicyImplementation = ((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.distributed.datastore.provider.rev140612.DataStoreProperties)arg).getCustomRaftPolicyImplementation();
            this._shardSnapshotChunkSize = ((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.distributed.datastore.provider.rev140612.DataStoreProperties)arg).getShardSnapshotChunkSize();
            this._maximumMessageSliceSize = ((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.distributed.datastore.provider.rev140612.DataStoreProperties)arg).getMaximumMessageSliceSize();
            this._useTellBasedProtocol = ((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.distributed.datastore.provider.rev140612.DataStoreProperties)arg).isUseTellBasedProtocol();
            this._fileBackedStreamingThresholdInMegabytes = ((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.distributed.datastore.provider.rev140612.DataStoreProperties)arg).getFileBackedStreamingThresholdInMegabytes();
            this._syncIndexThreshold = ((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.distributed.datastore.provider.rev140612.DataStoreProperties)arg).getSyncIndexThreshold();
            this._backendAlivenessTimerIntervalInSeconds = ((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.distributed.datastore.provider.rev140612.DataStoreProperties)arg).getBackendAlivenessTimerIntervalInSeconds();
            this._frontendRequestTimeoutInSeconds = ((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.distributed.datastore.provider.rev140612.DataStoreProperties)arg).getFrontendRequestTimeoutInSeconds();
            this._frontendNoProgressTimeoutInSeconds = ((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.distributed.datastore.provider.rev140612.DataStoreProperties)arg).getFrontendNoProgressTimeoutInSeconds();
            this._initialPayloadSerializedBufferCapacity = ((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.distributed.datastore.provider.rev140612.DataStoreProperties)arg).getInitialPayloadSerializedBufferCapacity();
            isValidArg = true;
        }
        CodeHelpers.validValue(isValidArg, arg, "[org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.distributed.datastore.provider.rev140612.DataStoreProperties]");
    }

    public NonZeroUint32Type getBackendAlivenessTimerIntervalInSeconds() {
        return _backendAlivenessTimerIntervalInSeconds;
    }
    
    public NonZeroUint32Type getBoundedMailboxCapacity() {
        return _boundedMailboxCapacity;
    }
    
    public String getCustomRaftPolicyImplementation() {
        return _customRaftPolicyImplementation;
    }
    
    public NonZeroUint32Type getFileBackedStreamingThresholdInMegabytes() {
        return _fileBackedStreamingThresholdInMegabytes;
    }
    
    public NonZeroUint32Type getFrontendNoProgressTimeoutInSeconds() {
        return _frontendNoProgressTimeoutInSeconds;
    }
    
    public NonZeroUint32Type getFrontendRequestTimeoutInSeconds() {
        return _frontendRequestTimeoutInSeconds;
    }
    
    public NonZeroUint32Type getInitialPayloadSerializedBufferCapacity() {
        return _initialPayloadSerializedBufferCapacity;
    }
    
    public NonZeroUint32Type getMaxShardDataChangeExecutorPoolSize() {
        return _maxShardDataChangeExecutorPoolSize;
    }
    
    public NonZeroUint32Type getMaxShardDataChangeExecutorQueueSize() {
        return _maxShardDataChangeExecutorQueueSize;
    }
    
    public NonZeroUint32Type getMaxShardDataChangeListenerQueueSize() {
        return _maxShardDataChangeListenerQueueSize;
    }
    
    public NonZeroUint32Type getMaxShardDataStoreExecutorQueueSize() {
        return _maxShardDataStoreExecutorQueueSize;
    }
    
    public NonZeroUint32Type getMaximumMessageSliceSize() {
        return _maximumMessageSliceSize;
    }
    
    public OperationTimeoutType getOperationTimeoutInSeconds() {
        return _operationTimeoutInSeconds;
    }
    
    public NonZeroUint32Type getShardBatchedModificationCount() {
        return _shardBatchedModificationCount;
    }
    
    public NonZeroUint32Type getShardCommitQueueExpiryTimeoutInSeconds() {
        return _shardCommitQueueExpiryTimeoutInSeconds;
    }
    
    public NonZeroUint32Type getShardElectionTimeoutFactor() {
        return _shardElectionTimeoutFactor;
    }
    
    public HeartbeatIntervalType getShardHeartbeatIntervalInMillis() {
        return _shardHeartbeatIntervalInMillis;
    }
    
    public NonZeroUint32Type getShardInitializationTimeoutInSeconds() {
        return _shardInitializationTimeoutInSeconds;
    }
    
    public HeartbeatIntervalType getShardIsolatedLeaderCheckIntervalInMillis() {
        return _shardIsolatedLeaderCheckIntervalInMillis;
    }
    
    public NonZeroUint32Type getShardJournalRecoveryLogBatchSize() {
        return _shardJournalRecoveryLogBatchSize;
    }
    
    public NonZeroUint32Type getShardLeaderElectionTimeoutInSeconds() {
        return _shardLeaderElectionTimeoutInSeconds;
    }
    
    public NonZeroUint32Type getShardSnapshotBatchCount() {
        return _shardSnapshotBatchCount;
    }
    
    public NonZeroUint32Type getShardSnapshotChunkSize() {
        return _shardSnapshotChunkSize;
    }
    
    public Percentage getShardSnapshotDataThresholdPercentage() {
        return _shardSnapshotDataThresholdPercentage;
    }
    
    public NonZeroUint32Type getShardTransactionCommitQueueCapacity() {
        return _shardTransactionCommitQueueCapacity;
    }
    
    public NonZeroUint32Type getShardTransactionCommitTimeoutInSeconds() {
        return _shardTransactionCommitTimeoutInSeconds;
    }
    
    public NonZeroUint32Type getShardTransactionIdleTimeoutInMinutes() {
        return _shardTransactionIdleTimeoutInMinutes;
    }
    
    public NonZeroUint32Type getSyncIndexThreshold() {
        return _syncIndexThreshold;
    }
    
    public NonZeroUint32Type getTransactionCreationInitialRateLimit() {
        return _transactionCreationInitialRateLimit;
    }
    
    public Boolean isEnableMetricCapture() {
        return _enableMetricCapture;
    }
    
    public Boolean isPersistent() {
        return _persistent;
    }
    
    public Boolean isTransactionDebugContextEnabled() {
        return _transactionDebugContextEnabled;
    }
    
    public Boolean isUseTellBasedProtocol() {
        return _useTellBasedProtocol;
    }

    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<DataStorePropertiesContainer>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(CodeHelpers.nonNullValue(augmentationType, "augmentationType"));
    }

    
    public DataStorePropertiesContainerBuilder setBackendAlivenessTimerIntervalInSeconds(final NonZeroUint32Type value) {
        this._backendAlivenessTimerIntervalInSeconds = value;
        return this;
    }
    
    public DataStorePropertiesContainerBuilder setBoundedMailboxCapacity(final NonZeroUint32Type value) {
        this._boundedMailboxCapacity = value;
        return this;
    }
    
    public DataStorePropertiesContainerBuilder setCustomRaftPolicyImplementation(final String value) {
        this._customRaftPolicyImplementation = value;
        return this;
    }
    
    public DataStorePropertiesContainerBuilder setFileBackedStreamingThresholdInMegabytes(final NonZeroUint32Type value) {
        this._fileBackedStreamingThresholdInMegabytes = value;
        return this;
    }
    
    public DataStorePropertiesContainerBuilder setFrontendNoProgressTimeoutInSeconds(final NonZeroUint32Type value) {
        this._frontendNoProgressTimeoutInSeconds = value;
        return this;
    }
    
    public DataStorePropertiesContainerBuilder setFrontendRequestTimeoutInSeconds(final NonZeroUint32Type value) {
        this._frontendRequestTimeoutInSeconds = value;
        return this;
    }
    
    public DataStorePropertiesContainerBuilder setInitialPayloadSerializedBufferCapacity(final NonZeroUint32Type value) {
        this._initialPayloadSerializedBufferCapacity = value;
        return this;
    }
    
    public DataStorePropertiesContainerBuilder setMaxShardDataChangeExecutorPoolSize(final NonZeroUint32Type value) {
        this._maxShardDataChangeExecutorPoolSize = value;
        return this;
    }
    
    public DataStorePropertiesContainerBuilder setMaxShardDataChangeExecutorQueueSize(final NonZeroUint32Type value) {
        this._maxShardDataChangeExecutorQueueSize = value;
        return this;
    }
    
    public DataStorePropertiesContainerBuilder setMaxShardDataChangeListenerQueueSize(final NonZeroUint32Type value) {
        this._maxShardDataChangeListenerQueueSize = value;
        return this;
    }
    
    public DataStorePropertiesContainerBuilder setMaxShardDataStoreExecutorQueueSize(final NonZeroUint32Type value) {
        this._maxShardDataStoreExecutorQueueSize = value;
        return this;
    }
    
    public DataStorePropertiesContainerBuilder setMaximumMessageSliceSize(final NonZeroUint32Type value) {
        this._maximumMessageSliceSize = value;
        return this;
    }
    
    public DataStorePropertiesContainerBuilder setOperationTimeoutInSeconds(final OperationTimeoutType value) {
        this._operationTimeoutInSeconds = value;
        return this;
    }
    
    public DataStorePropertiesContainerBuilder setShardBatchedModificationCount(final NonZeroUint32Type value) {
        this._shardBatchedModificationCount = value;
        return this;
    }
    
    public DataStorePropertiesContainerBuilder setShardCommitQueueExpiryTimeoutInSeconds(final NonZeroUint32Type value) {
        this._shardCommitQueueExpiryTimeoutInSeconds = value;
        return this;
    }
    
    public DataStorePropertiesContainerBuilder setShardElectionTimeoutFactor(final NonZeroUint32Type value) {
        this._shardElectionTimeoutFactor = value;
        return this;
    }
    
    public DataStorePropertiesContainerBuilder setShardHeartbeatIntervalInMillis(final HeartbeatIntervalType value) {
        this._shardHeartbeatIntervalInMillis = value;
        return this;
    }
    
    public DataStorePropertiesContainerBuilder setShardInitializationTimeoutInSeconds(final NonZeroUint32Type value) {
        this._shardInitializationTimeoutInSeconds = value;
        return this;
    }
    
    public DataStorePropertiesContainerBuilder setShardIsolatedLeaderCheckIntervalInMillis(final HeartbeatIntervalType value) {
        this._shardIsolatedLeaderCheckIntervalInMillis = value;
        return this;
    }
    
    public DataStorePropertiesContainerBuilder setShardJournalRecoveryLogBatchSize(final NonZeroUint32Type value) {
        this._shardJournalRecoveryLogBatchSize = value;
        return this;
    }
    
    public DataStorePropertiesContainerBuilder setShardLeaderElectionTimeoutInSeconds(final NonZeroUint32Type value) {
        this._shardLeaderElectionTimeoutInSeconds = value;
        return this;
    }
    
    public DataStorePropertiesContainerBuilder setShardSnapshotBatchCount(final NonZeroUint32Type value) {
        this._shardSnapshotBatchCount = value;
        return this;
    }
    
    public DataStorePropertiesContainerBuilder setShardSnapshotChunkSize(final NonZeroUint32Type value) {
        this._shardSnapshotChunkSize = value;
        return this;
    }
    
    public DataStorePropertiesContainerBuilder setShardSnapshotDataThresholdPercentage(final Percentage value) {
        this._shardSnapshotDataThresholdPercentage = value;
        return this;
    }
    
    public DataStorePropertiesContainerBuilder setShardTransactionCommitQueueCapacity(final NonZeroUint32Type value) {
        this._shardTransactionCommitQueueCapacity = value;
        return this;
    }
    
    public DataStorePropertiesContainerBuilder setShardTransactionCommitTimeoutInSeconds(final NonZeroUint32Type value) {
        this._shardTransactionCommitTimeoutInSeconds = value;
        return this;
    }
    
    public DataStorePropertiesContainerBuilder setShardTransactionIdleTimeoutInMinutes(final NonZeroUint32Type value) {
        this._shardTransactionIdleTimeoutInMinutes = value;
        return this;
    }
    
    public DataStorePropertiesContainerBuilder setSyncIndexThreshold(final NonZeroUint32Type value) {
        this._syncIndexThreshold = value;
        return this;
    }
    
    public DataStorePropertiesContainerBuilder setTransactionCreationInitialRateLimit(final NonZeroUint32Type value) {
        this._transactionCreationInitialRateLimit = value;
        return this;
    }
    
    public DataStorePropertiesContainerBuilder setEnableMetricCapture(final Boolean value) {
        this._enableMetricCapture = value;
        return this;
    }
    
    public DataStorePropertiesContainerBuilder setPersistent(final Boolean value) {
        this._persistent = value;
        return this;
    }
    
    public DataStorePropertiesContainerBuilder setTransactionDebugContextEnabled(final Boolean value) {
        this._transactionDebugContextEnabled = value;
        return this;
    }
    
    public DataStorePropertiesContainerBuilder setUseTellBasedProtocol(final Boolean value) {
        this._useTellBasedProtocol = value;
        return this;
    }
    
    public DataStorePropertiesContainerBuilder addAugmentation(Class<? extends Augmentation<DataStorePropertiesContainer>> augmentationType, Augmentation<DataStorePropertiesContainer> augmentationValue) {
        if (augmentationValue == null) {
            return removeAugmentation(augmentationType);
        }
    
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }
    
    public DataStorePropertiesContainerBuilder removeAugmentation(Class<? extends Augmentation<DataStorePropertiesContainer>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public DataStorePropertiesContainer build() {
        return new DataStorePropertiesContainerImpl(this);
    }

    private static final class DataStorePropertiesContainerImpl
        extends AbstractAugmentable<DataStorePropertiesContainer>
        implements DataStorePropertiesContainer {
    
        private final NonZeroUint32Type _backendAlivenessTimerIntervalInSeconds;
        private final NonZeroUint32Type _boundedMailboxCapacity;
        private final String _customRaftPolicyImplementation;
        private final NonZeroUint32Type _fileBackedStreamingThresholdInMegabytes;
        private final NonZeroUint32Type _frontendNoProgressTimeoutInSeconds;
        private final NonZeroUint32Type _frontendRequestTimeoutInSeconds;
        private final NonZeroUint32Type _initialPayloadSerializedBufferCapacity;
        private final NonZeroUint32Type _maxShardDataChangeExecutorPoolSize;
        private final NonZeroUint32Type _maxShardDataChangeExecutorQueueSize;
        private final NonZeroUint32Type _maxShardDataChangeListenerQueueSize;
        private final NonZeroUint32Type _maxShardDataStoreExecutorQueueSize;
        private final NonZeroUint32Type _maximumMessageSliceSize;
        private final OperationTimeoutType _operationTimeoutInSeconds;
        private final NonZeroUint32Type _shardBatchedModificationCount;
        private final NonZeroUint32Type _shardCommitQueueExpiryTimeoutInSeconds;
        private final NonZeroUint32Type _shardElectionTimeoutFactor;
        private final HeartbeatIntervalType _shardHeartbeatIntervalInMillis;
        private final NonZeroUint32Type _shardInitializationTimeoutInSeconds;
        private final HeartbeatIntervalType _shardIsolatedLeaderCheckIntervalInMillis;
        private final NonZeroUint32Type _shardJournalRecoveryLogBatchSize;
        private final NonZeroUint32Type _shardLeaderElectionTimeoutInSeconds;
        private final NonZeroUint32Type _shardSnapshotBatchCount;
        private final NonZeroUint32Type _shardSnapshotChunkSize;
        private final Percentage _shardSnapshotDataThresholdPercentage;
        private final NonZeroUint32Type _shardTransactionCommitQueueCapacity;
        private final NonZeroUint32Type _shardTransactionCommitTimeoutInSeconds;
        private final NonZeroUint32Type _shardTransactionIdleTimeoutInMinutes;
        private final NonZeroUint32Type _syncIndexThreshold;
        private final NonZeroUint32Type _transactionCreationInitialRateLimit;
        private final Boolean _enableMetricCapture;
        private final Boolean _persistent;
        private final Boolean _transactionDebugContextEnabled;
        private final Boolean _useTellBasedProtocol;
    
        DataStorePropertiesContainerImpl(DataStorePropertiesContainerBuilder base) {
            super(base.augmentation);
            this._backendAlivenessTimerIntervalInSeconds = base.getBackendAlivenessTimerIntervalInSeconds();
            this._boundedMailboxCapacity = base.getBoundedMailboxCapacity();
            this._customRaftPolicyImplementation = base.getCustomRaftPolicyImplementation();
            this._fileBackedStreamingThresholdInMegabytes = base.getFileBackedStreamingThresholdInMegabytes();
            this._frontendNoProgressTimeoutInSeconds = base.getFrontendNoProgressTimeoutInSeconds();
            this._frontendRequestTimeoutInSeconds = base.getFrontendRequestTimeoutInSeconds();
            this._initialPayloadSerializedBufferCapacity = base.getInitialPayloadSerializedBufferCapacity();
            this._maxShardDataChangeExecutorPoolSize = base.getMaxShardDataChangeExecutorPoolSize();
            this._maxShardDataChangeExecutorQueueSize = base.getMaxShardDataChangeExecutorQueueSize();
            this._maxShardDataChangeListenerQueueSize = base.getMaxShardDataChangeListenerQueueSize();
            this._maxShardDataStoreExecutorQueueSize = base.getMaxShardDataStoreExecutorQueueSize();
            this._maximumMessageSliceSize = base.getMaximumMessageSliceSize();
            this._operationTimeoutInSeconds = base.getOperationTimeoutInSeconds();
            this._shardBatchedModificationCount = base.getShardBatchedModificationCount();
            this._shardCommitQueueExpiryTimeoutInSeconds = base.getShardCommitQueueExpiryTimeoutInSeconds();
            this._shardElectionTimeoutFactor = base.getShardElectionTimeoutFactor();
            this._shardHeartbeatIntervalInMillis = base.getShardHeartbeatIntervalInMillis();
            this._shardInitializationTimeoutInSeconds = base.getShardInitializationTimeoutInSeconds();
            this._shardIsolatedLeaderCheckIntervalInMillis = base.getShardIsolatedLeaderCheckIntervalInMillis();
            this._shardJournalRecoveryLogBatchSize = base.getShardJournalRecoveryLogBatchSize();
            this._shardLeaderElectionTimeoutInSeconds = base.getShardLeaderElectionTimeoutInSeconds();
            this._shardSnapshotBatchCount = base.getShardSnapshotBatchCount();
            this._shardSnapshotChunkSize = base.getShardSnapshotChunkSize();
            this._shardSnapshotDataThresholdPercentage = base.getShardSnapshotDataThresholdPercentage();
            this._shardTransactionCommitQueueCapacity = base.getShardTransactionCommitQueueCapacity();
            this._shardTransactionCommitTimeoutInSeconds = base.getShardTransactionCommitTimeoutInSeconds();
            this._shardTransactionIdleTimeoutInMinutes = base.getShardTransactionIdleTimeoutInMinutes();
            this._syncIndexThreshold = base.getSyncIndexThreshold();
            this._transactionCreationInitialRateLimit = base.getTransactionCreationInitialRateLimit();
            this._enableMetricCapture = base.isEnableMetricCapture();
            this._persistent = base.isPersistent();
            this._transactionDebugContextEnabled = base.isTransactionDebugContextEnabled();
            this._useTellBasedProtocol = base.isUseTellBasedProtocol();
        }
    
        @Override
        public Class<DataStorePropertiesContainer> getImplementedInterface() {
            return DataStorePropertiesContainer.class;
        }
    
        @Override
        public NonZeroUint32Type getBackendAlivenessTimerIntervalInSeconds() {
            return _backendAlivenessTimerIntervalInSeconds;
        }
        
        @Override
        public NonZeroUint32Type getBoundedMailboxCapacity() {
            return _boundedMailboxCapacity;
        }
        
        @Override
        public String getCustomRaftPolicyImplementation() {
            return _customRaftPolicyImplementation;
        }
        
        @Override
        public NonZeroUint32Type getFileBackedStreamingThresholdInMegabytes() {
            return _fileBackedStreamingThresholdInMegabytes;
        }
        
        @Override
        public NonZeroUint32Type getFrontendNoProgressTimeoutInSeconds() {
            return _frontendNoProgressTimeoutInSeconds;
        }
        
        @Override
        public NonZeroUint32Type getFrontendRequestTimeoutInSeconds() {
            return _frontendRequestTimeoutInSeconds;
        }
        
        @Override
        public NonZeroUint32Type getInitialPayloadSerializedBufferCapacity() {
            return _initialPayloadSerializedBufferCapacity;
        }
        
        @Override
        public NonZeroUint32Type getMaxShardDataChangeExecutorPoolSize() {
            return _maxShardDataChangeExecutorPoolSize;
        }
        
        @Override
        public NonZeroUint32Type getMaxShardDataChangeExecutorQueueSize() {
            return _maxShardDataChangeExecutorQueueSize;
        }
        
        @Override
        public NonZeroUint32Type getMaxShardDataChangeListenerQueueSize() {
            return _maxShardDataChangeListenerQueueSize;
        }
        
        @Override
        public NonZeroUint32Type getMaxShardDataStoreExecutorQueueSize() {
            return _maxShardDataStoreExecutorQueueSize;
        }
        
        @Override
        public NonZeroUint32Type getMaximumMessageSliceSize() {
            return _maximumMessageSliceSize;
        }
        
        @Override
        public OperationTimeoutType getOperationTimeoutInSeconds() {
            return _operationTimeoutInSeconds;
        }
        
        @Override
        public NonZeroUint32Type getShardBatchedModificationCount() {
            return _shardBatchedModificationCount;
        }
        
        @Override
        public NonZeroUint32Type getShardCommitQueueExpiryTimeoutInSeconds() {
            return _shardCommitQueueExpiryTimeoutInSeconds;
        }
        
        @Override
        public NonZeroUint32Type getShardElectionTimeoutFactor() {
            return _shardElectionTimeoutFactor;
        }
        
        @Override
        public HeartbeatIntervalType getShardHeartbeatIntervalInMillis() {
            return _shardHeartbeatIntervalInMillis;
        }
        
        @Override
        public NonZeroUint32Type getShardInitializationTimeoutInSeconds() {
            return _shardInitializationTimeoutInSeconds;
        }
        
        @Override
        public HeartbeatIntervalType getShardIsolatedLeaderCheckIntervalInMillis() {
            return _shardIsolatedLeaderCheckIntervalInMillis;
        }
        
        @Override
        public NonZeroUint32Type getShardJournalRecoveryLogBatchSize() {
            return _shardJournalRecoveryLogBatchSize;
        }
        
        @Override
        public NonZeroUint32Type getShardLeaderElectionTimeoutInSeconds() {
            return _shardLeaderElectionTimeoutInSeconds;
        }
        
        @Override
        public NonZeroUint32Type getShardSnapshotBatchCount() {
            return _shardSnapshotBatchCount;
        }
        
        @Override
        public NonZeroUint32Type getShardSnapshotChunkSize() {
            return _shardSnapshotChunkSize;
        }
        
        @Override
        public Percentage getShardSnapshotDataThresholdPercentage() {
            return _shardSnapshotDataThresholdPercentage;
        }
        
        @Override
        public NonZeroUint32Type getShardTransactionCommitQueueCapacity() {
            return _shardTransactionCommitQueueCapacity;
        }
        
        @Override
        public NonZeroUint32Type getShardTransactionCommitTimeoutInSeconds() {
            return _shardTransactionCommitTimeoutInSeconds;
        }
        
        @Override
        public NonZeroUint32Type getShardTransactionIdleTimeoutInMinutes() {
            return _shardTransactionIdleTimeoutInMinutes;
        }
        
        @Override
        public NonZeroUint32Type getSyncIndexThreshold() {
            return _syncIndexThreshold;
        }
        
        @Override
        public NonZeroUint32Type getTransactionCreationInitialRateLimit() {
            return _transactionCreationInitialRateLimit;
        }
        
        @Override
        public Boolean isEnableMetricCapture() {
            return _enableMetricCapture;
        }
        
        @Override
        public Boolean isPersistent() {
            return _persistent;
        }
        
        @Override
        public Boolean isTransactionDebugContextEnabled() {
            return _transactionDebugContextEnabled;
        }
        
        @Override
        public Boolean isUseTellBasedProtocol() {
            return _useTellBasedProtocol;
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int prime = 31;
            int result = 1;
            result = prime * result + Objects.hashCode(_backendAlivenessTimerIntervalInSeconds);
            result = prime * result + Objects.hashCode(_boundedMailboxCapacity);
            result = prime * result + Objects.hashCode(_customRaftPolicyImplementation);
            result = prime * result + Objects.hashCode(_fileBackedStreamingThresholdInMegabytes);
            result = prime * result + Objects.hashCode(_frontendNoProgressTimeoutInSeconds);
            result = prime * result + Objects.hashCode(_frontendRequestTimeoutInSeconds);
            result = prime * result + Objects.hashCode(_initialPayloadSerializedBufferCapacity);
            result = prime * result + Objects.hashCode(_maxShardDataChangeExecutorPoolSize);
            result = prime * result + Objects.hashCode(_maxShardDataChangeExecutorQueueSize);
            result = prime * result + Objects.hashCode(_maxShardDataChangeListenerQueueSize);
            result = prime * result + Objects.hashCode(_maxShardDataStoreExecutorQueueSize);
            result = prime * result + Objects.hashCode(_maximumMessageSliceSize);
            result = prime * result + Objects.hashCode(_operationTimeoutInSeconds);
            result = prime * result + Objects.hashCode(_shardBatchedModificationCount);
            result = prime * result + Objects.hashCode(_shardCommitQueueExpiryTimeoutInSeconds);
            result = prime * result + Objects.hashCode(_shardElectionTimeoutFactor);
            result = prime * result + Objects.hashCode(_shardHeartbeatIntervalInMillis);
            result = prime * result + Objects.hashCode(_shardInitializationTimeoutInSeconds);
            result = prime * result + Objects.hashCode(_shardIsolatedLeaderCheckIntervalInMillis);
            result = prime * result + Objects.hashCode(_shardJournalRecoveryLogBatchSize);
            result = prime * result + Objects.hashCode(_shardLeaderElectionTimeoutInSeconds);
            result = prime * result + Objects.hashCode(_shardSnapshotBatchCount);
            result = prime * result + Objects.hashCode(_shardSnapshotChunkSize);
            result = prime * result + Objects.hashCode(_shardSnapshotDataThresholdPercentage);
            result = prime * result + Objects.hashCode(_shardTransactionCommitQueueCapacity);
            result = prime * result + Objects.hashCode(_shardTransactionCommitTimeoutInSeconds);
            result = prime * result + Objects.hashCode(_shardTransactionIdleTimeoutInMinutes);
            result = prime * result + Objects.hashCode(_syncIndexThreshold);
            result = prime * result + Objects.hashCode(_transactionCreationInitialRateLimit);
            result = prime * result + Objects.hashCode(_enableMetricCapture);
            result = prime * result + Objects.hashCode(_persistent);
            result = prime * result + Objects.hashCode(_transactionDebugContextEnabled);
            result = prime * result + Objects.hashCode(_useTellBasedProtocol);
            result = prime * result + Objects.hashCode(augmentations());
        
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!DataStorePropertiesContainer.class.equals(((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            DataStorePropertiesContainer other = (DataStorePropertiesContainer)obj;
            if (!Objects.equals(_backendAlivenessTimerIntervalInSeconds, other.getBackendAlivenessTimerIntervalInSeconds())) {
                return false;
            }
            if (!Objects.equals(_boundedMailboxCapacity, other.getBoundedMailboxCapacity())) {
                return false;
            }
            if (!Objects.equals(_customRaftPolicyImplementation, other.getCustomRaftPolicyImplementation())) {
                return false;
            }
            if (!Objects.equals(_fileBackedStreamingThresholdInMegabytes, other.getFileBackedStreamingThresholdInMegabytes())) {
                return false;
            }
            if (!Objects.equals(_frontendNoProgressTimeoutInSeconds, other.getFrontendNoProgressTimeoutInSeconds())) {
                return false;
            }
            if (!Objects.equals(_frontendRequestTimeoutInSeconds, other.getFrontendRequestTimeoutInSeconds())) {
                return false;
            }
            if (!Objects.equals(_initialPayloadSerializedBufferCapacity, other.getInitialPayloadSerializedBufferCapacity())) {
                return false;
            }
            if (!Objects.equals(_maxShardDataChangeExecutorPoolSize, other.getMaxShardDataChangeExecutorPoolSize())) {
                return false;
            }
            if (!Objects.equals(_maxShardDataChangeExecutorQueueSize, other.getMaxShardDataChangeExecutorQueueSize())) {
                return false;
            }
            if (!Objects.equals(_maxShardDataChangeListenerQueueSize, other.getMaxShardDataChangeListenerQueueSize())) {
                return false;
            }
            if (!Objects.equals(_maxShardDataStoreExecutorQueueSize, other.getMaxShardDataStoreExecutorQueueSize())) {
                return false;
            }
            if (!Objects.equals(_maximumMessageSliceSize, other.getMaximumMessageSliceSize())) {
                return false;
            }
            if (!Objects.equals(_operationTimeoutInSeconds, other.getOperationTimeoutInSeconds())) {
                return false;
            }
            if (!Objects.equals(_shardBatchedModificationCount, other.getShardBatchedModificationCount())) {
                return false;
            }
            if (!Objects.equals(_shardCommitQueueExpiryTimeoutInSeconds, other.getShardCommitQueueExpiryTimeoutInSeconds())) {
                return false;
            }
            if (!Objects.equals(_shardElectionTimeoutFactor, other.getShardElectionTimeoutFactor())) {
                return false;
            }
            if (!Objects.equals(_shardHeartbeatIntervalInMillis, other.getShardHeartbeatIntervalInMillis())) {
                return false;
            }
            if (!Objects.equals(_shardInitializationTimeoutInSeconds, other.getShardInitializationTimeoutInSeconds())) {
                return false;
            }
            if (!Objects.equals(_shardIsolatedLeaderCheckIntervalInMillis, other.getShardIsolatedLeaderCheckIntervalInMillis())) {
                return false;
            }
            if (!Objects.equals(_shardJournalRecoveryLogBatchSize, other.getShardJournalRecoveryLogBatchSize())) {
                return false;
            }
            if (!Objects.equals(_shardLeaderElectionTimeoutInSeconds, other.getShardLeaderElectionTimeoutInSeconds())) {
                return false;
            }
            if (!Objects.equals(_shardSnapshotBatchCount, other.getShardSnapshotBatchCount())) {
                return false;
            }
            if (!Objects.equals(_shardSnapshotChunkSize, other.getShardSnapshotChunkSize())) {
                return false;
            }
            if (!Objects.equals(_shardSnapshotDataThresholdPercentage, other.getShardSnapshotDataThresholdPercentage())) {
                return false;
            }
            if (!Objects.equals(_shardTransactionCommitQueueCapacity, other.getShardTransactionCommitQueueCapacity())) {
                return false;
            }
            if (!Objects.equals(_shardTransactionCommitTimeoutInSeconds, other.getShardTransactionCommitTimeoutInSeconds())) {
                return false;
            }
            if (!Objects.equals(_shardTransactionIdleTimeoutInMinutes, other.getShardTransactionIdleTimeoutInMinutes())) {
                return false;
            }
            if (!Objects.equals(_syncIndexThreshold, other.getSyncIndexThreshold())) {
                return false;
            }
            if (!Objects.equals(_transactionCreationInitialRateLimit, other.getTransactionCreationInitialRateLimit())) {
                return false;
            }
            if (!Objects.equals(_enableMetricCapture, other.isEnableMetricCapture())) {
                return false;
            }
            if (!Objects.equals(_persistent, other.isPersistent())) {
                return false;
            }
            if (!Objects.equals(_transactionDebugContextEnabled, other.isTransactionDebugContextEnabled())) {
                return false;
            }
            if (!Objects.equals(_useTellBasedProtocol, other.isUseTellBasedProtocol())) {
                return false;
            }
            if (getClass() == obj.getClass()) {
                // Simple case: we are comparing against self
                DataStorePropertiesContainerImpl otherImpl = (DataStorePropertiesContainerImpl) obj;
                if (!Objects.equals(augmentations(), otherImpl.augmentations())) {
                    return false;
                }
            } else {
                // Hard case: compare our augments with presence there...
                for (Map.Entry<Class<? extends Augmentation<DataStorePropertiesContainer>>, Augmentation<DataStorePropertiesContainer>> e : augmentations().entrySet()) {
                    if (!e.getValue().equals(other.augmentation(e.getKey()))) {
                        return false;
                    }
                }
                // .. and give the other one the chance to do the same
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }
    
        @Override
        public String toString() {
            final MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper("DataStorePropertiesContainer");
            CodeHelpers.appendValue(helper, "_backendAlivenessTimerIntervalInSeconds", _backendAlivenessTimerIntervalInSeconds);
            CodeHelpers.appendValue(helper, "_boundedMailboxCapacity", _boundedMailboxCapacity);
            CodeHelpers.appendValue(helper, "_customRaftPolicyImplementation", _customRaftPolicyImplementation);
            CodeHelpers.appendValue(helper, "_fileBackedStreamingThresholdInMegabytes", _fileBackedStreamingThresholdInMegabytes);
            CodeHelpers.appendValue(helper, "_frontendNoProgressTimeoutInSeconds", _frontendNoProgressTimeoutInSeconds);
            CodeHelpers.appendValue(helper, "_frontendRequestTimeoutInSeconds", _frontendRequestTimeoutInSeconds);
            CodeHelpers.appendValue(helper, "_initialPayloadSerializedBufferCapacity", _initialPayloadSerializedBufferCapacity);
            CodeHelpers.appendValue(helper, "_maxShardDataChangeExecutorPoolSize", _maxShardDataChangeExecutorPoolSize);
            CodeHelpers.appendValue(helper, "_maxShardDataChangeExecutorQueueSize", _maxShardDataChangeExecutorQueueSize);
            CodeHelpers.appendValue(helper, "_maxShardDataChangeListenerQueueSize", _maxShardDataChangeListenerQueueSize);
            CodeHelpers.appendValue(helper, "_maxShardDataStoreExecutorQueueSize", _maxShardDataStoreExecutorQueueSize);
            CodeHelpers.appendValue(helper, "_maximumMessageSliceSize", _maximumMessageSliceSize);
            CodeHelpers.appendValue(helper, "_operationTimeoutInSeconds", _operationTimeoutInSeconds);
            CodeHelpers.appendValue(helper, "_shardBatchedModificationCount", _shardBatchedModificationCount);
            CodeHelpers.appendValue(helper, "_shardCommitQueueExpiryTimeoutInSeconds", _shardCommitQueueExpiryTimeoutInSeconds);
            CodeHelpers.appendValue(helper, "_shardElectionTimeoutFactor", _shardElectionTimeoutFactor);
            CodeHelpers.appendValue(helper, "_shardHeartbeatIntervalInMillis", _shardHeartbeatIntervalInMillis);
            CodeHelpers.appendValue(helper, "_shardInitializationTimeoutInSeconds", _shardInitializationTimeoutInSeconds);
            CodeHelpers.appendValue(helper, "_shardIsolatedLeaderCheckIntervalInMillis", _shardIsolatedLeaderCheckIntervalInMillis);
            CodeHelpers.appendValue(helper, "_shardJournalRecoveryLogBatchSize", _shardJournalRecoveryLogBatchSize);
            CodeHelpers.appendValue(helper, "_shardLeaderElectionTimeoutInSeconds", _shardLeaderElectionTimeoutInSeconds);
            CodeHelpers.appendValue(helper, "_shardSnapshotBatchCount", _shardSnapshotBatchCount);
            CodeHelpers.appendValue(helper, "_shardSnapshotChunkSize", _shardSnapshotChunkSize);
            CodeHelpers.appendValue(helper, "_shardSnapshotDataThresholdPercentage", _shardSnapshotDataThresholdPercentage);
            CodeHelpers.appendValue(helper, "_shardTransactionCommitQueueCapacity", _shardTransactionCommitQueueCapacity);
            CodeHelpers.appendValue(helper, "_shardTransactionCommitTimeoutInSeconds", _shardTransactionCommitTimeoutInSeconds);
            CodeHelpers.appendValue(helper, "_shardTransactionIdleTimeoutInMinutes", _shardTransactionIdleTimeoutInMinutes);
            CodeHelpers.appendValue(helper, "_syncIndexThreshold", _syncIndexThreshold);
            CodeHelpers.appendValue(helper, "_transactionCreationInitialRateLimit", _transactionCreationInitialRateLimit);
            CodeHelpers.appendValue(helper, "_enableMetricCapture", _enableMetricCapture);
            CodeHelpers.appendValue(helper, "_persistent", _persistent);
            CodeHelpers.appendValue(helper, "_transactionDebugContextEnabled", _transactionDebugContextEnabled);
            CodeHelpers.appendValue(helper, "_useTellBasedProtocol", _useTellBasedProtocol);
            CodeHelpers.appendValue(helper, "augmentation", augmentations().values());
            return helper.toString();
        }
    }
}
