package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.distributed.datastore.provider.rev140612;
import com.google.common.base.MoreObjects;
import java.beans.ConstructorProperties;
import java.io.Serializable;
import java.lang.Long;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.TypeObject;

public class NonZeroUint32Type
 implements TypeObject, Serializable {
    private static final long serialVersionUID = -7519597503656647670L;
    private final Long _value;

    private static void check_valueRange(final long value) {
        if (value >= 1L && value <= 4294967295L) {
            return;
        }
        CodeHelpers.throwInvalidRange("[[1..4294967295]]", value);
    }

    @ConstructorProperties("value")
    public NonZeroUint32Type(Long _value) {
        if (_value != null) {
            check_valueRange(_value);
        }
    
        Objects.requireNonNull(_value, "Supplied value may not be null");
    
        this._value = _value;
    }
    
    /**
     * Creates a copy from Source Object.
     *
     * @param source Source object
     */
    public NonZeroUint32Type(NonZeroUint32Type source) {
        this._value = source._value;
    }

    public static NonZeroUint32Type getDefaultInstance(String defaultValue) {
        return new NonZeroUint32Type(Long.valueOf(defaultValue));
    }

    public Long getValue() {
        return _value;
    }


    @Override
    public int hashCode() {
        return CodeHelpers.wrapperHashCode(_value);
    }

    @Override
    public boolean equals(java.lang.Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (getClass() != obj.getClass()) {
            return false;
        }
        NonZeroUint32Type other = (NonZeroUint32Type) obj;
        if (!Objects.equals(_value, other._value)) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        final MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper(NonZeroUint32Type.class);
        CodeHelpers.appendValue(helper, "_value", _value);
        return helper.toString();
    }
}

