package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.distributed.datastore.provider.rev140612;
import com.google.common.base.MoreObjects;
import java.beans.ConstructorProperties;
import java.io.Serializable;
import java.lang.Integer;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.TypeObject;

public class OperationTimeoutType
 implements TypeObject, Serializable {
    private static final long serialVersionUID = -8895242571909692994L;
    private final Integer _value;

    private static void check_valueRange(final int value) {
        if (value >= 5 && value <= 65535) {
            return;
        }
        CodeHelpers.throwInvalidRange("[[5..65535]]", value);
    }

    @ConstructorProperties("value")
    public OperationTimeoutType(Integer _value) {
        if (_value != null) {
            check_valueRange(_value);
        }
    
        Objects.requireNonNull(_value, "Supplied value may not be null");
    
        this._value = _value;
    }
    
    /**
     * Creates a copy from Source Object.
     *
     * @param source Source object
     */
    public OperationTimeoutType(OperationTimeoutType source) {
        this._value = source._value;
    }

    public static OperationTimeoutType getDefaultInstance(String defaultValue) {
        return new OperationTimeoutType(Integer.valueOf(defaultValue));
    }

    public Integer getValue() {
        return _value;
    }


    @Override
    public int hashCode() {
        return CodeHelpers.wrapperHashCode(_value);
    }

    @Override
    public boolean equals(java.lang.Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (getClass() != obj.getClass()) {
            return false;
        }
        OperationTimeoutType other = (OperationTimeoutType) obj;
        if (!Objects.equals(_value, other._value)) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        final MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper(OperationTimeoutType.class);
        CodeHelpers.appendValue(helper, "_value", _value);
        return helper.toString();
    }
}

