package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.clustering.entity.owners.rev150804;
import com.google.common.base.MoreObjects;
import java.lang.Class;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.clustering.entity.owners.rev150804.entity.owners.EntityType;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

/**
 * Class that builds {@link EntityOwnersBuilder} instances.
 *
 * @see EntityOwnersBuilder
 *
 */
public class EntityOwnersBuilder implements Builder<EntityOwners> {

    private List<EntityType> _entityType;


    Map<Class<? extends Augmentation<EntityOwners>>, Augmentation<EntityOwners>> augmentation = Collections.emptyMap();

    public EntityOwnersBuilder() {
    }

    public EntityOwnersBuilder(EntityOwners base) {
        if (base instanceof AugmentationHolder) {
            @SuppressWarnings("unchecked")
            Map<Class<? extends Augmentation<EntityOwners>>, Augmentation<EntityOwners>> aug =((AugmentationHolder<EntityOwners>) base).augmentations();
            if (!aug.isEmpty()) {
                this.augmentation = new HashMap<>(aug);
            }
        }
        this._entityType = base.getEntityType();
    }


    public List<EntityType> getEntityType() {
        return _entityType;
    }

    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<EntityOwners>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(CodeHelpers.nonNullValue(augmentationType, "augmentationType"));
    }

    public EntityOwnersBuilder setEntityType(final List<EntityType> values) {
        this._entityType = values;
        return this;
    }
    
    
    public EntityOwnersBuilder addAugmentation(Class<? extends Augmentation<EntityOwners>> augmentationType, Augmentation<EntityOwners> augmentationValue) {
        if (augmentationValue == null) {
            return removeAugmentation(augmentationType);
        }
    
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }
    
    public EntityOwnersBuilder removeAugmentation(Class<? extends Augmentation<EntityOwners>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public EntityOwners build() {
        return new EntityOwnersImpl(this);
    }

    private static final class EntityOwnersImpl
        extends AbstractAugmentable<EntityOwners>
        implements EntityOwners {
    
        private final List<EntityType> _entityType;
    
        EntityOwnersImpl(EntityOwnersBuilder base) {
            super(base.augmentation);
            this._entityType = base.getEntityType();
        }
    
        @Override
        public Class<EntityOwners> getImplementedInterface() {
            return EntityOwners.class;
        }
    
        @Override
        public List<EntityType> getEntityType() {
            return _entityType;
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int prime = 31;
            int result = 1;
            result = prime * result + Objects.hashCode(_entityType);
            result = prime * result + Objects.hashCode(augmentations());
        
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!EntityOwners.class.equals(((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            EntityOwners other = (EntityOwners)obj;
            if (!Objects.equals(_entityType, other.getEntityType())) {
                return false;
            }
            if (getClass() == obj.getClass()) {
                // Simple case: we are comparing against self
                EntityOwnersImpl otherImpl = (EntityOwnersImpl) obj;
                if (!Objects.equals(augmentations(), otherImpl.augmentations())) {
                    return false;
                }
            } else {
                // Hard case: compare our augments with presence there...
                for (Map.Entry<Class<? extends Augmentation<EntityOwners>>, Augmentation<EntityOwners>> e : augmentations().entrySet()) {
                    if (!e.getValue().equals(other.augmentation(e.getKey()))) {
                        return false;
                    }
                }
                // .. and give the other one the chance to do the same
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }
    
        @Override
        public String toString() {
            final MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper("EntityOwners");
            CodeHelpers.appendValue(helper, "_entityType", _entityType);
            CodeHelpers.appendValue(helper, "augmentation", augmentations().values());
            return helper.toString();
        }
    }
}
