package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.clustering.entity.owners.rev150804.entity.owners;
import java.lang.Override;
import java.lang.String;
import java.util.List;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.clustering.entity.owners.rev150804.$YangModuleInfoImpl;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.clustering.entity.owners.rev150804.EntityOwners;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.clustering.entity.owners.rev150804.entity.owners.entity.type.Entity;
import org.opendaylight.yangtools.yang.binding.Augmentable;
import org.opendaylight.yangtools.yang.binding.ChildOf;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.Identifiable;
import org.opendaylight.yangtools.yang.common.QName;

/**
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>entity-owners</b>
 * <pre>
 * list entity-type {
 *   key type;
 *   leaf type {
 *     type string;
 *   }
 *   list entity {
 *     key id;
 *     leaf id {
 *       type instance-identifier;
 *     }
 *     leaf owner {
 *       type string;
 *     }
 *     list candidate {
 *       key name;
 *       ordered-by user;
 *       leaf name {
 *         type string;
 *       }
 *     }
 *   }
 * }
 * </pre>The schema path to identify an instance is
 * <i>entity-owners/entity-owners/entity-type</i>
 *
 * <p>To create instances of this class use {@link EntityTypeBuilder}.
 * @see EntityTypeBuilder
 * @see EntityTypeKey
 *
 */
public interface EntityType
    extends
    ChildOf<EntityOwners>,
    Augmentable<EntityType>,
    Identifiable<EntityTypeKey>
{



    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("entity-type");

    /**
     * @return <code>java.lang.String</code> <code>type</code>, or <code>null</code> if not present
     */
    @Nullable String getType();
    
    /**
     * @return <code>java.util.List</code> <code>entity</code>, or <code>null</code> if not present
     */
    @Nullable List<Entity> getEntity();
    
    /**
     * @return <code>java.util.List</code> <code>entity</code>, or an empty list if it is not present
     */
    default @NonNull List<Entity> nonnullEntity() {
        return CodeHelpers.nonnull(getEntity());
    }
    
    @Override
    EntityTypeKey key();

}

