package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.clustering.prefix.shard.configuration.rev170110;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yangtools.yang.binding.DataRoot;

/**
 * This module contains the base YANG definitions for shards based on prefix 
 * configuration
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>prefix-shard-configuration</b>
 * <pre>
 * module prefix-shard-configuration {
 *   yang-version 1;
 *   namespace urn:opendaylight:params:xml:ns:yang:controller:md:sal:clustering:prefix-shard-configuration;
 *   prefix prefix-config;
 *   revision 2017-01-10 {
 *   }
 *   container prefix-shards {
 *     list shard {
 *       key prefix;
 *       leaf prefix {
 *         type instance-identifier;
 *       }
 *       container replicas {
 *         leaf-list replica {
 *           type string;
 *         }
 *       }
 *     }
 *   }
 * }
 * </pre>
 *
 */
public interface PrefixShardConfigurationData
    extends
    DataRoot
{




    /**
     * @return <code>org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.clustering.prefix.shard.configuration.rev170110.PrefixShards</code> <code>prefixShards</code>, or <code>null</code> if not present
     */
    @Nullable PrefixShards getPrefixShards();

}

