package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.clustering.prefix.shard.configuration.rev170110;
import java.util.List;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.clustering.prefix.shard.configuration.rev170110.prefix.shards.Shard;
import org.opendaylight.yangtools.yang.binding.Augmentable;
import org.opendaylight.yangtools.yang.binding.ChildOf;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.common.QName;

/**
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>prefix-shard-configuration</b>
 * <pre>
 * container prefix-shards {
 *   list shard {
 *     key prefix;
 *     leaf prefix {
 *       type instance-identifier;
 *     }
 *     container replicas {
 *       leaf-list replica {
 *         type string;
 *       }
 *     }
 *   }
 * }
 * </pre>The schema path to identify an instance is
 * <i>prefix-shard-configuration/prefix-shards</i>
 *
 * <p>To create instances of this class use {@link PrefixShardsBuilder}.
 * @see PrefixShardsBuilder
 *
 */
public interface PrefixShards
    extends
    ChildOf<PrefixShardConfigurationData>,
    Augmentable<PrefixShards>
{



    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("prefix-shards");

    /**
     * List of prefix-based shards configured.
     *
     *
     *
     * @return <code>java.util.List</code> <code>shard</code>, or <code>null</code> if not present
     */
    @Nullable List<Shard> getShard();
    
    /**
     * @return <code>java.util.List</code> <code>shard</code>, or an empty list if it is not present
     */
    default @NonNull List<Shard> nonnullShard() {
        return CodeHelpers.nonnull(getShard());
    }

}

