package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.clustering.prefix.shard.configuration.rev170110;
import com.google.common.base.MoreObjects;
import java.lang.Class;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.clustering.prefix.shard.configuration.rev170110.prefix.shards.Shard;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

/**
 * Class that builds {@link PrefixShardsBuilder} instances.
 *
 * @see PrefixShardsBuilder
 *
 */
public class PrefixShardsBuilder implements Builder<PrefixShards> {

    private List<Shard> _shard;


    Map<Class<? extends Augmentation<PrefixShards>>, Augmentation<PrefixShards>> augmentation = Collections.emptyMap();

    public PrefixShardsBuilder() {
    }

    public PrefixShardsBuilder(PrefixShards base) {
        if (base instanceof AugmentationHolder) {
            @SuppressWarnings("unchecked")
            Map<Class<? extends Augmentation<PrefixShards>>, Augmentation<PrefixShards>> aug =((AugmentationHolder<PrefixShards>) base).augmentations();
            if (!aug.isEmpty()) {
                this.augmentation = new HashMap<>(aug);
            }
        }
        this._shard = base.getShard();
    }


    public List<Shard> getShard() {
        return _shard;
    }

    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<PrefixShards>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(CodeHelpers.nonNullValue(augmentationType, "augmentationType"));
    }

    public PrefixShardsBuilder setShard(final List<Shard> values) {
        this._shard = values;
        return this;
    }
    
    
    public PrefixShardsBuilder addAugmentation(Class<? extends Augmentation<PrefixShards>> augmentationType, Augmentation<PrefixShards> augmentationValue) {
        if (augmentationValue == null) {
            return removeAugmentation(augmentationType);
        }
    
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }
    
    public PrefixShardsBuilder removeAugmentation(Class<? extends Augmentation<PrefixShards>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public PrefixShards build() {
        return new PrefixShardsImpl(this);
    }

    private static final class PrefixShardsImpl
        extends AbstractAugmentable<PrefixShards>
        implements PrefixShards {
    
        private final List<Shard> _shard;
    
        PrefixShardsImpl(PrefixShardsBuilder base) {
            super(base.augmentation);
            this._shard = base.getShard();
        }
    
        @Override
        public Class<PrefixShards> getImplementedInterface() {
            return PrefixShards.class;
        }
    
        @Override
        public List<Shard> getShard() {
            return _shard;
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int prime = 31;
            int result = 1;
            result = prime * result + Objects.hashCode(_shard);
            result = prime * result + Objects.hashCode(augmentations());
        
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!PrefixShards.class.equals(((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            PrefixShards other = (PrefixShards)obj;
            if (!Objects.equals(_shard, other.getShard())) {
                return false;
            }
            if (getClass() == obj.getClass()) {
                // Simple case: we are comparing against self
                PrefixShardsImpl otherImpl = (PrefixShardsImpl) obj;
                if (!Objects.equals(augmentations(), otherImpl.augmentations())) {
                    return false;
                }
            } else {
                // Hard case: compare our augments with presence there...
                for (Map.Entry<Class<? extends Augmentation<PrefixShards>>, Augmentation<PrefixShards>> e : augmentations().entrySet()) {
                    if (!e.getValue().equals(other.augmentation(e.getKey()))) {
                        return false;
                    }
                }
                // .. and give the other one the chance to do the same
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }
    
        @Override
        public String toString() {
            final MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper("PrefixShards");
            CodeHelpers.appendValue(helper, "_shard", _shard);
            CodeHelpers.appendValue(helper, "augmentation", augmentations().values());
            return helper.toString();
        }
    }
}
