package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.clustering.prefix.shard.configuration.rev170110.prefix.shards;
import java.lang.Override;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.clustering.prefix.shard.configuration.rev170110.$YangModuleInfoImpl;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.clustering.prefix.shard.configuration.rev170110.PrefixShards;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.clustering.prefix.shard.configuration.rev170110.prefix.shards.shard.Replicas;
import org.opendaylight.yangtools.yang.binding.Augmentable;
import org.opendaylight.yangtools.yang.binding.ChildOf;
import org.opendaylight.yangtools.yang.binding.Identifiable;
import org.opendaylight.yangtools.yang.binding.InstanceIdentifier;
import org.opendaylight.yangtools.yang.common.QName;

/**
 * List of prefix-based shards configured.
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>prefix-shard-configuration</b>
 * <pre>
 * list shard {
 *   key prefix;
 *   leaf prefix {
 *     type instance-identifier;
 *   }
 *   container replicas {
 *     leaf-list replica {
 *       type string;
 *     }
 *   }
 * }
 * </pre>The schema path to identify an instance is
 * <i>prefix-shard-configuration/prefix-shards/shard</i>
 *
 * <p>To create instances of this class use {@link ShardBuilder}.
 * @see ShardBuilder
 * @see ShardKey
 *
 */
public interface Shard
    extends
    ChildOf<PrefixShards>,
    Augmentable<Shard>,
    Identifiable<ShardKey>
{



    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("shard");

    /**
     * Prefix that this shard is rooted at.
     *
     *
     *
     * @return <code>org.opendaylight.yangtools.yang.binding.InstanceIdentifier</code> <code>prefix</code>, or <code>null</code> if not present
     */
    @Nullable InstanceIdentifier<?> getPrefix();
    
    /**
     * List of cluster member nodes that this shard is replicated on
     *
     *
     *
     * @return <code>org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.clustering.prefix.shard.configuration.rev170110.prefix.shards.shard.Replicas</code> <code>replicas</code>, or <code>null</code> if not present
     */
    @Nullable Replicas getReplicas();
    
    @Override
    ShardKey key();

}

