package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.clustering.prefix.shard.configuration.rev170110.prefix.shards;
import com.google.common.base.MoreObjects;
import java.lang.Class;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.clustering.prefix.shard.configuration.rev170110.prefix.shards.shard.Replicas;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.binding.InstanceIdentifier;

/**
 * Class that builds {@link ShardBuilder} instances.
 *
 * @see ShardBuilder
 *
 */
public class ShardBuilder implements Builder<Shard> {

    private InstanceIdentifier<?> _prefix;
    private Replicas _replicas;
    private ShardKey key;


    Map<Class<? extends Augmentation<Shard>>, Augmentation<Shard>> augmentation = Collections.emptyMap();

    public ShardBuilder() {
    }

    public ShardBuilder(Shard base) {
        if (base instanceof AugmentationHolder) {
            @SuppressWarnings("unchecked")
            Map<Class<? extends Augmentation<Shard>>, Augmentation<Shard>> aug =((AugmentationHolder<Shard>) base).augmentations();
            if (!aug.isEmpty()) {
                this.augmentation = new HashMap<>(aug);
            }
        }
        this.key = base.key();
        this._prefix = base.getPrefix();
        this._replicas = base.getReplicas();
    }


    public ShardKey key() {
        return key;
    }
    
    public InstanceIdentifier<?> getPrefix() {
        return _prefix;
    }
    
    public Replicas getReplicas() {
        return _replicas;
    }

    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<Shard>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(CodeHelpers.nonNullValue(augmentationType, "augmentationType"));
    }

    public ShardBuilder withKey(final ShardKey key) {
        this.key = key;
        return this;
    }
    
    public ShardBuilder setPrefix(final InstanceIdentifier<?> value) {
        this._prefix = value;
        return this;
    }
    
    public ShardBuilder setReplicas(final Replicas value) {
        this._replicas = value;
        return this;
    }
    
    public ShardBuilder addAugmentation(Class<? extends Augmentation<Shard>> augmentationType, Augmentation<Shard> augmentationValue) {
        if (augmentationValue == null) {
            return removeAugmentation(augmentationType);
        }
    
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }
    
    public ShardBuilder removeAugmentation(Class<? extends Augmentation<Shard>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public Shard build() {
        return new ShardImpl(this);
    }

    private static final class ShardImpl
        extends AbstractAugmentable<Shard>
        implements Shard {
    
        private final InstanceIdentifier<?> _prefix;
        private final Replicas _replicas;
        private final ShardKey key;
    
        ShardImpl(ShardBuilder base) {
            super(base.augmentation);
            if (base.key() != null) {
                this.key = base.key();
            } else {
                this.key = new ShardKey(base.getPrefix());
            }
            this._prefix = key.getPrefix();
            this._replicas = base.getReplicas();
        }
    
        @Override
        public Class<Shard> getImplementedInterface() {
            return Shard.class;
        }
    
        @Override
        public ShardKey key() {
            return key;
        }
        
        @Override
        public InstanceIdentifier<?> getPrefix() {
            return _prefix;
        }
        
        @Override
        public Replicas getReplicas() {
            return _replicas;
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int prime = 31;
            int result = 1;
            result = prime * result + Objects.hashCode(_prefix);
            result = prime * result + Objects.hashCode(_replicas);
            result = prime * result + Objects.hashCode(augmentations());
        
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!Shard.class.equals(((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            Shard other = (Shard)obj;
            if (!Objects.equals(_prefix, other.getPrefix())) {
                return false;
            }
            if (!Objects.equals(_replicas, other.getReplicas())) {
                return false;
            }
            if (getClass() == obj.getClass()) {
                // Simple case: we are comparing against self
                ShardImpl otherImpl = (ShardImpl) obj;
                if (!Objects.equals(augmentations(), otherImpl.augmentations())) {
                    return false;
                }
            } else {
                // Hard case: compare our augments with presence there...
                for (Map.Entry<Class<? extends Augmentation<Shard>>, Augmentation<Shard>> e : augmentations().entrySet()) {
                    if (!e.getValue().equals(other.augmentation(e.getKey()))) {
                        return false;
                    }
                }
                // .. and give the other one the chance to do the same
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }
    
        @Override
        public String toString() {
            final MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper("Shard");
            CodeHelpers.appendValue(helper, "_prefix", _prefix);
            CodeHelpers.appendValue(helper, "_replicas", _replicas);
            CodeHelpers.appendValue(helper, "augmentation", augmentations().values());
            return helper.toString();
        }
    }
}
