package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.clustering.prefix.shard.configuration.rev170110.prefix.shards.shard;
import java.lang.String;
import java.util.List;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.clustering.prefix.shard.configuration.rev170110.$YangModuleInfoImpl;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.clustering.prefix.shard.configuration.rev170110.prefix.shards.Shard;
import org.opendaylight.yangtools.yang.binding.Augmentable;
import org.opendaylight.yangtools.yang.binding.ChildOf;
import org.opendaylight.yangtools.yang.common.QName;

/**
 * List of cluster member nodes that this shard is replicated on
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>prefix-shard-configuration</b>
 * <pre>
 * container replicas {
 *   leaf-list replica {
 *     type string;
 *   }
 * }
 * </pre>The schema path to identify an instance is
 * <i>prefix-shard-configuration/prefix-shards/shard/replicas</i>
 *
 * <p>To create instances of this class use {@link ReplicasBuilder}.
 * @see ReplicasBuilder
 *
 */
public interface Replicas
    extends
    ChildOf<Shard>,
    Augmentable<Replicas>
{



    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("replicas");

    /**
     * @return <code>java.util.List</code> <code>replica</code>, or <code>null</code> if not present
     */
    @Nullable List<String> getReplica();

}

