package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.clustering.prefix.shard.configuration.rev170110.prefix.shards.shard;
import com.google.common.base.MoreObjects;
import java.lang.Class;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

/**
 * Class that builds {@link ReplicasBuilder} instances.
 *
 * @see ReplicasBuilder
 *
 */
public class ReplicasBuilder implements Builder<Replicas> {

    private List<String> _replica;


    Map<Class<? extends Augmentation<Replicas>>, Augmentation<Replicas>> augmentation = Collections.emptyMap();

    public ReplicasBuilder() {
    }

    public ReplicasBuilder(Replicas base) {
        if (base instanceof AugmentationHolder) {
            @SuppressWarnings("unchecked")
            Map<Class<? extends Augmentation<Replicas>>, Augmentation<Replicas>> aug =((AugmentationHolder<Replicas>) base).augmentations();
            if (!aug.isEmpty()) {
                this.augmentation = new HashMap<>(aug);
            }
        }
        this._replica = base.getReplica();
    }


    public List<String> getReplica() {
        return _replica;
    }

    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<Replicas>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(CodeHelpers.nonNullValue(augmentationType, "augmentationType"));
    }

    public ReplicasBuilder setReplica(final List<String> values) {
        this._replica = values;
        return this;
    }
    
    
    public ReplicasBuilder addAugmentation(Class<? extends Augmentation<Replicas>> augmentationType, Augmentation<Replicas> augmentationValue) {
        if (augmentationValue == null) {
            return removeAugmentation(augmentationType);
        }
    
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }
    
    public ReplicasBuilder removeAugmentation(Class<? extends Augmentation<Replicas>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public Replicas build() {
        return new ReplicasImpl(this);
    }

    private static final class ReplicasImpl
        extends AbstractAugmentable<Replicas>
        implements Replicas {
    
        private final List<String> _replica;
    
        ReplicasImpl(ReplicasBuilder base) {
            super(base.augmentation);
            this._replica = base.getReplica();
        }
    
        @Override
        public Class<Replicas> getImplementedInterface() {
            return Replicas.class;
        }
    
        @Override
        public List<String> getReplica() {
            return _replica;
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int prime = 31;
            int result = 1;
            result = prime * result + Objects.hashCode(_replica);
            result = prime * result + Objects.hashCode(augmentations());
        
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!Replicas.class.equals(((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            Replicas other = (Replicas)obj;
            if (!Objects.equals(_replica, other.getReplica())) {
                return false;
            }
            if (getClass() == obj.getClass()) {
                // Simple case: we are comparing against self
                ReplicasImpl otherImpl = (ReplicasImpl) obj;
                if (!Objects.equals(augmentations(), otherImpl.augmentations())) {
                    return false;
                }
            } else {
                // Hard case: compare our augments with presence there...
                for (Map.Entry<Class<? extends Augmentation<Replicas>>, Augmentation<Replicas>> e : augmentations().entrySet()) {
                    if (!e.getValue().equals(other.augmentation(e.getKey()))) {
                        return false;
                    }
                }
                // .. and give the other one the chance to do the same
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }
    
        @Override
        public String toString() {
            final MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper("Replicas");
            CodeHelpers.appendValue(helper, "_replica", _replica);
            CodeHelpers.appendValue(helper, "augmentation", augmentations().values());
            return helper.toString();
        }
    }
}
