/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.akka.osgi.impl;

import akka.actor.ActorSystem;
import com.typesafe.config.Config;
import java.util.concurrent.TimeoutException;
import org.opendaylight.controller.cluster.ActorSystemProvider;
import org.opendaylight.controller.cluster.ActorSystemProviderListener;
import org.opendaylight.controller.cluster.akka.impl.ActorSystemProviderImpl;
import org.opendaylight.controller.cluster.akka.impl.AkkaConfigFactory;
import org.opendaylight.controller.cluster.akka.osgi.impl.BundleClassLoaderFactory;
import org.opendaylight.controller.cluster.akka.osgi.impl.QuarantinedMonitorActorPropsFactory;
import org.opendaylight.controller.cluster.common.actor.AkkaConfigurationReader;
import org.opendaylight.yangtools.concepts.ObjectRegistration;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.concurrent.Await;
import scala.concurrent.duration.Duration;

@Component(immediate=true)
public final class OSGiActorSystemProvider
implements ActorSystemProvider {
    private static final Logger LOG = LoggerFactory.getLogger(OSGiActorSystemProvider.class);
    private ActorSystemProviderImpl delegate;

    @Activate
    public OSGiActorSystemProvider(@Reference AkkaConfigurationReader reader, BundleContext bundleContext) {
        LOG.info("Actor System provider starting");
        Config akkaConfig = AkkaConfigFactory.createAkkaConfig(reader);
        this.delegate = new ActorSystemProviderImpl(BundleClassLoaderFactory.createClassLoader(bundleContext), QuarantinedMonitorActorPropsFactory.createProps(bundleContext, akkaConfig), akkaConfig);
        LOG.info("Actor System provider started");
    }

    @Deactivate
    void deactivate() throws TimeoutException, InterruptedException {
        LOG.info("Actor System provider stopping");
        Await.result(this.delegate.asyncClose(), (Duration)Duration.Inf());
        this.delegate = null;
        LOG.info("Actor System provider stopped");
    }

    public ActorSystem getActorSystem() {
        return this.delegate.getActorSystem();
    }

    public ObjectRegistration<ActorSystemProviderListener> registerActorSystemProviderListener(ActorSystemProviderListener listener) {
        return this.delegate.registerActorSystemProviderListener(listener);
    }
}

