/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.datastore;

import akka.actor.ActorRef;
import org.checkerframework.checker.lock.qual.GuardedBy;
import org.opendaylight.controller.cluster.datastore.DataTreeChangeListenerSupport;
import org.opendaylight.controller.cluster.datastore.messages.RegisterDataTreeChangeListener;
import org.opendaylight.yangtools.concepts.Registration;

class DelayedDataTreeChangeListenerRegistration
implements Registration {
    private final RegisterDataTreeChangeListener registrationMessage;
    private final ActorRef registrationActor;
    private @GuardedBy(value={"this"}) boolean closed;

    DelayedDataTreeChangeListenerRegistration(RegisterDataTreeChangeListener registrationMessage, ActorRef registrationActor) {
        this.registrationMessage = registrationMessage;
        this.registrationActor = registrationActor;
    }

    synchronized void doRegistration(DataTreeChangeListenerSupport support) {
        if (!this.closed) {
            support.doRegistration(this.registrationMessage, this.registrationActor);
        }
    }

    public synchronized void close() {
        this.closed = true;
    }
}

