/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.datastore.config;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.opendaylight.controller.cluster.access.concepts.MemberName;
import org.opendaylight.controller.cluster.datastore.config.Configuration;
import org.opendaylight.controller.cluster.datastore.config.FileModuleShardConfigProvider;
import org.opendaylight.controller.cluster.datastore.config.ModuleConfig;
import org.opendaylight.controller.cluster.datastore.config.ModuleShardConfigProvider;
import org.opendaylight.controller.cluster.datastore.config.ModuleShardConfiguration;
import org.opendaylight.controller.cluster.datastore.config.ShardConfig;
import org.opendaylight.controller.cluster.datastore.shardstrategy.ShardStrategy;
import org.opendaylight.controller.cluster.datastore.shardstrategy.ShardStrategyFactory;

public class ConfigurationImpl
implements Configuration {
    private volatile Map<String, ModuleConfig> moduleConfigMap;
    private volatile Map<String, String> namespaceToModuleName;
    private volatile Set<String> allShardNames;

    public ConfigurationImpl(String moduleShardsConfigPath, String modulesConfigPath) {
        this(new FileModuleShardConfigProvider(moduleShardsConfigPath, modulesConfigPath));
    }

    @SuppressFBWarnings(value={"MC_OVERRIDABLE_METHOD_CALL_IN_CONSTRUCTOR"}, justification="Subclassed for testing")
    public ConfigurationImpl(ModuleShardConfigProvider provider) {
        ImmutableMap.Builder mapBuilder = ImmutableMap.builder();
        for (Map.Entry<String, ModuleConfig.Builder> e : provider.retrieveModuleConfigs(this).entrySet()) {
            mapBuilder.put((Object)e.getKey(), (Object)e.getValue().build());
        }
        this.moduleConfigMap = mapBuilder.build();
        this.allShardNames = ConfigurationImpl.createAllShardNames(this.moduleConfigMap.values());
        this.namespaceToModuleName = ConfigurationImpl.createNamespaceToModuleName(this.moduleConfigMap.values());
    }

    private static Set<String> createAllShardNames(Iterable<ModuleConfig> moduleConfigs) {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (ModuleConfig moduleConfig : moduleConfigs) {
            builder.addAll(moduleConfig.getShardNames());
        }
        return builder.build();
    }

    private static Map<String, String> createNamespaceToModuleName(Iterable<ModuleConfig> moduleConfigs) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (ModuleConfig moduleConfig : moduleConfigs) {
            if (moduleConfig.getNamespace() == null) continue;
            builder.put((Object)moduleConfig.getNamespace(), (Object)moduleConfig.getName());
        }
        return builder.build();
    }

    @Override
    public Collection<String> getMemberShardNames(MemberName memberName) {
        Objects.requireNonNull(memberName, "memberName should not be null");
        ArrayList<String> shards = new ArrayList<String>();
        for (ModuleConfig moduleConfig : this.moduleConfigMap.values()) {
            for (ShardConfig shardConfig : moduleConfig.getShardConfigs()) {
                if (!shardConfig.getReplicas().contains(memberName)) continue;
                shards.add(shardConfig.getName());
            }
        }
        return shards;
    }

    @Override
    public String getModuleNameFromNameSpace(String nameSpace) {
        return this.namespaceToModuleName.get(Objects.requireNonNull(nameSpace, "nameSpace should not be null"));
    }

    @Override
    public ShardStrategy getStrategyForModule(String moduleName) {
        ModuleConfig moduleConfig = this.getModuleConfig(moduleName);
        return moduleConfig != null ? moduleConfig.getShardStrategy() : null;
    }

    @Override
    public String getShardNameForModule(String moduleName) {
        Collection<ShardConfig> shardConfigs;
        ModuleConfig moduleConfig = this.getModuleConfig(moduleName);
        if (moduleConfig != null && !(shardConfigs = moduleConfig.getShardConfigs()).isEmpty()) {
            return shardConfigs.iterator().next().getName();
        }
        return null;
    }

    private ModuleConfig getModuleConfig(String moduleName) {
        return this.moduleConfigMap.get(Objects.requireNonNull(moduleName, "moduleName should not be null"));
    }

    @Override
    public Collection<MemberName> getMembersFromShardName(String shardName) {
        ConfigurationImpl.checkNotNullShardName(shardName);
        for (ModuleConfig moduleConfig : this.moduleConfigMap.values()) {
            ShardConfig shardConfig = moduleConfig.getShardConfig(shardName);
            if (shardConfig == null) continue;
            return shardConfig.getReplicas();
        }
        return List.of();
    }

    private static void checkNotNullShardName(String shardName) {
        Objects.requireNonNull(shardName, "shardName should not be null");
    }

    @Override
    public Set<String> getAllShardNames() {
        return this.allShardNames;
    }

    @Override
    public Collection<MemberName> getUniqueMemberNamesForAllShards() {
        HashSet<MemberName> allNames = new HashSet<MemberName>();
        for (String shardName : this.getAllShardNames()) {
            allNames.addAll(this.getMembersFromShardName(shardName));
        }
        return allNames;
    }

    @Override
    public synchronized void addModuleShardConfiguration(ModuleShardConfiguration config) {
        Objects.requireNonNull(config, "ModuleShardConfiguration should not be null");
        ModuleConfig moduleConfig = ModuleConfig.builder(config.getModuleName()).nameSpace(config.getNamespace().toString()).shardStrategy(this.createShardStrategy(config.getModuleName(), config.getShardStrategyName())).shardConfig(config.getShardName(), config.getShardMemberNames()).build();
        this.updateModuleConfigMap(moduleConfig);
        this.namespaceToModuleName = ImmutableMap.builder().putAll(this.namespaceToModuleName).put((Object)moduleConfig.getNamespace(), (Object)moduleConfig.getName()).build();
        this.allShardNames = ImmutableSet.builder().addAll(this.allShardNames).add((Object)config.getShardName()).build();
    }

    private ShardStrategy createShardStrategy(String moduleName, String shardStrategyName) {
        return ShardStrategyFactory.newShardStrategyInstance(moduleName, shardStrategyName, this);
    }

    @Override
    public boolean isShardConfigured(String shardName) {
        ConfigurationImpl.checkNotNullShardName(shardName);
        return this.allShardNames.contains(shardName);
    }

    @Override
    public void addMemberReplicaForShard(String shardName, MemberName newMemberName) {
        ConfigurationImpl.checkNotNullShardName(shardName);
        Objects.requireNonNull(newMemberName, "MemberName should not be null");
        for (ModuleConfig moduleConfig : this.moduleConfigMap.values()) {
            ShardConfig shardConfig = moduleConfig.getShardConfig(shardName);
            if (shardConfig == null) continue;
            HashSet<MemberName> replicas = new HashSet<MemberName>(shardConfig.getReplicas());
            replicas.add(newMemberName);
            this.updateModuleConfigMap(ModuleConfig.builder(moduleConfig).shardConfig(shardName, replicas).build());
            return;
        }
    }

    @Override
    public void removeMemberReplicaForShard(String shardName, MemberName newMemberName) {
        ConfigurationImpl.checkNotNullShardName(shardName);
        Objects.requireNonNull(newMemberName, "MemberName should not be null");
        for (ModuleConfig moduleConfig : this.moduleConfigMap.values()) {
            ShardConfig shardConfig = moduleConfig.getShardConfig(shardName);
            if (shardConfig == null) continue;
            HashSet<MemberName> replicas = new HashSet<MemberName>(shardConfig.getReplicas());
            replicas.remove(newMemberName);
            this.updateModuleConfigMap(ModuleConfig.builder(moduleConfig).shardConfig(shardName, replicas).build());
            return;
        }
    }

    private void updateModuleConfigMap(ModuleConfig moduleConfig) {
        HashMap<String, ModuleConfig> newModuleConfigMap = new HashMap<String, ModuleConfig>(this.moduleConfigMap);
        newModuleConfigMap.put(moduleConfig.getName(), moduleConfig);
        this.moduleConfigMap = ImmutableMap.copyOf(newModuleConfigMap);
    }
}

