/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.datastore.utils;

import com.google.common.annotations.Beta;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableRangeSet;
import com.google.common.collect.Range;
import com.google.common.primitives.UnsignedLong;
import java.util.Iterator;
import java.util.NavigableSet;
import java.util.TreeSet;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.controller.cluster.datastore.utils.ImmutableUnsignedLongSet;
import org.opendaylight.controller.cluster.datastore.utils.UnsignedLongSet;
import org.opendaylight.yangtools.concepts.Mutable;

@Beta
public final class MutableUnsignedLongSet
extends UnsignedLongSet
implements Mutable {
    MutableUnsignedLongSet(TreeSet<UnsignedLongSet.Entry> ranges) {
        super(ranges);
    }

    public static @NonNull MutableUnsignedLongSet of() {
        return new MutableUnsignedLongSet(new TreeSet<UnsignedLongSet.Entry>());
    }

    public static @NonNull MutableUnsignedLongSet of(long ... ulongs) {
        MutableUnsignedLongSet ret = MutableUnsignedLongSet.of();
        for (long longBits : ulongs) {
            ret.add(longBits);
        }
        return ret;
    }

    @Override
    public ImmutableUnsignedLongSet immutableCopy() {
        return ImmutableUnsignedLongSet.copyOf(this);
    }

    public void add(long longBits) {
        MutableUnsignedLongSet.addOne(this.trustedRanges(), UnsignedLongSet.Entry.of(longBits));
    }

    public void addAll(UnsignedLongSet other) {
        NavigableSet<UnsignedLongSet.Entry> ranges = this.trustedRanges();
        for (UnsignedLongSet.Entry range : other.trustedRanges()) {
            if (range.lowerBits == range.upperBits) {
                MutableUnsignedLongSet.addOne(ranges, range);
                continue;
            }
            MutableUnsignedLongSet.addRange(ranges, range);
        }
    }

    private static void addOne(NavigableSet<UnsignedLongSet.Entry> ranges, UnsignedLongSet.Entry range) {
        Iterator<UnsignedLongSet.Entry> tailIt;
        long longBits = range.lowerBits;
        Iterator<UnsignedLongSet.Entry> headIt = ranges.headSet(range, true).descendingIterator();
        if (headIt.hasNext()) {
            UnsignedLongSet.Entry head = headIt.next();
            if (Long.compareUnsigned(head.upperBits, longBits) >= 0) {
                return;
            }
            if (head.upperBits + 1L == longBits) {
                headIt.remove();
                Iterator<UnsignedLongSet.Entry> tailIt2 = ranges.tailSet(range, false).iterator();
                if (tailIt2.hasNext()) {
                    UnsignedLongSet.Entry tail = tailIt2.next();
                    if (tail.lowerBits - 1L == longBits) {
                        tailIt2.remove();
                        ranges.add(tail.withLower(head.lowerBits));
                        return;
                    }
                }
                ranges.add(head.withUpper(longBits));
                return;
            }
        }
        if ((tailIt = ranges.tailSet(range, false).iterator()).hasNext()) {
            UnsignedLongSet.Entry tail = tailIt.next();
            if (tail.lowerBits - 1L == longBits) {
                tailIt.remove();
                ranges.add(tail.withLower(longBits));
                return;
            }
        }
        ranges.add(range);
    }

    private static void addRange(NavigableSet<UnsignedLongSet.Entry> ranges, UnsignedLongSet.Entry range) {
        Iterator<UnsignedLongSet.Entry> tailIt;
        Iterator<UnsignedLongSet.Entry> headIt = ranges.headSet(range, true).descendingIterator();
        boolean hasFloor = headIt.hasNext();
        if (hasFloor) {
            UnsignedLongSet.Entry floor = headIt.next();
            if (Long.compareUnsigned(floor.upperBits, range.upperBits) < 0 && Long.compareUnsigned(floor.upperBits + 1L, range.lowerBits) >= 0) {
                headIt.remove();
                ranges.add(MutableUnsignedLongSet.expandFloor(ranges, floor, range.upperBits));
                return;
            }
        }
        if ((tailIt = ranges.headSet(UnsignedLongSet.Entry.of(range.upperBits), true).descendingIterator()).hasNext()) {
            UnsignedLongSet.Entry upper = tailIt.next();
            tailIt.remove();
            if (!hasFloor) {
                ranges.headSet(upper, false).clear();
            }
            ranges.add(MutableUnsignedLongSet.expandCeiling(ranges, upper, range.lowerBits, range.upperBits));
            return;
        }
        ranges.add(range);
    }

    private static @NonNull UnsignedLongSet.Entry expandFloor(NavigableSet<UnsignedLongSet.Entry> ranges, UnsignedLongSet.Entry floor, long upperBits) {
        Iterator<UnsignedLongSet.Entry> tailIt = ranges.tailSet(floor, false).iterator();
        long nextLower = upperBits + 1L;
        while (tailIt.hasNext()) {
            UnsignedLongSet.Entry tail = tailIt.next();
            if (Long.compareUnsigned(tail.lowerBits, nextLower) > 0) break;
            tailIt.remove();
            if (Long.compareUnsigned(tail.upperBits, nextLower) < 0) continue;
            return floor.withUpper(tail.upperBits);
        }
        return floor.withUpper(upperBits);
    }

    private static @NonNull UnsignedLongSet.Entry expandCeiling(NavigableSet<UnsignedLongSet.Entry> ranges, UnsignedLongSet.Entry ceiling, long lowerBits, long upperBits) {
        if (Long.compareUnsigned(ceiling.upperBits, upperBits) >= 0) {
            return ceiling.withLower(lowerBits);
        }
        long newUpper = upperBits;
        Iterator<UnsignedLongSet.Entry> tailIt = ranges.tailSet(ceiling, false).iterator();
        if (tailIt.hasNext()) {
            UnsignedLongSet.Entry tail = tailIt.next();
            if (Long.compareUnsigned(tail.lowerBits, newUpper + 1L) <= 0) {
                tailIt.remove();
                newUpper = tail.upperBits;
            }
        }
        return UnsignedLongSet.Entry.of(lowerBits, newUpper);
    }

    public ImmutableRangeSet<UnsignedLong> toRangeSet() {
        return ImmutableRangeSet.copyOf((Iterable)Collections2.transform(this.trustedRanges(), entry -> Range.closedOpen((Comparable)UnsignedLong.fromLongBits((long)entry.lowerBits), (Comparable)UnsignedLong.fromLongBits((long)(entry.upperBits + 1L)))));
    }
}

